/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.cm;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import oracle.jdeveloper.cm.CMException;
import oracle.jdeveloper.cm.ConnectionDescriptor;
import oracle.jdeveloper.cm.ConnectionManager;
import oracle.jdeveloper.cm.WritableConnectionStore;

public final class PropertiesConnectionStore
implements WritableConnectionStore {
    private static final String DEFAULT_FILE = "connections.properties";
    private final String fName;
    private final boolean isAbsolutePath;

    public PropertiesConnectionStore() {
        this("/connections.properties", false);
    }

    public PropertiesConnectionStore(String string, boolean bl) {
        this.fName = string;
        this.isAbsolutePath = bl;
    }

    public final void write(String string, List list, boolean bl) throws CMException {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            Properties properties = new Properties();
            Iterator iterator = list.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                ConnectionDescriptor connectionDescriptor = (ConnectionDescriptor)((ConnectionDescriptor)iterator.next()).clone();
                if (bl && !connectionDescriptor.isDeployPassword()) {
                    connectionDescriptor.remove("password");
                }
                String string2 = this.flattenConnectionDescriptor(connectionDescriptor);
                properties.put("CM_Connection" + ++n, string2);
            }
            properties.put("CM_NumConnections", new Integer(n).toString());
            properties.put("CM_Version", "50");
            properties.store(fileOutputStream, "Oracle JDeveloper 5.0 Connection List");
            fileOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new CMException(fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new CMException(iOException);
        }
    }

    public final List read() {
        try {
            InputStream inputStream;
            InputStream inputStream2 = inputStream = this.isAbsolutePath ? new FileInputStream(this.fName) : ConnectionManager.getInputStream(this.getClass(), this.fName);
            if (null == inputStream) {
                return null;
            }
            Properties properties = new Properties();
            properties.load(inputStream);
            return this.loadConnectionDescriptorsFromProperties(properties);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private final List loadConnectionDescriptorsFromProperties(Properties properties) throws IOException {
        ArrayList<ConnectionDescriptor> arrayList = null;
        String string = properties.getProperty("CM_NumConnections");
        if (null != string) {
            int n = Integer.parseInt(string);
            arrayList = new ArrayList<ConnectionDescriptor>(n);
            for (int i = 1; i <= n; ++i) {
                String string2 = properties.getProperty("CM_Connection" + i);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.replace(',', '\n').getBytes());
                ConnectionDescriptor connectionDescriptor = new ConnectionDescriptor();
                connectionDescriptor.load(byteArrayInputStream);
                arrayList.add(connectionDescriptor);
            }
        }
        return arrayList;
    }

    private final String flattenConnectionDescriptor(ConnectionDescriptor connectionDescriptor) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            connectionDescriptor.store(byteArrayOutputStream, null);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        String string = byteArrayOutputStream.toString();
        return string.substring(string.indexOf(10)).trim().replace('\n', ',');
    }
}

