/*
 * Decompiled with CFR 0.152.
 */
package oracle.report.navigator;

import oracle.dbtools.raptor.utils.XMLHelper;
import org.w3c.dom.Node;

public class Folder {
    private String name;
    private String description;
    private String tooltip;

    public Folder() {
        this(null);
    }

    public Folder(String nm, String descr) {
        this.name = nm;
        this.description = descr;
    }

    public Folder(Node node) {
        if (node != null) {
            this.name = XMLHelper.getNodeValue((Node)node, (String)"name");
            this.description = XMLHelper.getNodeValue((Node)node, (String)"description");
            this.tooltip = XMLHelper.getNodeValue((Node)node, (String)"tooltip");
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        if (this.description == null) {
            return " ";
        }
        return this.description;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void settooltip(String tip) {
        this.tooltip = tip;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public String toXML(boolean detailsOnly) {
        StringBuilder sb = new StringBuilder();
        if (!detailsOnly) {
            sb.append("\t<folder>\n");
        }
        sb.append("\t\t<name><![CDATA[" + this.name + "]]></name>\n");
        sb.append("\t\t<description><![CDATA[" + this.description + "]]></description>\n");
        if (!detailsOnly) {
            sb.append("\t</folder>\n");
        }
        return sb.toString();
    }
}

