/*
 * Decompiled with CFR 0.152.
 */
package oracle.report.navigator;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.ToolTipManager;
import javax.swing.tree.TreePath;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.utils.Translate;
import oracle.dbtools.util.Resource;
import oracle.ide.Context;
import oracle.ide.controls.Toolbar;
import oracle.ide.docking.DockableWindow;
import oracle.ide.layout.Layout;
import oracle.ide.util.Assert;
import oracle.ide.view.View;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.report.addin.RepNav;
import oracle.report.addin.ReportAddin;
import oracle.report.navigator.Folder;
import oracle.report.navigator.NodeMoveTransferHandler;
import oracle.report.navigator.Report;
import oracle.report.navigator.ReportTree;
import oracle.report.navigator.TreeCellRenderer;
import oracle.report.navigator.TreeDropTarget;
import oracle.report.navigator.TreeNode;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ReportNavigatorWindow
extends DockableWindow {
    public static final String VIEW_ID = "REPORT_NAV_ID";
    private ReportTree _tree;
    private JScrollPane _scrollPane;
    private File file = new File(Resource.raptorUser.getAbsolutePath() + File.separator + "UserReports.xml");
    private TreeNode _sharedNode;

    public ReportNavigatorWindow() {
        super(ReportNavigatorWindow.getViewId());
    }

    public Icon getTabIcon() {
        return TreeCellRenderer.rIcon;
    }

    private static String getViewId() {
        return "REPORT_NAV.REPORT_NAV_ID";
    }

    public String getTabName() {
        return RepNav.getString(0);
    }

    public String getTitleName() {
        return RepNav.getString(1);
    }

    public void buildTree() {
        if (this._tree != null) {
            this._tree.removeAll();
            this._sharedNode = null;
        }
        this.parseXML(Resource.getResourceAsStream(ReportNavigatorWindow.class, (String)"reports.xml"));
        if (System.getProperty("raptor.shared.reports") != null) {
            String[] files = System.getProperty("raptor.shared.reports").split("[:;]");
            File f = null;
            for (int i = 0; i < files.length; ++i) {
                f = new File(files[i]);
                try {
                    if (!f.exists()) continue;
                    ReportAddin.registerReport(f.toURL());
                    continue;
                }
                catch (Exception e) {
                    System.err.println("Could not load Report File:" + f.toString());
                }
            }
        }
        for (URL url : ReportAddin.getRegisterReport()) {
            try {
                InputStream in = url.openStream();
                this.appendSharedXML(in);
            }
            catch (Exception e) {
                System.err.println("Could not load Report URL:" + url.toString());
            }
        }
    }

    public Component getGUI() {
        if (this._tree == null || Resource.DEV_MODE) {
            this.buildTree();
            this._scrollPane = new JScrollPane(this._tree);
            this._scrollPane.setBorder(BorderFactory.createEmptyBorder());
        }
        return this._scrollPane;
    }

    public void buildToolBar() {
        this.setToolbarVisible(true);
        Toolbar toolbar = this.getToolbar();
        JButton button = new JButton();
        button.setIcon(ConnectionArb.getIcon((int)258));
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ReportNavigatorWindow.this.buildTree();
            }
        });
        toolbar.add((Component)button);
    }

    public Context getContext(EventObject event) {
        return Context.newIdeContext((View)this, (EventObject)event);
    }

    public int getDefaultVisibility(Layout layout) {
        return 1;
    }

    protected TreeCellRenderer getCellRenderer() {
        return null;
    }

    protected String getAccessibleName() {
        return null;
    }

    private TreeNode initTree() {
        TreeNode top = new TreeNode(Translate.translate((String)"Reports"), "");
        this._tree = new ReportTree(top){
            private static final long serialVersionUID = 1L;

            public String getToolTipText(MouseEvent evt) {
                if (this.getRowForLocation(evt.getX(), evt.getY()) == -1) {
                    return null;
                }
                TreePath curPath = this.getPathForLocation(evt.getX(), evt.getY());
                return ((TreeNode)curPath.getLastPathComponent()).getToolTipText();
            }
        };
        this._tree.setToolTipText("");
        this._tree.getSelectionModel().setSelectionMode(1);
        this._tree.setShowsRootHandles(true);
        this._tree.setCellRenderer(new TreeCellRenderer());
        NodeMoveTransferHandler handler = new NodeMoveTransferHandler();
        this._tree.setTransferHandler(handler);
        this._tree.setDropTarget(new TreeDropTarget(handler));
        this._tree.setDragEnabled(true);
        ToolTipManager.sharedInstance().registerComponent(this._tree);
        return top;
    }

    private void parseXML(InputStream xml) {
        DOMParser parser = new DOMParser();
        parser.setPreserveWhitespace(false);
        try {
            parser.parse(xml);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        XMLDocument document = parser.getDocument();
        Assert.startTiming((String)(((Object)((Object)this)).getClass().toString() + Thread.currentThread().getStackTrace().toString()), null, (boolean)false);
        this.processNode(this.initTree(), (Node)document);
        Assert.endTiming((String)(((Object)((Object)this)).getClass().toString() + Thread.currentThread().getStackTrace().toString()), (String)"Reports Loaded", (String)"", (boolean)false);
    }

    private void parseUserXML(TreeNode node) {
        try {
            DOMParser parser = new DOMParser();
            BufferedReader xml = new BufferedReader(new BufferedReader(new InputStreamReader(new FileInputStream(this.file))));
            parser.parse((Reader)xml);
            XMLDocument document = parser.getDocument();
            Assert.startTiming((String)(((Object)((Object)this)).getClass().toString() + Thread.currentThread().getStackTrace().toString()), null, (boolean)false);
            this.processNode(node, (Node)document);
            Assert.endTiming((String)(((Object)((Object)this)).getClass().toString() + Thread.currentThread().getStackTrace().toString()), (String)"Reports Loaded", (String)"", (boolean)false);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void appendSharedXML(InputStream in) {
        try {
            DOMParser parser = new DOMParser();
            BufferedReader xml = new BufferedReader(new BufferedReader(new InputStreamReader(in)));
            if (this._sharedNode == null) {
                TreeNode root = (TreeNode)this._tree.getModel().getRoot();
                Folder fObject = new Folder("Shared Reports", "Shared Reports");
                this._sharedNode = new TreeNode("Shared Reports", "Shared Reports");
                this._sharedNode.setFolder(fObject);
                this._sharedNode.setAllowsChildren(true);
                root.add(this._sharedNode);
            }
            parser.parse((Reader)xml);
            XMLDocument document = parser.getDocument();
            Assert.startTiming((String)(((Object)((Object)this)).getClass().toString() + Thread.currentThread().getStackTrace().toString()), null, (boolean)false);
            this.processNode(this._sharedNode, (Node)document);
            Assert.endTiming((String)(((Object)((Object)this)).getClass().toString() + Thread.currentThread().getStackTrace().toString()), (String)"Shared Reports Loaded", (String)"", (boolean)false);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void processNode(TreeNode parent, Node node) {
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (children.item(i).getNodeName().equalsIgnoreCase("folder")) {
                this.processFolder(parent, children.item(i));
                continue;
            }
            if (children.item(i).getNodeName().equalsIgnoreCase("report")) {
                this.processReport(parent, children.item(i));
                continue;
            }
            if (!children.item(i).getNodeName().equalsIgnoreCase(Translate.translate((String)"Reports"))) continue;
            this.processNode(parent, children.item(i));
        }
    }

    private void processFolder(TreeNode parent, Node folder) {
        TreeNode user = null;
        Folder fObject = new Folder(folder);
        TreeNode thisNode = new TreeNode(fObject.getName(), fObject.getTooltip());
        thisNode.setFolder(fObject);
        thisNode.setAllowsChildren(true);
        parent.add(thisNode);
        if (fObject.getName().equals(Translate.translate((String)"User Defined Reports"))) {
            user = thisNode;
            this.parseUserXML(user);
        }
        NodeList children = folder.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (children.item(i).getNodeName().equalsIgnoreCase("folder")) {
                this.processFolder(thisNode, children.item(i));
                continue;
            }
            if (children.item(i).getNodeName().equalsIgnoreCase("report")) {
                this.processReport(thisNode, children.item(i));
                continue;
            }
            if (children.item(i).getNodeName().equalsIgnoreCase("description") || children.item(i).getNodeName().equalsIgnoreCase("name")) continue;
            Assert.print((String)("Folder:Unsupported node in report.xml:" + children.item(i).getNodeName()));
        }
    }

    private void processReport(TreeNode parent, Node report) {
        Report rObject = new Report(report);
        rObject.setQuery(Query.getQueries((Node)report));
        TreeNode thisNode = new TreeNode(rObject.getName(), rObject.getToolTip());
        thisNode.setReport(rObject);
        thisNode.setAllowsChildren(false);
        parent.add(thisNode);
    }
}

