/*
 * Decompiled with CFR 0.152.
 */
package oracle.report.navigator;

import java.io.IOException;
import java.net.URL;
import javax.swing.Icon;
import oracle.ide.model.Attributes;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFactory;
import oracle.report.navigator.Report;

public class ReportNode
extends Node {
    private Report _report;
    private static int _nodeId;
    private boolean _defaultEditor = true;
    public static final int RELATION_NODE_CHANGED_MESSAGE_ID;
    private Attributes _attrs = new ElementAttributes(ElementAttributes.CLOSEABLE);

    public ReportNode(Report report) {
        URL url = URLFactory.newURL((String)"ide.reportNode", (String)("node" + _nodeId++));
        this.setURL(url);
        this.setReport(report);
        try {
            this.open();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Report getReport() {
        return this._report;
    }

    public void setReport(Report report) {
        this._report = report;
        this.update();
    }

    public Attributes getAttributes() {
        return this._attrs;
    }

    public void update() {
        this.notifyObservers((Object)this, new UpdateMessage(RELATION_NODE_CHANGED_MESSAGE_ID, (Object)this));
        this.notifyObservers((Object)this, new UpdateMessage(UpdateMessage.OBJECT_RENAMED, (Object)this));
    }

    public String getShortLabel() {
        String ret = "";
        if (this._report != null) {
            ret = this._report.getName();
        }
        return ret;
    }

    public Icon getIcon() {
        Icon ret = null;
        return ret;
    }

    public String getLongLabel() {
        return this.getShortLabel();
    }

    static {
        RELATION_NODE_CHANGED_MESSAGE_ID = UpdateMessage.newMessageID((String)(Report.class.getName() + ".reportChanged"));
    }
}

