/*
 * Decompiled with CFR 0.152.
 */
package oracle.report.navigator;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventObject;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.utils.Translate;
import oracle.dbtools.util.Resource;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.model.UpdateMessage;
import oracle.report.navigator.Folder;
import oracle.report.navigator.Report;
import oracle.report.navigator.TreeController;
import oracle.report.navigator.TreeNode;
import org.w3c.dom.Element;

public class ReportTree
extends JTree {
    private static final long serialVersionUID = 1L;
    public static final int RELATION_NODE_CHANGED_MESSAGE_ID = UpdateMessage.newMessageID((String)(ReportTree.class.getName() + ".relationNodeChanged"));
    TreeNode oldNode = null;
    JTree tree;
    TreePath path;
    TreePath oldPath;
    TreeNode node;
    final ContextMenu _menu = new ContextMenu();
    Element domRoot = null;
    private File file = new File(Resource.raptorUser.getAbsolutePath() + File.separator + "UserReports.xml");

    public ReportTree(TreeNode dmtn) {
        super(dmtn);
        this._menu.addContextMenuListener((ContextMenuListener)TreeController.getInstance());
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 1) {
                    ReportTree.this.tree = (JTree)e.getComponent();
                    ReportTree.this.oldPath = ReportTree.this.tree.getPathForLocation(e.getX(), e.getY());
                    ReportTree.this.tree.addSelectionPath(ReportTree.this.oldPath);
                }
            }

            public void mouseReleased(MouseEvent e) {
                ReportTree.this.tree = (JTree)e.getComponent();
                ReportTree.this.path = ReportTree.this.tree.getPathForLocation(e.getX(), e.getY());
                if (e.getButton() == 3) {
                    if (ReportTree.this.path != null && ReportTree.this.path.getLastPathComponent() != null && ((TreeNode)ReportTree.this.path.getLastPathComponent()).getType() != null) {
                        TreeNode node = (TreeNode)ReportTree.this.path.getLastPathComponent();
                        Context c = new Context();
                        ReportTree.this.tree = (JTree)e.getComponent();
                        c.setEvent((EventObject)e);
                        c.setProperty("TreeNode", (Object)node);
                        c.setProperty("ReportTree", (Object)ReportTree.this.tree);
                        ReportTree.this._menu.show(c);
                    }
                } else if (e.getButton() == 1 && ReportTree.this.path != null) {
                    Report report;
                    ReportTree.this.node = (TreeNode)ReportTree.this.path.getLastPathComponent();
                    if (ReportTree.this.node.getType() != null && ReportTree.this.node.getType().equalsIgnoreCase("report") && ReportTree.this.oldPath == ReportTree.this.path && (report = ReportTree.this.node.getReport()).getEnable()) {
                        TreeController.getInstance().openReport(report, false);
                    }
                }
            }
        });
        this.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ReportTree.this.tree = (JTree)e.getComponent();
                    ReportTree.this.path = ReportTree.this.tree.getSelectionPath();
                    if (ReportTree.this.path != null) {
                        Report report;
                        ReportTree.this.node = (TreeNode)ReportTree.this.path.getLastPathComponent();
                        if (ReportTree.this.node.getType() != null && ReportTree.this.node.getType().equalsIgnoreCase("report") && (report = ReportTree.this.node.getReport()).getEnable()) {
                            TreeController.getInstance().openReport(report, false);
                        }
                    }
                }
            }
        });
    }

    public TreeNode newNode(TreeNode node) {
        TreeNode nNode = null;
        String tt = node.getToolTipText() == null ? null : node.getToolTipText();
        nNode = new TreeNode(new String(node.getName()), tt);
        if (node.getType().equals("folder")) {
            Folder folder = new Folder(new String(node.getFolder().getName()), new String(node.getFolder().getDescription()));
            nNode.setFolder(folder);
        } else {
            Report oldRep = node.getReport();
            String oldDescr = oldRep.getDescription() != null ? new String(oldRep.getDescription()) : null;
            String oldTT = oldRep.getToolTip() != null ? new String(oldRep.getToolTip()) : null;
            Report report = new Report(new String(node.getReport().getName()), oldDescr, new String(Boolean.toString(node.getReport().getEnable())), oldTT);
            ArrayList<Query> newQueries = new ArrayList<Query>(node.getReport().getQueryList());
            report.setQuery(newQueries);
            nNode.setReport(report);
        }
        nNode.setAllowsChildren(new Boolean(node.getAllowsChildren()));
        nNode.setUserObject(new String((String)node.getUserObject()));
        return nNode;
    }

    public String checkName(TreeNode node, TreeNode parent) {
        String name;
        Boolean valid = false;
        String newName = name = node.getName();
        int x = 0;
        while (!valid.booleanValue()) {
            if (parent.getChildCount() == 0) {
                valid = true;
                continue;
            }
            Boolean found = false;
            for (int i = 0; i < parent.getChildCount(); ++i) {
                if (newName.equals(((TreeNode)parent.getChildAt(i)).getName())) {
                    newName = name + "(" + x + ")";
                    ++x;
                    valid = false;
                    found = true;
                    continue;
                }
                if (found.booleanValue()) continue;
                valid = true;
            }
        }
        return newName;
    }

    public TreeNode getUserRoot(TreeNode root) {
        for (int i = 0; root.getChildCount() > i; ++i) {
            TreeNode treeNode = (TreeNode)root.getChildAt(i);
            if (!treeNode.getType().equals("folder") || !treeNode.getUserObject().toString().equals(Translate.translate((String)"User Defined Reports"))) continue;
            return treeNode;
        }
        return null;
    }

    public void saveUserDef(TreeNode node) {
        TreeNode treeRoot = (TreeNode)node.getRoot();
        TreeNode userRoot = this.getUserRoot(treeRoot);
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.file));
            out.write("<reports>\n".getBytes());
            this.processFolder(userRoot, out);
            out.write("</reports>\n".getBytes());
            out.flush();
            out.close();
        }
        catch (Exception e) {
            System.err.println("OtherException: " + e);
        }
    }

    public void processFolder(TreeNode userRoot, BufferedOutputStream out) throws IOException {
        for (int i = 0; userRoot.getChildCount() > i; ++i) {
            TreeNode treeNode = (TreeNode)userRoot.getChildAt(i);
            if (treeNode.getType().equals("folder")) {
                out.write("\t<folder>\n".getBytes());
                out.write(treeNode.getFolder().toXML(true).getBytes());
                this.processFolder(treeNode, out);
                out.write("\t</folder>\n".getBytes());
                continue;
            }
            if (!treeNode.getType().equals("report")) continue;
            out.write(treeNode.getReport().toXML().getBytes());
        }
    }
}

