/*
 * Decompiled with CFR 0.152.
 */
package oracle.report.navigator;

import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import oracle.ide.resource.IdeIcons;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.report.navigator.TreeNode;

public class TreeCellRenderer
extends DefaultTreeCellRenderer {
    public static Icon fOpenIcon = IdeIcons.getIcon((int)4);
    public static Icon fCloseIcon = IdeIcons.getIcon((int)4);
    public static Icon rIcon = ConnectionArb.getIcon((int)413);
    public static Icon disabledIcon = ConnectionArb.getIcon((int)489);

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        this.fixIcon(value, expanded);
        if (value instanceof TreeNode && ((TreeNode)value).getReport() != null && !((TreeNode)value).getReport().getEnable()) {
            this.setBackground(Color.RED);
            this.setIcon(disabledIcon);
        }
        return this;
    }

    protected boolean fixIcon(Object value, boolean expanded) {
        TreeNode node = (TreeNode)value;
        String type = node.getType();
        if (type == null) {
            if (expanded) {
                this.setIcon(fOpenIcon);
                return false;
            }
            this.setIcon(fCloseIcon);
            return false;
        }
        if (type.equals("report")) {
            this.setIcon(rIcon);
            return true;
        }
        if (type.equals("folder") && expanded) {
            this.setIcon(fOpenIcon);
            return true;
        }
        if (type.equals("folder") && !expanded) {
            this.setIcon(fCloseIcon);
            return true;
        }
        this.setIcon(fOpenIcon);
        return false;
    }
}

