/*
 * Decompiled with CFR 0.152.
 */
package oracle.report.navigator;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.text.Document;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.controls.PropertyPanel;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.utils.Translate;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.WaitCursor;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Node;
import oracle.ide.util.Assert;
import oracle.ide.util.IdeUtil;
import oracle.ide.view.ViewEvent;
import oracle.ide.view.ViewListener;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.editor.plugins.LineHighlightPlugin;
import oracle.report.addin.ReportEditor;
import oracle.report.navigator.Folder;
import oracle.report.navigator.Report;
import oracle.report.navigator.ReportNode;
import oracle.report.navigator.ReportTree;
import oracle.report.navigator.TreeNode;

public class TreeController
implements Controller,
ContextMenuListener {
    private static ArrayList<ReportEditor> _editors = new ArrayList();
    private static Object LOCK = new Object();
    private static TreeController _instance;
    private TreeNode pNode;
    private TreeNode cNode;
    private JEWTDialog dlg;
    private JEWTDialog dlg2;
    private ReportTree tree;
    private TreeNode treeNode;
    private JTextField gName = null;
    private JTextField gDesc = null;
    private JTextField gTip = null;
    private BasicEditorPane taSql = null;
    private static IdeAction openSame;
    private static IdeAction openNew;
    private static IdeAction showProperties;
    private static IdeAction addReport;
    private static IdeAction addFolder;
    private static IdeAction edit;
    private static IdeAction delete;
    private static IdeAction copy;
    private static IdeAction cut;
    private static IdeAction paste;
    private String ACTION = "";
    private TreeNode newNode;
    private TreeNode oldNode;

    private TreeController() {
        this.createActions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TreeController getInstance() {
        Object object = LOCK;
        synchronized (object) {
            if (_instance == null) {
                _instance = new TreeController();
            }
        }
        return _instance;
    }

    void createActions() {
        openSame = IdeAction.get((int)Ide.findOrCreateCmdID((String)"openSame"), (String)Translate.translate((String)"openSame"), (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)Translate.translate((String)"openSame"))));
        openSame.addController((Controller)this);
        openNew = IdeAction.get((int)Ide.findOrCreateCmdID((String)"openNew"), (String)Translate.translate((String)"openNew"), (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)Translate.translate((String)"openNew"))));
        openNew.addController((Controller)this);
        showProperties = IdeAction.get((int)Ide.findOrCreateCmdID((String)"showProperties"), (String)Translate.translate((String)"showProperties"), (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)Translate.translate((String)"showProperties"))));
        showProperties.addController((Controller)this);
        addFolder = IdeAction.get((int)Ide.findOrCreateCmdID((String)"addFolder"), (String)Translate.translate((String)"addFolder"), (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)Translate.translate((String)"addFolder"))));
        addFolder.addController((Controller)this);
        edit = IdeAction.get((int)Ide.findOrCreateCmdID((String)"edit"), (String)Translate.translate((String)"edit"), (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)Translate.translate((String)"edit"))));
        edit.addController((Controller)this);
        delete = IdeAction.get((int)Ide.findOrCreateCmdID((String)"delete"), (String)Translate.translate((String)"delete"), (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)Translate.translate((String)"delete"))));
        delete.addController((Controller)this);
        copy = IdeAction.get((int)Ide.findOrCreateCmdID((String)"copy"), (String)Translate.translate((String)"copy"), (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)Translate.translate((String)"copy"))));
        copy.addController((Controller)this);
        cut = IdeAction.get((int)Ide.findOrCreateCmdID((String)"cut"), (String)Translate.translate((String)"cut"), (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)Translate.translate((String)"cut"))));
        cut.addController((Controller)this);
        paste = IdeAction.get((int)Ide.findOrCreateCmdID((String)"paste"), (String)Translate.translate((String)"paste"), (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)Translate.translate((String)"paste"))));
        paste.addController((Controller)this);
        addReport = IdeAction.get((int)Ide.findOrCreateCmdID((String)"addReport"), (String)Translate.translate((String)"addReport"), (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)Translate.translate((String)"addReport"))));
        addReport.addController((Controller)this);
    }

    public void addToMenu(ContextMenu contextMenu) {
        JMenuItem mItem = null;
        Context context = contextMenu.getContext();
        TreeNode node = (TreeNode)context.getProperty("TreeNode");
        this.tree = (ReportTree)context.getProperty("ReportTree");
        javax.swing.tree.TreeNode[] tPath = node.getPath();
        boolean user = false;
        for (int i = 0; i < tPath.length; ++i) {
            if (!tPath[i].toString().equals(Translate.translate((String)"User Defined Reports"))) continue;
            user = true;
        }
        if (node.getType() == "report") {
            mItem = contextMenu.createMenuItem((ToggleAction)openSame);
            contextMenu.add((Component)mItem);
            mItem = contextMenu.createMenuItem((ToggleAction)openNew);
            contextMenu.add((Component)mItem);
            mItem = contextMenu.createMenuItem((ToggleAction)showProperties);
            contextMenu.add((Component)mItem);
            if (user) {
                mItem = contextMenu.createMenuItem((ToggleAction)edit);
                contextMenu.add((Component)mItem);
                mItem = contextMenu.createMenuItem((ToggleAction)delete);
                contextMenu.add((Component)mItem);
            }
            mItem = contextMenu.createMenuItem((ToggleAction)copy);
            contextMenu.add((Component)mItem);
            if (user) {
                mItem = contextMenu.createMenuItem((ToggleAction)cut);
                contextMenu.add((Component)mItem);
            }
        } else if (node.getType() == "folder") {
            if (user) {
                mItem = contextMenu.createMenuItem((ToggleAction)addFolder);
                contextMenu.add((Component)mItem);
                mItem = contextMenu.createMenuItem((ToggleAction)addReport);
                contextMenu.add((Component)mItem);
                if (!node.getName().equals(Translate.translate((String)"User Defined Reports"))) {
                    mItem = contextMenu.createMenuItem((ToggleAction)edit);
                    contextMenu.add((Component)mItem);
                }
                mItem = contextMenu.createMenuItem((ToggleAction)delete);
                contextMenu.add((Component)mItem);
            }
            mItem = contextMenu.createMenuItem((ToggleAction)copy);
            contextMenu.add((Component)mItem);
            if (user) {
                mItem = contextMenu.createMenuItem((ToggleAction)cut);
                contextMenu.add((Component)mItem);
            }
            if (user) {
                mItem = contextMenu.createMenuItem((ToggleAction)paste);
                contextMenu.add((Component)mItem);
                if (this.ACTION.equals("CUT") || this.ACTION.equals("COPY")) {
                    mItem.setEnabled(true);
                } else {
                    mItem.setEnabled(false);
                }
            }
        }
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        Assert.startTiming((String)this.getClass().getName(), (String)".handleEvent", (boolean)false);
        this.treeNode = (TreeNode)context.getProperty("TreeNode");
        this.tree = (ReportTree)context.getProperty("ReportTree");
        TreeNode parent = null;
        parent = (TreeNode)this.treeNode.getParent();
        Report report = this.treeNode.getReport();
        if (ideAction.getCommandId() == Ide.findCmdID((String)"openSame").intValue()) {
            this.openReport(report, false);
        } else if (ideAction.getCommandId() == Ide.findCmdID((String)"openNew").intValue()) {
            this.openReport(report, true);
        } else if (ideAction.getCommandId() == Ide.findCmdID((String)"showProperties").intValue()) {
            this.showProperties(report);
        } else if (ideAction.getCommandId() == Ide.findCmdID((String)"addFolder").intValue()) {
            this.folderDialog(this.treeNode, null);
        } else if (ideAction.getCommandId() == Ide.findCmdID((String)"addReport").intValue()) {
            this.reportDialog(this.treeNode, null);
        } else if (ideAction.getCommandId() == Ide.findCmdID((String)"edit").intValue()) {
            if (this.treeNode.getType().equals("folder")) {
                this.folderDialog(parent, this.treeNode);
            } else {
                this.reportDialog(parent, this.treeNode);
            }
        } else if (ideAction.getCommandId() == Ide.findCmdID((String)"delete").intValue()) {
            if (this.treeNode.getType().equals("folder")) {
                this.deleteFolder(parent, this.treeNode);
            } else {
                this.deleteReport(parent, this.treeNode);
            }
        } else if (ideAction.getCommandId() == Ide.findCmdID((String)"cut").intValue()) {
            this.handleNode("CUT");
        } else if (ideAction.getCommandId() == Ide.findCmdID((String)"copy").intValue()) {
            this.handleNode("COPY");
        } else if (ideAction.getCommandId() == Ide.findCmdID((String)"paste").intValue()) {
            this.pasteNode();
        }
        Assert.endTiming((String)this.getClass().getName(), (String)".handleEvent", (String)this.getClass().getName(), (boolean)false);
        return true;
    }

    public boolean update(IdeAction ideAction, Context context) {
        return false;
    }

    public void menuWillShow(ContextMenu contextMenu) {
        Assert.startTiming((String)this.getClass().getName(), (String)".menuWillShow", (boolean)false);
        Context context = contextMenu.getContext();
        TreeNode treeNode = (TreeNode)context.getProperty("TreeNode");
        this.tree = (ReportTree)context.getProperty("ReportTree");
        contextMenu.removeAll();
        Assert.print((String)("Creating Context Menu for:" + treeNode.getName() + "\n"));
        this.addToMenu(contextMenu);
        Assert.endTiming((String)this.getClass().getName(), (String)".menuWillShow", (String)this.getClass().getName(), (boolean)false);
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void openReport(Report report, boolean openInNew) {
        if (report.getEnable()) {
            ReportNode reportNode = null;
            WaitCursor waitCursor = Ide.getWaitCursor();
            try {
                waitCursor.show(0L);
                ReportEditor re = null;
                boolean load = true;
                int openCnt = _editors.size();
                if (openCnt > 0 && !openInNew) {
                    for (int i = openCnt - 1; i >= 0; --i) {
                        boolean isPinned;
                        re = _editors.get(i);
                        boolean bl = isPinned = re == null ? false : re.getPinned();
                        if (re == null || isPinned || !re.isVisible()) continue;
                        re.setReport(report);
                        if (re.getRunReport()) {
                            re.raise();
                        } else if (re.getModel().getLoadedCount() == 0) {
                            re.close();
                        }
                        load = false;
                        i = -1;
                    }
                }
                if (load) {
                    reportNode = new ReportNode(report);
                    Context context = Context.newIdeContext((Node)reportNode);
                    OpenEditorOptions openEditorOptions = new OpenEditorOptions(context);
                    openEditorOptions.setFlags(1);
                    re = (ReportEditor)EditorManager.getEditorManager().openEditor(openEditorOptions);
                    _editors.add(re);
                    re.addViewListener(new ViewListener(){

                        public void viewActivated(ViewEvent e) {
                        }

                        public void viewDeactivated(ViewEvent e) {
                        }

                        public void viewClosed(ViewEvent e) {
                            _editors.remove(e.getSource());
                        }
                    });
                    re.setReport(report);
                    if (re.getRunReport()) {
                        re.show();
                    } else {
                        re.close();
                    }
                }
            }
            finally {
                waitCursor.hide();
            }
        }
    }

    public synchronized void openReport(TreePath path, boolean openInNew) {
        TreeNode node = (TreeNode)path.getLastPathComponent();
        if (node.getType() != null && node.getType().equalsIgnoreCase("report")) {
            Report report = node.getReport();
            this.openReport(report, openInNew);
        }
    }

    public void deleteFolder(TreeNode parent, TreeNode node) {
        this.pNode = parent;
        this.cNode = node;
        PropertyPanel panel = new PropertyPanel();
        String title = Translate.translate((String)"Delete Folder Confirmation");
        int ch = node.getChildCount();
        JLabel mess = new JLabel(Translate.translate((String)"You are about to delete folder ") + node.getFolder().getName() + "\n");
        JLabel warn = new JLabel();
        if (ch > 0) {
            warn = new JLabel(Translate.translate((String)"This folder contains ") + ch + Translate.translate((String)" report(s).\n"));
        }
        JLabel end = new JLabel(Translate.translate((String)"Are you sure?"));
        panel.addSingleComp((JComponent)mess);
        panel.addSingleComp((JComponent)new JLabel());
        panel.addSingleComp((JComponent)warn);
        panel.addSingleComp((JComponent)new JLabel());
        panel.addSingleComp((JComponent)end);
        panel.setBackground(UIManager.getColor("EWTDialog.background"));
        this.dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)panel, null, (String)title, (int)10);
        this.dlg.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TreeController.this.closeEditors(TreeController.this.cNode);
                TreeController.this.pNode.remove(TreeController.this.cNode);
                TreeController.this.tree.updateUI();
                TreeController.this.tree.saveUserDef(TreeController.this.pNode);
                TreeController.this.dlg.dispose();
            }
        });
        Dimension dim = panel.getPreferredSize();
        int h = (int)dim.getHeight() + 100;
        int w = (int)dim.getWidth() + 100;
        this.dlg.setSize(w, h);
        this.dlg.setPreferredSize(w, h);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this.dlg);
        this.dlg.setVisible(true);
    }

    public void deleteReport(TreeNode parent, TreeNode node) {
        this.pNode = parent;
        this.cNode = node;
        PropertyPanel panel = new PropertyPanel();
        String title = Translate.translate((String)"Delete Report Confirmation");
        JLabel mess = new JLabel(Translate.translate((String)"You are about to delete report ") + node.getReport().getName());
        JLabel end = new JLabel(Translate.translate((String)"Are you sure?"));
        panel.addSingleComp((JComponent)mess);
        panel.addSingleComp((JComponent)new JLabel());
        panel.addSingleComp((JComponent)end);
        panel.setBackground(UIManager.getColor("EWTDialog.background"));
        this.dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)panel, null, (String)title, (int)10);
        this.dlg.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TreeController.this.closeEditors(TreeController.this.cNode);
                TreeController.this.pNode.remove(TreeController.this.cNode);
                TreeController.this.tree.updateUI();
                TreeController.this.tree.saveUserDef(TreeController.this.pNode);
                TreeController.this.dlg.dispose();
            }
        });
        Dimension dim = panel.getPreferredSize();
        int h = (int)dim.getHeight() + 100;
        int w = (int)dim.getWidth() + 100;
        this.dlg.setSize(w, h);
        this.dlg.setPreferredSize(w, h);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this.dlg);
        this.dlg.setVisible(true);
    }

    public void closeEditors(TreeNode node) {
        if (node.getChildCount() == 0) {
            List _ed = EditorManager.getEditorManager().getAllEditors();
            for (int i = 0; i < _ed.size(); ++i) {
                if (!(_ed.get(i) instanceof ReportEditor) || ((ReportEditor)((Object)_ed.get(i))).getReport() != node.getReport()) continue;
                ((ReportEditor)((Object)_ed.get(i))).close();
            }
        } else {
            for (int x = 0; x < node.getChildCount(); ++x) {
                this.closeEditors((TreeNode)node.getChildAt(x));
            }
        }
    }

    public void reportDialog(TreeNode parent, TreeNode node) {
        this.pNode = parent;
        this.cNode = node;
        PropertyPanel rDiag = new PropertyPanel();
        String title = Translate.translate((String)"Create Report Dialog");
        String lName = new String(Translate.translate((String)"*Name"));
        this.gName = new JTextField();
        this.gName.setColumns(30);
        this.gName.setEditable(true);
        this.gName.setBorder(new LineBorder(Color.black, 1));
        if (node != null) {
            title = Translate.translate((String)"Edit Report Dialog");
            this.gName.setText(node.getReport().getName());
        }
        rDiag.addComp(lName, (JComponent)this.gName);
        String lDesc = new String(Translate.translate((String)"Description"));
        this.gDesc = new JTextField();
        this.gDesc.setColumns(30);
        this.gDesc.setEditable(true);
        this.gDesc.setBorder(new LineBorder(Color.black, 1));
        if (node != null) {
            this.gDesc.setText(node.getReport().getDescription());
        }
        rDiag.addComp(lDesc, (JComponent)this.gDesc);
        String lTip = new String(Translate.translate((String)"ToolTip"));
        this.gTip = new JTextField();
        this.gTip.setColumns(30);
        this.gTip.setEditable(true);
        this.gTip.setBorder(new LineBorder(Color.black, 1));
        if (node != null) {
            this.gTip.setText(node.getToolTipText());
        }
        rDiag.addComp(lTip, (JComponent)this.gTip);
        this.taSql = EditorFactory.createIdeEditorPane();
        this.taSql.setPreferredSize(new Dimension(300, 200));
        this.taSql.setText("");
        this.taSql.setDocument((Document)new BasicDocument("foo.plsql"));
        this.taSql.installPlugin((EditorPlugin)new LineHighlightPlugin());
        if (node != null) {
            this.taSql.setText(node.getReport().getQuery().getSql());
        }
        this.taSql.setEditable(true);
        JScrollPane sp = new JScrollPane((Component)this.taSql, 22, 32);
        sp.setPreferredSize(this.taSql.getPreferredSize());
        sp.setSize(sp.getPreferredSize());
        rDiag.addComp(new String(Translate.translate((String)"SQL")), (JComponent)sp);
        rDiag.setBackground(UIManager.getColor("EWTDialog.background"));
        rDiag.setSize(rDiag.getPreferredSize());
        HelpSystem.getHelpSystem().registerTopic((JComponent)rDiag, "f1_userdefinedreport_html");
        this.dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)rDiag, null, (String)title, (int)14);
        this.dlg.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean goodName = true;
                if (!TreeController.this.gName.getText().equals("")) {
                    if (TreeController.this.cNode == null) {
                        for (int i = 0; i < TreeController.this.pNode.getChildCount(); ++i) {
                            if (!((TreeNode)TreeController.this.pNode.getChildAt(i)).getName().equals(TreeController.this.gName.getText())) continue;
                            PropertyPanel rp = new PropertyPanel();
                            JLabel mess = new JLabel(Translate.translate((String)"Name already used please enter new one."));
                            rp.add((Component)mess);
                            TreeController.this.dlg2 = OnePageWizardDialogFactory.createJEWTDialog((Component)rp, null, (String)Translate.translate((String)"Report Exists"), (int)1);
                            TreeController.this.dlg2.addActionListener(new ActionListener(){

                                public void actionPerformed(ActionEvent e) {
                                    TreeController.this.dlg2.dispose();
                                }
                            });
                            TreeController.this.dlg2.pack();
                            TreeController.this.dlg2.setVisible(true);
                            goodName = false;
                            break;
                        }
                    }
                    if (goodName) {
                        Report rObject = new Report(TreeController.this.gName.getText(), TreeController.this.gDesc.getText(), "true", TreeController.this.gTip.getText());
                        ArrayList<Query> query = new ArrayList<Query>();
                        Query qObject = new Query();
                        qObject.setSql(TreeController.this.taSql.getText());
                        query.add(qObject);
                        rObject.setQuery(query);
                        TreeNode thisNode = new TreeNode(TreeController.this.gName.getText(), TreeController.this.gTip.getText());
                        thisNode.setReport(rObject);
                        thisNode.setAllowsChildren(false);
                        if (TreeController.this.cNode == null) {
                            TreeController.this.pNode.add(thisNode);
                        } else {
                            TreeController.this.pNode.remove(TreeController.this.cNode);
                            TreeController.this.pNode.add(thisNode);
                        }
                        TreeController.this.tree.updateUI();
                        TreeController.this.tree.saveUserDef(TreeController.this.pNode);
                        TreeController.this.dlg.dispose();
                    }
                }
            }
        });
        Dimension dim = rDiag.getPreferredSize();
        int h = (int)dim.getHeight() + 100;
        int w = (int)dim.getWidth() + 100;
        this.dlg.setSize(w, h);
        this.dlg.setPreferredSize(w, h);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this.dlg);
        this.dlg.setVisible(true);
    }

    public void folderDialog(TreeNode parent, TreeNode node) {
        this.gName = null;
        this.gDesc = null;
        this.gTip = null;
        this.pNode = parent;
        this.cNode = node;
        String title = Translate.translate((String)"Create Folder Dialog");
        PropertyPanel fDiag = new PropertyPanel();
        String lName = new String(Translate.translate((String)"*Name"));
        this.gName = new JTextField();
        this.gName.setColumns(30);
        this.gName.setEditable(true);
        this.gName.setBorder(new LineBorder(Color.black, 1));
        if (node != null) {
            title = Translate.translate((String)"Edit Folder Dialog");
            this.gName.setText(node.getFolder().getName().toString());
        }
        fDiag.addComp(lName, (JComponent)this.gName);
        String lDesc = new String(Translate.translate((String)"Description"));
        this.gDesc = new JTextField();
        this.gDesc.setColumns(30);
        this.gDesc.setEditable(true);
        this.gDesc.setBorder(new LineBorder(Color.black, 1));
        if (node != null) {
            this.gDesc.setText(node.getFolder().getDescription());
        }
        fDiag.addComp(lDesc, (JComponent)this.gDesc);
        String lTip = new String(Translate.translate((String)"ToolTip"));
        this.gTip = new JTextField();
        this.gTip.setColumns(30);
        this.gTip.setEditable(true);
        this.gTip.setBorder(new LineBorder(Color.black, 1));
        if (node != null) {
            this.gTip.setText(node.getToolTipText());
        }
        fDiag.addComp(lTip, (JComponent)this.gTip);
        fDiag.setBackground(UIManager.getColor("EWTDialog.background"));
        fDiag.setSize(fDiag.getPreferredSize());
        HelpSystem.getHelpSystem().registerTopic((JComponent)fDiag, "f1_userdefinedreportfolder_html");
        this.dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)fDiag, null, (String)title, (int)14);
        this.dlg.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean goodName = true;
                if (!TreeController.this.gName.getText().equals("")) {
                    if (TreeController.this.cNode == null) {
                        for (int i = 0; i < TreeController.this.pNode.getChildCount(); ++i) {
                            if (!((TreeNode)TreeController.this.pNode.getChildAt(i)).getName().equals(TreeController.this.gName.getText())) continue;
                            PropertyPanel rp = new PropertyPanel();
                            JLabel mess = new JLabel(Translate.translate((String)"Name already used please enter new one."));
                            rp.add((Component)mess);
                            TreeController.this.dlg2 = OnePageWizardDialogFactory.createJEWTDialog((Component)rp, null, (String)Translate.translate((String)"Folder Exists"), (int)1);
                            TreeController.this.dlg2.addActionListener(new ActionListener(){

                                public void actionPerformed(ActionEvent e) {
                                    TreeController.this.dlg2.dispose();
                                }
                            });
                            IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)TreeController.this.dlg2);
                            TreeController.this.dlg2.pack();
                            TreeController.this.dlg2.setVisible(true);
                            goodName = false;
                            break;
                        }
                    }
                    if (goodName) {
                        Folder fObject = new Folder(TreeController.this.gName.getText(), TreeController.this.gDesc.getText());
                        TreeNode thisNode = new TreeNode(TreeController.this.gName.getText(), TreeController.this.gTip.getText());
                        thisNode.setFolder(fObject);
                        thisNode.setAllowsChildren(true);
                        if (TreeController.this.cNode == null) {
                            TreeController.this.pNode.add(thisNode);
                        } else {
                            for (int i = 0; i < TreeController.this.cNode.getChildCount(); ++i) {
                                thisNode.add(TreeController.this.tree.newNode((TreeNode)TreeController.this.cNode.getChildAt(i)));
                            }
                            TreeController.this.pNode.remove(TreeController.this.cNode);
                            TreeController.this.pNode.add(thisNode);
                        }
                        TreeController.this.tree.updateUI();
                        TreeController.this.tree.saveUserDef(TreeController.this.pNode);
                        TreeController.this.dlg.dispose();
                    }
                }
            }
        });
        this.dlg.setSize(450, 200);
        this.dlg.setPreferredSize(450, 200);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this.dlg);
        this.dlg.setVisible(true);
    }

    public void showProperties(Report report) {
        PropertyPanel rp = new PropertyPanel();
        String name = report.getName();
        String desc = report.getDescription();
        Query query = report.getQueryList().get(0);
        String sql = query.getSql();
        rp.addItem(Translate.translate((String)"Name"), (Object)name);
        rp.addItem(Translate.translate((String)"Description"), (Object)desc);
        this.taSql = EditorFactory.createIdeEditorPane();
        this.taSql.setPreferredSize(new Dimension(300, 200));
        this.taSql.setText("");
        this.taSql.setDocument((Document)new BasicDocument("foo.plsql"));
        this.taSql.installPlugin((EditorPlugin)new LineHighlightPlugin());
        this.taSql.setText(sql);
        this.taSql.setEditable(false);
        JScrollPane sp = new JScrollPane((Component)this.taSql, 22, 32);
        sp.setPreferredSize(this.taSql.getPreferredSize());
        sp.setSize(sp.getPreferredSize());
        rp.addSingleComp((JComponent)sp);
        rp.setBackground(UIManager.getColor("EWTDialog.background"));
        rp.setSize(rp.getPreferredSize());
        this.dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)rp, null, (String)Translate.translate((String)"Report Properties"), (int)3);
        this.dlg.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TreeController.this.dlg.dispose();
            }
        });
        Dimension dim = rp.getPreferredSize();
        int h = (int)dim.getHeight() + 100;
        int w = (int)dim.getWidth() + 100;
        this.dlg.setSize(w, h);
        this.dlg.setPreferredSize(w, h);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this.dlg);
        this.dlg.pack();
        this.dlg.setVisible(true);
    }

    public void handleNode2(TreeNode newNode, TreeNode oldNode) {
        for (int i = 0; i < oldNode.getChildCount(); ++i) {
            TreeNode cNode = this.tree.newNode((TreeNode)oldNode.getChildAt(i));
            newNode.add(cNode);
            if (!newNode.getType().equals("folder")) continue;
            this.handleNode2(newNode, cNode);
        }
    }

    public void handleNode(String action) {
        this.newNode = this.tree.newNode(this.treeNode);
        for (int i = 0; i < this.treeNode.getChildCount(); ++i) {
            TreeNode cNode = this.tree.newNode((TreeNode)this.treeNode.getChildAt(i));
            if (cNode.getType().equals("folder")) {
                this.handleNode2(cNode, (TreeNode)this.treeNode.getChildAt(i));
            }
            this.newNode.add(cNode);
        }
        this.oldNode = this.treeNode;
        this.ACTION = action;
    }

    public void pasteNode() {
        DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
        if (this.ACTION.equals("CUT")) {
            model.removeNodeFromParent(this.oldNode);
        }
        String name = this.tree.checkName(this.newNode, this.treeNode);
        this.newNode.setName(name);
        model.insertNodeInto(this.newNode, this.treeNode, this.treeNode.getChildCount());
        this.tree.saveUserDef(this.newNode);
        this.ACTION = "";
    }
}

