/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlworksheet.bindDialog;

import java.awt.Component;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.math.BigDecimal;
import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.sqlworksheet.SQLWorksheetArb;
import oracle.dbtools.sqlworksheet.bindDialog.BindDialogModel;
import oracle.dbtools.sqlworksheet.bindDialog.BindDialogPanel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.javatools.dialogs.MessageDialog;

public final class BindDialogBuilder {
    private static final String[] SUPPORTED_TYPES = new String[]{"VARCHAR2", "NUMERIC", SQLWorksheetArb.getString(23), SQLWorksheetArb.getString(24)};

    private BindDialogBuilder() {
    }

    private static JEWTDialog _createDialog(BindDialogModel model, BindDialogPanel panel, String label) {
        IdeMainWindow parentFrame = Ide.getMainWindow();
        String objType = model.getObjectType();
        String helpID = "f1_bindvariables_html";
        boolean useType = true;
        String title = SQLWorksheetArb.getString(25) + " " + label;
        helpID = "f1_bindvariables_html";
        JEWTDialog dlg = new JEWTDialog((Frame)parentFrame, title, 7);
        dlg.setContent((Component)panel);
        dlg.setInitialFocus((Component)panel.fldName);
        HelpSystem.getHelpSystem().registerTopic((JComponent)panel, helpID);
        panel.setUseType(useType);
        panel.setTypesList(model.getTypesList());
        return dlg;
    }

    public static BindDialogModel _getDefaultModel(Context context) {
        String objType = null;
        BindDialogModel model = new BindDialogModel(objType, null);
        model.setTypesList(BindDialogBuilder._getTypesList());
        return model;
    }

    private static String _validateModel(String objName, String objType, PropertyChangeEvent evt) {
        String retVal = "";
        if (objType == null) {
            retVal = SQLWorksheetArb.getString(28);
        } else if (objName != null && !objName.equals("")) {
            if (objType.equals("NUMERIC")) {
                try {
                    new BigDecimal(objName);
                }
                catch (NumberFormatException e) {
                    retVal = SQLWorksheetArb.getString(27);
                }
            } else if (objType.equals(SQLWorksheetArb.getString(23))) {
                if (!BindDialogBuilder.checkDate(objName, "dd/MM/yyyy")) {
                    retVal = SQLWorksheetArb.getString(26);
                }
            } else if (objType.equals(SQLWorksheetArb.getString(24)) && !BindDialogBuilder.checkDate(objName, "MM/dd/yyyy")) {
                retVal = SQLWorksheetArb.getString(26);
            }
        }
        return retVal;
    }

    private static boolean checkDate(String dateVal, String dateFormat) {
        SimpleDateFormat myDateFormat = new SimpleDateFormat(dateFormat);
        Date myDate = null;
        boolean retVal = true;
        try {
            myDate = new Date(myDateFormat.parse(dateVal).getTime());
        }
        catch (ParseException e) {
            retVal = false;
        }
        return retVal;
    }

    public static BindDialogModel createBindDialog(Context context, String label) {
        final BindDialogModel model = BindDialogBuilder._getDefaultModel(context);
        model.setIsValid(false);
        String objType = model.getObjectType();
        final BindDialogPanel panel = new BindDialogPanel();
        final JEWTDialog dlg = BindDialogBuilder._createDialog(model, panel, label);
        if (dlg != null) {
            dlg.addVetoableChangeListener(new VetoableChangeListener(){

                public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                    if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt)) {
                        String type = panel.getObjectType();
                        String name = panel.getObjectName();
                        String message = BindDialogBuilder._validateModel(name, type, evt);
                        if (!message.equals("")) {
                            MessageDialog.error((Component)dlg, (Object)message, (String)SQLWorksheetArb.getString(29), null);
                            throw new PropertyVetoException(message, evt);
                        }
                        model.setObjectType(type);
                        model.setObjectName(name);
                    }
                }
            });
            model.setIsValid(WizardLauncher.runDialog((JDialog)dlg));
        }
        return model;
    }

    private static List _getTypesList() {
        return Arrays.asList(SUPPORTED_TYPES);
    }
}

