/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlworksheet.explainPlan;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import oracle.dbtools.sqlworksheet.explainPlan.ExplainPlanNode;
import oracle.dbtools.sqlworksheet.explainPlan.ExplainPlanTables;
import oracle.ide.controls.AbstractTreeTableModel;
import oracle.ide.controls.TreeTableModel;
import oracle.ide.dialogs.MessageDialog;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdeveloper.cm.dt.dialog.SQLErrorDialog;

class ExplainPlanTreeModel
extends AbstractTreeTableModel {
    protected Connection _conn = null;
    protected boolean _bShouldCheckPossible = true;
    protected String _strStmt = null;
    protected String _strTableName = "PLAN_TABLE";
    protected String _strStmtID = null;

    public ExplainPlanTreeModel() {
        super((Object)new DefaultMutableTreeNode("-"));
    }

    public void setConnection(Connection conn) {
        this._conn = conn;
        this._bShouldCheckPossible = true;
    }

    public Connection getConnection() {
        return this._conn;
    }

    public void setStatement(String strStmt) {
        String sqlStmtUp;
        String sqlStmt = strStmt.trim();
        if (sqlStmt.endsWith(";") && !(sqlStmtUp = sqlStmt.toUpperCase()).endsWith("END;")) {
            sqlStmt = sqlStmt.substring(0, sqlStmt.lastIndexOf(";"));
        }
        this._strStmt = sqlStmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        if (this.checkPossible()) {
            DefaultMutableTreeNode root = null;
            Statement stmtSel = null;
            ResultSet rs = null;
            try {
                if (this._strStmtID == null) {
                    this._strStmtID = this.getUniqueStatementID();
                }
                this.executeExplainStatment();
                stmtSel = this._conn.prepareStatement("SELECT * FROM " + this._strTableName + " WHERE STATEMENT_ID = ?" + " ORDER BY ID");
                stmtSel.setString(1, this._strStmtID);
                rs = stmtSel.executeQuery();
                ResultSetMetaData rsmd = stmtSel.getMetaData();
                HashMap<String, ExplainPlanNode> ht = new HashMap<String, ExplainPlanNode>();
                while (rs.next()) {
                    ExplainPlanNode node = new ExplainPlanNode(rs);
                    ht.put(node.getNodeID(), node);
                    if (node.getNodeParentID() == null) {
                        root = node;
                        continue;
                    }
                    ExplainPlanNode parent = (ExplainPlanNode)ht.get(node.getNodeParentID());
                    if (parent == null) continue;
                    parent.add(node);
                }
                rs.close();
                stmtSel.close();
                stmtSel = this._conn.prepareStatement("DELETE FROM " + this._strTableName + " WHERE STATEMENT_ID = ?");
                stmtSel.setString(1, this._strStmtID);
                stmtSel.execute();
            }
            catch (SQLException ex) {
                root = new DefaultMutableTreeNode(ex.getLocalizedMessage().trim());
            }
            finally {
                if (stmtSel != null) {
                    try {
                        stmtSel.close();
                    }
                    catch (Exception ex) {}
                }
            }
            this.root = root;
            this.fireTreeStructureChanged((Object)this, new TreeNode[]{root}, null, null);
        }
    }

    public String getStatement() {
        return this._strStmt;
    }

    public void setPlanTableName(String strTableName) {
        this._strTableName = strTableName != null ? strTableName : "PLAN_TABLE";
    }

    public String getPlanTableName() {
        return this._strTableName;
    }

    public void setStatementID(String strStmtID) {
        this._strStmtID = strStmtID;
    }

    public String getStatementID() {
        return this._strStmtID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkPossible() {
        if (!this._bShouldCheckPossible) {
            return true;
        }
        Statement stmt = null;
        boolean bRet = false;
        String strStmt = "select null from " + this._strTableName + " where 1=2";
        try {
            stmt = this.getConnection().createStatement();
            stmt.execute(strStmt);
            bRet = true;
        }
        catch (SQLException ex) {
            if (ex.getErrorCode() == 942) {
                bRet = MessageDialog.confirm(null, (Object)ConnectionArb.getString((int)221), (String)ConnectionArb.getString((int)222), null) && this.createPlanTable();
            }
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception ex) {}
        }
        this._bShouldCheckPossible = bRet;
        return bRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeExplainStatment() throws SQLException {
        String strStmt = "EXPLAIN PLAN SET STATEMENT_ID ='" + this.getStatementID() + "' INTO " + this.getPlanTableName() + " FOR " + this.getStatement();
        Statement stmt = null;
        try {
            stmt = this.getConnection().createStatement();
            stmt.execute(strStmt);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getUniqueStatementID() throws SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        String strRet = null;
        try {
            stmt = this.getConnection().createStatement();
            rs = stmt.executeQuery("select userenv('SESSIONID') from sys.dual");
            rs.next();
            strRet = rs.getString(1);
            stmt.executeUpdate("DELETE FROM " + this.getPlanTableName());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ex) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception ex) {}
        }
        return strRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createPlanTable() {
        boolean bRet = false;
        Statement stmt = null;
        try {
            String strVersion = this.getConnection().getMetaData().getDatabaseMajorVersion() + "." + this.getConnection().getMetaData().getDatabaseMinorVersion();
            String strStmt = ExplainPlanTables.getBestCreateTableStatement(strVersion);
            stmt = this.getConnection().createStatement();
            stmt.executeUpdate(strStmt);
            bRet = true;
        }
        catch (SQLException ex) {
            SQLErrorDialog.showErrorDialog(null, (String)ConnectionArb.getString((int)224), (SQLException)ex);
        }
        catch (NullPointerException ex) {
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception ex) {}
        }
        return bRet;
    }

    public int getChildCount(Object parent) {
        return ((DefaultMutableTreeNode)parent).getChildCount();
    }

    public Object getChild(Object parent, int idx) {
        return ((DefaultMutableTreeNode)parent).getChildAt(idx);
    }

    public int getColumnCount() {
        return ExplainPlanNode.getColumnCount();
    }

    public String getColumnName(int column) {
        return ExplainPlanNode.getColumnName(column);
    }

    public Class getColumnClass(int column) {
        return column == 0 ? TreeTableModel.class : String.class;
    }

    public Object getValueAt(Object node, int column) {
        return node instanceof ExplainPlanNode ? ((ExplainPlanNode)node).getValue(column) : "";
    }
}

