/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlworksheet.owaoutput;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URL;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.BadLocationException;
import oracle.dbtools.sqlworksheet.sqlview.SqlEditorMainPanel;
import oracle.dbtools.sqlworksheet.sqlview.Utility;
import oracle.ide.Ide;
import oracle.ide.controller.ToolbarManager;
import oracle.ide.controls.Toolbar;
import oracle.ide.model.UpdateMessage;
import oracle.ide.view.View;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicEditorPane;

public class OWAOutputPane
extends JPanel {
    private BasicEditorPane textPanelArea = new BasicEditorPane();
    private int pollCycle = 15;
    private Timer localTimer = new Timer();
    private Connection connLocal = null;
    private boolean enabled = false;
    private final Toolbar _toolbar = new Toolbar();
    Timer timer;
    boolean frozen = false;
    int delay;

    public OWAOutputPane(SqlEditorMainPanel parent) {
        this.init(parent);
    }

    public void setDividerLocation(int loc) {
    }

    public void enableOwaOutput() {
        if (!this.enabled) {
            try {
                this.localTimer.cancel();
            }
            catch (IllegalStateException i) {
                // empty catch block
            }
            try {
                this.textPanelArea.getDocument().insertString(this.textPanelArea.getDocument().getLength(), "OWA output on\n", null);
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
            }
            this.start_poll(this.connLocal);
        }
        this.enabled = true;
    }

    public void saveFile(URL filename) {
        try {
            File file = new File(filename.getPath());
            BufferedWriter output = new BufferedWriter(new FileWriter(file));
            output.write(this.textPanelArea.getText());
            output.close();
        }
        catch (IOException io) {
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)"Could Not Create File", (String)filename.getPath(), null);
        }
    }

    public void printOutput() {
        Utility.printText("OWA Output", this.textPanelArea.getText());
    }

    public void disableOwaOutput() {
        if (this.enabled) {
            try {
                this.textPanelArea.getDocument().insertString(this.textPanelArea.getDocument().getLength(), "OWA output off\n", null);
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
            }
            this.stop_poll(this.connLocal);
        }
        this.enabled = false;
    }

    public void setupPoller() {
    }

    public void setConnection(Connection conn) {
        this.connLocal = conn;
    }

    public void setStatement(String strStmt) {
        PipedInputStream in = new PipedInputStream();
        BufferedOutputStream out = null;
        try {
            out = new BufferedOutputStream(new PipedOutputStream(in));
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private void stop_poll(Connection conn) {
        try {
            this.localTimer.cancel();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private void start_poll(Connection conn) {
        this.localTimer = new Timer();
        this.localTimer.schedule((TimerTask)new Poller(conn, this.textPanelArea), 0L, 3000L);
    }

    private void init(SqlEditorMainPanel parent) {
        ToolbarManager manager = ToolbarManager.getToolbarManager();
        manager.installToolbar("OWAOutput.Toolbar", this._toolbar, (View)parent.getEditor());
        this._toolbar.addSeparator(new Dimension(15, 15));
        this._toolbar.getComponent(0).setEnabled(true);
        this._toolbar.getComponent(2).setEnabled(true);
        this._toolbar.getComponent(1).setEnabled(true);
        this._toolbar.getComponent(3).setEnabled(true);
        JScrollPane scrollPane = new JScrollPane((Component)this.textPanelArea, 20, 30);
        this.textPanelArea.setEditable(false);
        this.textPanelArea.setFont(new Font("Courier", 0, 12));
        this.setLayout(new BorderLayout());
        this.add((Component)this._toolbar, "First");
        this.add((Component)scrollPane, "Center");
        PipedInputStream in = new PipedInputStream();
    }

    void clear() {
        try {
            this.textPanelArea.getDocument().remove(0, this.textPanelArea.getDocument().getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void updateVisibleActions(UpdateMessage msg) {
        View.updateToolbarActions((Toolbar)this._toolbar);
    }

    class Poller
    extends TimerTask {
        private Connection localConn = null;
        private int gDB_State;
        private CallableStatement show_stmt;
        static final int STATE_NONE = 0;
        static final int STATE_FETCHING = 1;
        static final int STATE_FINISHED = 2;
        static final int MAX_PL_LINES = 127;
        private BasicEditorPane textPanelArea;

        public Poller(Connection Connin, BasicEditorPane textPanelAreaIn) {
            this.textPanelArea = textPanelAreaIn;
            this.localConn = Connin;
        }

        public void run() {
            try {
                this.getGeneratedStream();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }

        public void getGeneratedStream() throws SQLException {
            StringBuffer buff = new StringBuffer();
            this.gDB_State = 0;
            while (this.gDB_State != 2) {
                try {
                    this.textPanelArea.getDocument().insertString(this.textPanelArea.getDocument().getLength(), this.getDataBlock(), null);
                }
                catch (BadLocationException ble) {
                    ble.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getDataBlock() throws SQLException {
            String parcialContent;
            Statement cs = null;
            try {
                String s_GetPageSql = "declare nlns number;\n buf_t varchar2(32767);\n lines htp.htbuf_arr;\nbegin\n  nlns := ?;\n  OWA.GET_PAGE(lines, nlns);\n  if (nlns < 1) then\n   buf_t := null;\n  else \n   for i in 1..nlns loop\n     buf_t:=buf_t||lines(i);\n   end loop;\n  end if;\n  ? := buf_t; ? := nlns;\nend;";
                int nlines = 127;
                cs = this.localConn.prepareCall(s_GetPageSql);
                cs.setInt(1, nlines);
                cs.registerOutParameter(2, 12);
                cs.registerOutParameter(3, -5);
                cs.execute();
                nlines = cs.getInt(3);
                this.gDB_State = 1;
                if (nlines < 127) {
                    this.gDB_State = 2;
                    if (nlines < 1) {
                        String string = "";
                        return string;
                    }
                }
                parcialContent = cs.getString(2);
            }
            finally {
                if (cs != null) {
                    try {
                        cs.close();
                    }
                    catch (Exception e) {}
                }
            }
            return parcialContent;
        }
    }
}

