/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlworksheet.scriptRunner;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.net.URL;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.sqlworksheet.SQLWorksheetArb;
import oracle.dbtools.sqlworksheet.scriptRunner.ScriptRunnerPane;
import oracle.dbtools.sqlworksheet.sqlview.SqlEditor;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.util.Assert;
import oracle.ide.view.View;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.cm.dt.ConnectionArb;

public class ScriptRunnerController
implements Controller {
    static final int CLEAR_CMD_ID = Ide.findOrCreateCmdID((String)"scriptrunner.clear");
    static final int SCRIPT_CLEAR_CMD_ID = Ide.findOrCreateCmdID((String)"scriptrunner.doclear");
    private static IdeAction clearAction;

    public void createActions() {
        IdeAction.find((int)11).addController((Controller)this);
        IdeAction.find((int)16).addController((Controller)this);
        String category = ConnectionArb.getString((int)20);
        String label = SQLWorksheetArb.getString(15);
        Integer mnemonic = new Integer(StringUtils.getMnemonicKeyCode((String)label));
        clearAction = IdeAction.get((int)CLEAR_CMD_ID, null, (String)StringUtils.stripMnemonic((String)label), (String)category, (Integer)mnemonic, (ArrayResourceBundle)SQLWorksheetArb.getInstance(), (int)16, null, (boolean)false);
        clearAction.addController((Controller)this);
    }

    public boolean handleEvent(IdeAction action, Context context) {
        boolean handled = false;
        ScriptRunnerPane pane = this.getPane(context);
        int saveState = 0;
        if (pane != null) {
            if (action.getCommandId() == SCRIPT_CLEAR_CMD_ID || action.getCommandId() == CLEAR_CMD_ID) {
                pane.clear();
                handled = true;
            } else if (action.getCommandId() == 11) {
                URLChooser saveDialog = DialogUtil.newURLChooser();
                saveState = saveDialog.showSaveDialog((Component)pane);
                if (saveState == 0) {
                    URL srFileName = saveDialog.getSelectedURL();
                    pane.saveFile(srFileName);
                } else if (saveState == 1) {
                    // empty if block
                }
                handled = true;
            } else if (action.getCommandId() == 16) {
                pane.printOutput();
                handled = true;
            } else {
                MessageDialog.information((Component)Ide.getMainWindow(), (Object)"Not Yet Implemented", (String)((String)action.getValue("Name")), null);
            }
            Assert.println((String)"HandleEvent Script Runner\n");
        }
        return handled;
    }

    public boolean update(IdeAction action, Context context) {
        if (this.getPane(context) != null) {
            action.setEnabled(true);
            return true;
        }
        return false;
    }

    private ScriptRunnerPane getPane(Context context) {
        SqlEditor editor;
        Component subPage;
        View view = context.getView();
        if (view instanceof SqlEditor && (subPage = (editor = (SqlEditor)context.getView()).getActiveSubPage()) instanceof ScriptRunnerPane) {
            return (ScriptRunnerPane)subPage;
        }
        return null;
    }

    private boolean checkFocus(ScriptRunnerPane root) {
        Component focusOwner;
        Component temp = focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        while (temp != null) {
            if (temp == root) {
                return true;
            }
            temp = temp instanceof Window ? null : temp.getParent();
        }
        return false;
    }
}

