/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlworksheet.sqlview;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.controls.BindInfo;
import oracle.dbtools.raptor.controls.CopyableResultSetTableAdapter;
import oracle.dbtools.raptor.controls.CustomTabbedPane;
import oracle.dbtools.raptor.editors.IDBEditor;
import oracle.dbtools.raptor.query.Bind;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.scriptrunner.SQLCommand;
import oracle.dbtools.raptor.scriptrunner.ScriptParser;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.raptor.utils.Log;
import oracle.dbtools.raptor.utils.NLSUtils;
import oracle.dbtools.raptor.utils.Translate;
import oracle.dbtools.sqlworksheet.SQLWorksheetArb;
import oracle.dbtools.sqlworksheet.bindDialog.BindDialogModel;
import oracle.dbtools.sqlworksheet.bindDialog.BindStore;
import oracle.dbtools.sqlworksheet.sqlview.SqlEditorController;
import oracle.dbtools.sqlworksheet.sqlview.SqlEditorHistory;
import oracle.dbtools.sqlworksheet.sqlview.SqlEditorMainPanel;
import oracle.dbtools.sqlworksheet.sqlview.SqlEditorNode;
import oracle.dbtools.util.Resource;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.ceditor.find.FindableEditor;
import oracle.ide.controller.Controller;
import oracle.ide.controls.Toolbar;
import oracle.ide.controls.WaitCursor;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.help.HelpInfo;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.keyboard.MultiInputMap;
import oracle.ide.keyboard.MultiMapAdapter;
import oracle.ide.marshal.xml.Object2Dom;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFactory;
import oracle.ide.util.Assert;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.SwingWorker;
import oracle.ide.view.StatusProvider;
import oracle.ide.view.View;
import oracle.ide.xml.XMLUtil;
import oracle.javatools.controls.nicetable.NiceTablePersistentSettings;
import oracle.javatools.db.Database;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicEditorPane;
import oracle.jdeveloper.cm.dt.CmUtil;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdeveloper.cm.dt.ConnectionContext;
import oracle.jdeveloper.cm.dt.ConnectionNode;
import oracle.jdevimpl.cm.dt.sqlplus.SqlNode;

public final class SqlEditor
extends Editor
implements FindableEditor,
IDBEditor,
ChangeListener,
StatusProvider {
    public static final Class _editorClass = SqlEditor.class;
    public static final String PROTOCOL = "ide.sqleditor";
    SqlEditorMainPanel view = null;
    private boolean _isOracle = true;
    private SqlEditorController _controller = SqlEditorController.getInstance();
    Component focusedComponent;
    private CopyableResultSetTableAdapter _copyableTableAdapter;
    private boolean _isExecuting;
    private Component _activeSubPage = null;
    private Database _db = null;
    private String bindLabel = null;
    private boolean runReport;
    private BindDialogModel dialogModel = null;
    private static final String NAMESPACE_URI = XMLUtil.toNamespaceURI((String)"sqlWorksheet-attributes");
    private static final String ROOT_TAG = "ExplainPlanTable";
    private static final String SQLWORKSHEET_EXTENSION_ID = "oracle.dbtools.sqlworksheet";
    private static final String SQLWORKSHEET_ATTRIBUTE_FILE = "sqlWorksheetAttrb.xml";
    private static boolean _isOpening = false;
    private SqlEditorHistory _history = SqlEditorHistory.getInstance();
    SwingWorker worker = null;
    private boolean interrupted = false;
    long duration = 0L;
    long start = 0L;
    private String _md5;
    private static final String TMP_FILE_PREFIX = "sqldev";

    public int getHistorySize() {
        if (this._history == null) {
            return 0;
        }
        return this._history.getSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelExecute() {
        try {
            if (this.view != null) {
                this.view.cancelScript();
            }
            if (this.worker != null) {
                this.worker.interrupt();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.view.toggleProgress(false);
        }
    }

    public Component getActiveSubPage() {
        return this._activeSubPage;
    }

    public final void commit() {
        this.executeSql("commit");
    }

    public final void rollback() {
        this.executeSql("rollback");
    }

    public final void executeSql() {
        this.executeSql(null);
    }

    public final void executeSql(String sql) {
        boolean matchFound = false;
        this.view.toggleProgress(true);
        if (sql == null) {
            sql = this.view.getSqlStatement();
            matchFound = this.view.isTextSelected();
        } else if (sql.toUpperCase().equals("COMMIT") || sql.toUpperCase().equals("ROLLBACK")) {
            matchFound = true;
        }
        ScriptParser parser = new ScriptParser(sql);
        parser.parse();
        SQLCommand[] cmds = parser.getSqlStatements();
        int lineNumber = this.view.getCaretLine();
        int i = 0;
        int index = 0;
        if (!matchFound) {
            for (i = 0; i < cmds.length; ++i) {
                if (lineNumber - 1 < cmds[i].getStartLine() || lineNumber - 1 > cmds[i].getEndLine()) continue;
                index = i;
                matchFound = true;
            }
        }
        if ((sql = matchFound ? cmds[index].getSql() : null) == null || sql.trim().length() < 1) {
            Ide.getStatusBar().setText(ConnectionArb.getString((int)175));
            this.view.toggleProgress(false);
            return;
        }
        String sqlOrig = cmds[index].getSQLOrig();
        final SQLCommand cmd = cmds[index];
        if (sqlOrig.trim().toUpperCase().startsWith("DESC") || sqlOrig.trim().toUpperCase().startsWith("@") || sqlOrig.trim().toUpperCase().startsWith("START ")) {
            this.executeScriptRunnerPlan(true);
            return;
        }
        this.view.setEnabled(false);
        this.setExecuteInProgress(true);
        View.updateToolbarActions((Toolbar)this.getToolbar());
        this.view.setFocusForResultSet();
        if (sql.endsWith(";") && !sql.toUpperCase().endsWith("END;")) {
            sql = sql.substring(0, sql.length() - 1);
        }
        final String sqlStmt = sql;
        int l = index;
        this.worker = new SwingWorker(){
            Statement stmt = null;

            public void interrupt() {
                SqlEditor.this.interrupted = true;
                try {
                    if (this.stmt != null) {
                        SqlEditor.this.view.toggleProgress(false);
                        this.stmt.cancel();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                super.interrupt();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public Object construct() {
                Connection conn;
                Log.status((String)Translate.translate((String)SQLWorksheetArb.getString(45)));
                ResultWrapper result = null;
                Connection connection = conn = SqlEditor.this._db.getConnection();
                synchronized (connection) {
                    String action;
                    block59: {
                        SqlEditor.this.view.setResultSet(null, ConnectionArb.getString((int)171), false, sqlStmt);
                        ArrayList binds = new ArrayList();
                        Object rs = null;
                        int cnt = 0;
                        action = "";
                        try {
                            block56: {
                                SqlEditor.this.runReport = true;
                                boolean isNotPLSQL = cmd.getStmtId().equals("48") || cmd.getStmtId().equals("88") || cmd.getStmtId().equals("31") || cmd.getStmtId().equals("72") || cmd.getStmtId().equals("51") || cmd.getStmtId().equals("92");
                                HashMap bindResults = null;
                                ArrayList al = new ArrayList();
                                if (isNotPLSQL) {
                                    al = SqlEditor.this.getBinds(sqlStmt);
                                }
                                if (!(al.size() != 0 || cmd.getResultsType() != null && cmd.getResultsType().equals("1"))) {
                                    this.stmt = conn.createStatement();
                                    this.stmt.setEscapeProcessing(false);
                                    SqlEditor.this.start = System.currentTimeMillis();
                                    cnt = this.stmt.executeUpdate(sqlStmt);
                                    if (sqlStmt.toLowerCase().indexOf("set nls") > 0) {
                                        NLSUtils.populateNLS((OracleDatabase)((OracleDatabase)SqlEditor.this.getDb()));
                                    }
                                    SqlEditor.this.duration = System.currentTimeMillis() - SqlEditor.this.start;
                                } else {
                                    HashMap<String, String> usedSoFar = new HashMap<String, String>();
                                    final Query query = new Query();
                                    if (al.size() != 0) {
                                        SqlEditor.this.runReport = false;
                                        for (int i = 0; i < al.size(); ++i) {
                                            SqlEditor.this.bindLabel = (String)al.get(i);
                                            if (SqlEditor.this.bindLabel.startsWith(":") && SqlEditor.this.bindLabel.length() > 1) {
                                                SqlEditor.this.bindLabel = SqlEditor.this.bindLabel.substring(1);
                                            }
                                            String prevValue = null;
                                            Object o = BindStore.getInstance().get(SqlEditor.this.bindLabel);
                                            if (o instanceof String) {
                                                prevValue = (String)o;
                                            }
                                            if (prevValue == null) {
                                                prevValue = "NULL_VALUE";
                                            }
                                            Bind newBind = new Bind(SqlEditor.this.bindLabel, SqlEditor.this.bindLabel, SqlEditor.this.bindLabel, prevValue, SqlEditor.this.bindLabel);
                                            if (usedSoFar.get(SqlEditor.this.bindLabel) != null) continue;
                                            usedSoFar.put(SqlEditor.this.bindLabel, "a value");
                                            query.getBinds().add(newBind);
                                        }
                                        try {
                                            Runnable showDialog = new Runnable(){

                                                public void run() {
                                                    BindInfo _panel = new BindInfo(query);
                                                    final JEWTDialog dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)_panel, null, (String)SQLWorksheetArb.getString(49), (int)10);
                                                    dlg.addActionListener(new ActionListener(){

                                                        public void actionPerformed(ActionEvent e) {
                                                            SqlEditor.this.runReport = true;
                                                            dlg.dispose();
                                                        }
                                                    });
                                                    dlg.setSize(600, 300);
                                                    dlg.setPreferredSize(_panel.getPreferredSize());
                                                    IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)dlg);
                                                    dlg.setVisible(true);
                                                }
                                            };
                                            SwingUtilities.invokeAndWait(showDialog);
                                        }
                                        catch (InterruptedException e) {
                                        }
                                        catch (InvocationTargetException e) {
                                            // empty catch block
                                        }
                                    }
                                    if (SqlEditor.this.runReport) {
                                        bindResults = query.getBindValues();
                                        BindStore.getInstance().putAll(bindResults);
                                    }
                                    if (SqlEditor.this.runReport && (cmd.getResultsType() == null || !cmd.getResultsType().equals("1"))) {
                                        PreparedStatement pstmt = conn.prepareStatement(cmd.getSql());
                                        pstmt.setEscapeProcessing(false);
                                        DBUtil.getInstance().bind(pstmt, bindResults);
                                        SqlEditor.this.start = System.currentTimeMillis();
                                        cnt = pstmt.executeUpdate();
                                        SqlEditor.this.duration = System.currentTimeMillis() - SqlEditor.this.start;
                                        this.stmt = pstmt;
                                    }
                                }
                                SqlEditor.this._history;
                                SqlEditorHistory.getInstance().saveSql(cmd.getSQLOrig(), SqlEditor.this._db.getConnectionName());
                                if (SqlEditor.this.runReport) {
                                    if (cmd.getStmtId().equals("26") || cmd.getStmtId().equals("27")) {
                                        result = new ResultWrapper(null, Integer.toString(this.stmt.getUpdateCount()), true, bindResults);
                                        action = Translate.translate((String)SqlEditor.this.processOthers(sqlStmt));
                                    } else if (cmd.getResultsType() != null && cmd.getResultsType().equals("1")) {
                                        result = new ResultWrapper(null, "", true, bindResults);
                                    } else {
                                        result = new ResultWrapper(null, Integer.toString(this.stmt.getUpdateCount()), true, bindResults);
                                        action = cnt + " " + Translate.translate((String)"rows") + " ";
                                        action = cmd.getStmtId().equals("48") ? cnt + " " + Translate.translate((String)"rows") + " " + Translate.translate((String)"inserted") : (cmd.getStmtId().equals("88") ? cnt + " " + Translate.translate((String)"rows") + " " + Translate.translate((String)"updated") : (cmd.getStmtId().equals("31") ? cnt + " " + Translate.translate((String)"rows") + " " + Translate.translate((String)"deleted") : (cmd.getStmtId().equals("51") ? cnt + " " + Translate.translate((String)"rows") + " " + Translate.translate((String)"merged") : (cmd.getStmtId().equals("21") ? Translate.translate((String)"Commit complete") : (cmd.getStmtId().equals("68") ? Translate.translate((String)"Rollback complete") : Translate.translate((String)SqlEditor.this.processOthers(sqlStmt)))))));
                                    }
                                    break block56;
                                }
                                result = null;
                            }
                            Object var18_25 = null;
                        }
                        catch (Throwable throwable) {
                            Object var18_28 = null;
                            if (result == null || result._resultSet == null) {
                                try {
                                    if (this.stmt != null) {
                                        this.stmt.close();
                                    }
                                }
                                catch (Exception ex2) {
                                    Assert.printStackTrace((Throwable)ex2);
                                }
                                this.stmt = null;
                            }
                            if (SqlEditor.this.interrupted) {
                                SqlEditor.this.interrupted = false;
                                Log.status((String)Translate.translate((String)SQLWorksheetArb.getString(44)));
                            }
                            throw throwable;
                        }
                        if (result == null || result._resultSet == null) {
                            try {
                                if (this.stmt != null) {
                                    this.stmt.close();
                                }
                            }
                            catch (Exception ex2) {
                                Assert.printStackTrace((Throwable)ex2);
                            }
                            this.stmt = null;
                        }
                        if (SqlEditor.this.interrupted) {
                            SqlEditor.this.interrupted = false;
                            Log.status((String)Translate.translate((String)SQLWorksheetArb.getString(44)));
                        }
                        break block59;
                        {
                            catch (SQLException ex) {
                                ExceptionHandler.handleException((Exception)ex);
                                Log.status((String)Translate.translate((String)SQLWorksheetArb.getString(43)));
                                Object var18_26 = null;
                                if (result == null || result._resultSet == null) {
                                    try {
                                        if (this.stmt != null) {
                                            this.stmt.close();
                                        }
                                    }
                                    catch (Exception ex2) {
                                        Assert.printStackTrace((Throwable)ex2);
                                    }
                                    this.stmt = null;
                                }
                                if (SqlEditor.this.interrupted) {
                                    SqlEditor.this.interrupted = false;
                                    Log.status((String)Translate.translate((String)SQLWorksheetArb.getString(44)));
                                }
                                break block59;
                            }
                            catch (Exception ex) {
                                String exText = ex.toString();
                                result = new ResultWrapper(null, exText != null ? exText.trim() : exText, false, null);
                                Log.status((String)Translate.translate((String)SQLWorksheetArb.getString(43)));
                                Object var18_27 = null;
                                if (result == null || result._resultSet == null) {
                                    try {
                                        if (this.stmt != null) {
                                            this.stmt.close();
                                        }
                                    }
                                    catch (Exception ex2) {
                                        Assert.printStackTrace((Throwable)ex2);
                                    }
                                    this.stmt = null;
                                }
                                if (SqlEditor.this.interrupted) {
                                    SqlEditor.this.interrupted = false;
                                    Log.status((String)Translate.translate((String)SQLWorksheetArb.getString(44)));
                                }
                            }
                        }
                    }
                    if (result != null) {
                        result._stmt = this.stmt;
                        try {
                            if (this.stmt != null) {
                                this.stmt.close();
                            }
                        }
                        catch (SQLException e) {
                            // empty catch block
                        }
                    }
                    Ide.getStatusBar().setText(Translate.translate((String)action));
                }
                if (SqlEditor.this.view != null && result != null) {
                    if (cmd.getResultsType() != null && cmd.getResultsType().equals("1")) {
                        SqlEditor.this.start = System.currentTimeMillis();
                        SqlEditor.this.view.setQueryResultSet(result._resultSet, result._resultString, result._success, sqlStmt, result._binds);
                        SqlEditor.this.duration = System.currentTimeMillis() - SqlEditor.this.start;
                    } else {
                        SqlEditor.this.view.setResultSet(result._resultSet, result._resultString, result._success, sqlStmt, result._binds);
                    }
                    if (cmd.getResultsType() != null && cmd.getResultsType().equals("1")) {
                        try {
                            if (result._resultSet != null) {
                                result._resultSet.close();
                            }
                            if (result._stmt != null) {
                                result._stmt.close();
                            }
                            result = null;
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                }
                return new Object();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void finished() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    if (SqlEditor.this.view != null) {
                        SqlEditor.this.view.setEnabled(true);
                        SqlEditor.this.setExecuteInProgress(false);
                        SqlEditor.this.updateVisibleActions();
                        View.updateToolbarActions((Toolbar)SqlEditor.this.getToolbar());
                        SqlEditor.this.updateTimer(SqlEditor.this.duration);
                        SqlEditor.this.view.toggleProgress(false);
                    }
                    if (SqlEditor.this.interrupted) {
                        SqlEditor.this.interrupted = false;
                        Log.status((String)Translate.translate((String)SQLWorksheetArb.getString(44)));
                    }
                }
            }
        };
        this.worker.start();
    }

    public void updateVisibleActions(UpdateMessage updateMessage) {
        this.view.updateVisibleActions(updateMessage);
    }

    private String processOthers(String cmd) {
        String action = "";
        action = this.giveTokens(cmd) + " Statement Processed";
        return action;
    }

    private String giveTokens(String command) {
        String retVal = "";
        String[] stringArray = command.trim().split("[ \t\n\r]");
        if (stringArray != null) {
            for (int i = 0; i < 2; ++i) {
                if (stringArray.length <= i) continue;
                retVal = retVal + " " + stringArray[i].toLowerCase();
            }
            if (stringArray[1].equalsIgnoreCase("public") || stringArray[1].equalsIgnoreCase("materialized") || stringArray[1].equalsIgnoreCase("database")) {
                retVal = retVal + " " + stringArray[2];
            } else if (stringArray[1].equalsIgnoreCase("or") && stringArray[2].equalsIgnoreCase("replace")) {
                retVal = retVal + " " + stringArray[2] + " " + stringArray[3];
            }
        }
        return retVal;
    }

    public Database getDb() {
        return this._db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDb(Database db) {
        if (db == null && this._db == null) {
            this.close();
        } else if (db != this._db) {
            this._db = db;
            Connection localConn = null;
            Statement stmt = null;
            try {
                localConn = db.getConnection();
                stmt = localConn.createStatement();
                stmt.execute("declare\n    nm  owa.vc_arr;\n    vl  owa.vc_arr;\nbegin\n    nm(1) := 'SERVER_PORT';\n    vl(1) := '80';\n    owa.init_cgi_env( 1, nm, vl );\nend;");
            }
            catch (SQLException se) {
            }
            finally {
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException e) {}
                }
            }
            if (this.getContext().getNode() instanceof SqlEditorNode) {
                ((SqlEditorNode)this.getContext().getNode()).setDb(this._db);
            }
            this.view.setConnections(db.getConnection());
            this.view.invokeInsight();
        }
    }

    protected Element[] getSelectionFromUI() {
        Element[] elementArray;
        Node n = this.getContext().getNode();
        if (n != null) {
            Element[] elementArray2 = new Element[1];
            elementArray = elementArray2;
            elementArray2[0] = n;
        } else {
            elementArray = super.getSelectionFromUI();
        }
        return elementArray;
    }

    final void saveWorksheet() {
        this.saveWorksheet(false);
    }

    final void saveWorksheet(boolean prompt) {
        this.view.saveView(prompt);
    }

    public void markDirty(boolean dirty) {
        this.getContext().getNode().markDirty(dirty);
        if (this.getContext().getNode() instanceof SqlEditorNode) {
            ((SqlEditorNode)this.getContext().getNode()).getSqlNode().markDirty(dirty);
        }
    }

    final void printWorksheet() {
        this.view.printView();
    }

    final void openWorksheet() {
        this.view.openWsFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void executeExplainPlan() {
        this.view.toggleProgress(true);
        try {
            String sql = this.getStatementAtLine(this.view.getSqlStatement());
            if (sql == null || sql.length() < 1) {
                Ide.getStatusBar().setText(ConnectionArb.getString((int)175));
                return;
            }
            this.view.explainPlan(sql);
        }
        catch (Exception ex) {
            Assert.printStackTrace((Throwable)ex);
        }
        finally {
            this.view.toggleProgress(false);
        }
    }

    private String getStatementAtLine(String sql) {
        ScriptParser parser = new ScriptParser(sql);
        parser.parse();
        SQLCommand[] cmds = parser.getSqlStatements();
        int lineNumber = this.view.getCaretLine();
        int i = 0;
        int index = 0;
        boolean matchFound = false;
        for (i = 0; i < cmds.length; ++i) {
            if (lineNumber - 1 < cmds[i].getStartLine() || lineNumber - 1 > cmds[i].getEndLine()) continue;
            index = i;
            matchFound = true;
        }
        sql = matchFound ? cmds[index].getSql() : null;
        return sql;
    }

    final void executeScriptRunnerPlan() {
        this.executeScriptRunnerPlan(false);
    }

    final void executeScriptRunnerPlan(boolean isStatement) {
        this.view.toggleProgress(true);
        try {
            String sql = this.view.getSqlStatement();
            this.start = System.currentTimeMillis();
            if (isStatement) {
                ScriptParser parser = new ScriptParser(sql);
                parser.parse();
                SQLCommand[] cmds = parser.getSqlStatements();
                int lineNumber = this.view.getCaretLine();
                int i = 0;
                int index = 0;
                for (i = 0; i < cmds.length; ++i) {
                    if (lineNumber - 1 < cmds[i].getStartLine() || lineNumber - 1 > cmds[i].getEndLine()) continue;
                    index = i;
                }
                sql = cmds[index].getSQLOrig();
            }
            if (sql == null || sql.length() < 1) {
                Ide.getStatusBar().setText(ConnectionArb.getString((int)175));
                return;
            }
            this.setExecuteInProgress(true);
            View.updateToolbarActions((Toolbar)this.getToolbar());
            Log.status((String)Translate.translate((String)SQLWorksheetArb.getString(46)));
            this.view.scriptRunner(sql);
            this.view.setEnabled(true);
            this.updateVisibleActions();
            SwingWorker scriptWaiter = new SwingWorker(){

                public Object construct() {
                    while (!SqlEditor.this.view.isFinished()) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    return null;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void finished() {
                    2 var1_1 = this;
                    synchronized (var1_1) {
                        SqlEditor.this.duration = System.currentTimeMillis() - SqlEditor.this.start;
                        SqlEditor.this.updateTimer(SqlEditor.this.duration);
                        SqlEditor.this.view.toggleProgress(false);
                        Log.status((String)Translate.translate((String)SQLWorksheetArb.getString(48)));
                        SqlEditor.this.setExecuteInProgress(false);
                        View.updateToolbarActions((Toolbar)SqlEditor.this.getToolbar());
                    }
                }
            };
            scriptWaiter.start();
        }
        catch (Exception ex) {
            Log.status((String)Translate.translate((String)SQLWorksheetArb.getString(47)));
            Assert.printStackTrace((Throwable)ex);
        }
    }

    public final void doHistoryList() {
        this._history.displayHistory((JTextComponent)this.view.getSQLEditorPane());
    }

    public void setText(String sqlViewerText) {
        this.view.setSQLText(sqlViewerText);
    }

    public String getText() {
        return this.view.getSQLText();
    }

    public boolean hasText() {
        return this.view.hasText(true);
    }

    public boolean canRefreshView() {
        return this.view != null && this.view.canRefreshView();
    }

    public void refreshView() {
        if (this.view != null) {
            this.view.refreshView();
        }
    }

    public Component getGUI() {
        if (null == this.view) {
            this._createGUI();
        }
        return this.view;
    }

    public Object getEditorAttribute(String attribute) {
        if ("horizontal_scrollbar_policy".equals(attribute)) {
            return new Integer(31);
        }
        if ("vertical_scrollbar_policy".equals(attribute)) {
            return new Integer(21);
        }
        if ("scrollable".equals(attribute)) {
            return Boolean.FALSE;
        }
        return super.getEditorAttribute(attribute);
    }

    public Component getDefaultFocusComponent() {
        return this.view.getSQLEditorPane();
    }

    public String getTitleLabel() {
        Node node = this.getContext().getNode();
        return node != null ? SqlEditor._getTitle(node.getURL()) : super.getTitleLabel();
    }

    private static String _getTitle(URL url) {
        return url.getPath();
    }

    public void open() {
        this._controller.attachToContextMenu();
    }

    boolean isExplainPlanAllowed() {
        return this._isOracle;
    }

    boolean isScriptRunnerAllowed() {
        return this._isOracle;
    }

    synchronized boolean isExecuteInProgress() {
        return this._isExecuting;
    }

    synchronized void setExecuteInProgress(boolean executing) {
        this._isExecuting = executing;
    }

    private SqlEditorNode _getNode(Element element) {
        if (element instanceof SqlEditorNode) {
            return (SqlEditorNode)element;
        }
        if (element instanceof Locatable) {
            Locatable locatable = (Locatable)element;
            URL url = locatable.getURL();
            String connName = CmUtil.getConnName((URL)url);
            URL nodeURL = URLFactory.newURL((String)"ide.sqlEditorNode", (String)connName);
            return SqlEditorNode.findOrCreateNode(nodeURL);
        }
        return null;
    }

    public synchronized void close() {
        this._savePersistentSettings();
        if (this.getContext().getNode() instanceof SqlEditorNode && ((SqlEditorNode)this.getContext().getNode()).getSqlNode() != null && ((SqlEditorNode)this.getContext().getNode()).isTempFile()) {
            try {
                ((SqlEditorNode)this.getContext().getNode()).getSqlNode().close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        ArrayList<SqlEditor> a = new ArrayList<SqlEditor>();
        a.add(this);
        try {
            EditorManager.getEditorManager().closeEditors(a);
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.close();
        this._controller.detachToContextMenu();
        this._releaseGUI();
    }

    public void update(Object observed, UpdateMessage change) {
    }

    public Controller getController() {
        return this._controller;
    }

    public BasicEditorPane getFocusedEditorPane() {
        return (BasicEditorPane)(this.getFocusedComponent() instanceof BasicEditorPane ? this.getFocusedComponent() : this.view.getSQLEditorPane());
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_sqlviewer_html");
    }

    private void _createGUI() {
        SqlNode sn;
        File f;
        if (Ide.isStarting() && this.getContext().getNode() instanceof SqlNode) {
            SqlNode node = (SqlNode)this.getContext().getNode();
            String working = Ide.getWorkDirectory().replaceAll("\\\\", "_");
            String path = node.getURL().getFile().substring(1).replaceAll("/", "_");
            if (path.indexOf(working) == 0) {
                return;
            }
        }
        this.view = new SqlEditorMainPanel(this);
        this._applyPersistentSettings();
        this.view.getCustomTabbedPanel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                SqlEditor.this._activeSubPage = SqlEditor.this.view.getActivePanel();
                SqlEditor.this.updateVisibleActions();
            }
        });
        KeyStrokeOptions kso = Ide.getSettings().getKeyStrokeOptions();
        kso.addChangeListener((ChangeListener)this);
        this.updateKeyMap(kso);
        Node node = this.getContext().getNode();
        if (node instanceof SqlNode && !(f = new File((sn = (SqlNode)node).getURL().getFile())).exists()) {
            try {
                f.createNewFile();
            }
            catch (IOException e1) {
                MessageDialog.information((Component)Ide.getMainWindow(), (Object)"Could Create File", (String)f.getAbsolutePath(), null);
            }
        }
        this.view.setNode(node);
    }

    public String getMD5(String s) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(s.getBytes());
            return new String(md5.digest());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    public void setMD5(String s) {
        this._md5 = this.getMD5(s);
    }

    public boolean hasChanged() {
        SqlNode node = null;
        if (this.getContext().getNode() instanceof SqlNode) {
            node = (SqlNode)this.getContext().getNode();
        } else if (this.getContext().getNode() instanceof SqlEditorNode) {
            node = ((SqlEditorNode)this.getContext().getNode()).getSqlNode();
        }
        return node.isDirty();
    }

    private void _releaseGUI() {
        if (this.view != null) {
            KeyStrokeOptions kso = Ide.getSettings().getKeyStrokeOptions();
            kso.removeChangeListener((ChangeListener)this);
            this.view.dispose();
            this.view = null;
        }
    }

    CopyableResultSetTableAdapter getCopyableJTableAdapter() {
        return this._copyableTableAdapter;
    }

    void setCopyableJTableAdapter(CopyableResultSetTableAdapter adapter) {
        this._copyableTableAdapter = adapter;
    }

    public Component getFocusedComponent() {
        return this.focusedComponent;
    }

    void setFocusedComponent(Component comp) {
        this.focusedComponent = comp;
    }

    public Toolbar getToolbar() {
        return this.view != null ? this.view.getToolbar() : null;
    }

    public Connection getConnection() {
        return this._db.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SqlEditor openNewEditor(SqlNode node, String connName) {
        SqlEditor se = null;
        try {
            if (node == null) return se;
            if (_isOpening) return se;
            _isOpening = true;
            node.ensureOpen();
            SqlEditorNode sen = new SqlEditorNode(connName);
            sen.setSqlNode(node);
            Database db = sen.getDatabase();
            if (db == null) {
                SqlEditor sqlEditor = null;
                return sqlEditor;
            }
            Context ctx = Context.newIdeContext((Node)sen);
            OpenEditorOptions openEditorOptions = new OpenEditorOptions(ctx);
            openEditorOptions.setFlags(1);
            WaitCursor waitCursor = Ide.getWaitCursor();
            try {
                waitCursor.show(0L);
                se = (SqlEditor)EditorManager.getEditorManager().openEditor(openEditorOptions);
                ((SqlEditorNode)se.getContext().getNode()).add(se);
                if (connName == null) return se;
                se.setDb(db);
                return se;
            }
            catch (Exception e) {
                return se;
            }
            finally {
                waitCursor.hide();
            }
        }
        finally {
            _isOpening = false;
        }
    }

    public static SqlEditor openNewEditor(String connName) {
        SqlEditor se = null;
        try {
            File tmpFile = File.createTempFile(TMP_FILE_PREFIX, ".sql", Resource.raptorUserTmp);
            tmpFile.deleteOnExit();
            SqlNode s = null;
            s = (SqlNode)NodeFactory.findOrCreate((URL)tmpFile.toURL());
            s.ensureOpen();
            se = SqlEditor.openNewEditor(s, connName);
            if (se != null) {
                SqlEditorNode sen = (SqlEditorNode)se.getContext().getNode();
                sen.setTempFile(true);
                sen.add(se);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return se;
    }

    private ArrayList getBinds(String in) {
        int index2;
        String livePortion = "";
        ArrayList<String> retVal = new ArrayList<String>();
        if (in == null) {
            in = "";
        }
        int index = 0;
        int soFar = 0;
        String passOn = "";
        in = in + " ";
        while (true) {
            if ((index = in.indexOf("/*", soFar)) == -1) {
                if (soFar >= in.length()) break;
                passOn = passOn + "|" + in.substring(soFar);
                break;
            }
            passOn = passOn + "|" + in.substring(soFar, index);
            if (index + 2 >= in.length() || (index2 = in.indexOf("*/", index + 2)) == -1) break;
            soFar = index2 + 2;
        }
        in = passOn;
        in = in + " ";
        index = 0;
        soFar = 0;
        passOn = "";
        while (true) {
            if ((index = in.indexOf("--", soFar)) == -1) {
                if (soFar >= in.length()) break;
                passOn = passOn + "|" + in.substring(soFar);
                break;
            }
            passOn = passOn + "|" + in.substring(soFar, index);
            if (index + 2 >= in.length() || (index2 = in.indexOf("\n", index + 2)) == -1) break;
            soFar = index2 + 1;
        }
        in = passOn;
        in = in + " ";
        index = 0;
        soFar = 0;
        passOn = "";
        boolean endOfString = false;
        block2: while (!endOfString) {
            block11: {
                boolean doubleQuote;
                index = in.indexOf("'", soFar);
                if (index == -1) {
                    if (soFar >= in.length()) break;
                    passOn = passOn + "|" + in.substring(soFar);
                    break;
                }
                passOn = passOn + "|" + in.substring(soFar, index);
                soFar = index + 1;
                do {
                    if ((index = in.indexOf("'", soFar)) == -1) {
                        endOfString = true;
                        continue block2;
                    }
                    if (index + 1 >= in.length()) break block11;
                    doubleQuote = false;
                    if (in.charAt(index + 1) != '\'') continue;
                    doubleQuote = true;
                    soFar = index + 2;
                } while (doubleQuote);
                soFar = index + 1;
                continue;
            }
            endOfString = true;
        }
        in = in + " ";
        in = passOn;
        index = 0;
        while ((index = passOn.indexOf(":", index)) != -1) {
            char nextChar;
            ++index;
            String value = ":";
            while (Character.isLetterOrDigit(nextChar = passOn.charAt(index)) || nextChar == '_') {
                value = value + nextChar;
                ++index;
            }
            if (value.equals(":")) continue;
            retVal.add(value);
        }
        return retVal;
    }

    public Database getDatabase() {
        return this._db;
    }

    private void _applyPersistentSettings() {
        NiceTablePersistentSettings settings = null;
        try {
            URL url = this._getPersistentSettingsSaveURL();
            Object2Dom o2d = Object2Dom.newInstance();
            settings = (NiceTablePersistentSettings)o2d.toObject(url);
        }
        catch (FileNotFoundException ex) {
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (settings != null) {
            this.view.setPersistentSettings(settings);
        }
    }

    private void _savePersistentSettings() {
        if (this.view != null && this.view.getPersistentSettings() != null) {
            final NiceTablePersistentSettings settings = this.view.getPersistentSettings();
            final URL url = this._getPersistentSettingsSaveURL();
            final Object2Dom o2d = Object2Dom.newInstance();
            o2d.setNamespaceURI(NAMESPACE_URI);
            SwingWorker _worker = new SwingWorker(){

                public Object construct() {
                    try {
                        o2d.toDocument((Object)settings, SqlEditor.ROOT_TAG, url);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    return this;
                }
            };
            _worker.start();
        }
    }

    private URL _getPersistentSettingsSaveURL() {
        ExtensionRegistry er = ExtensionRegistry.getOracleRegistry();
        URL url = er.getSystemDirectory(SQLWORKSHEET_EXTENSION_ID);
        return URLFactory.newURL((URL)url, (String)SQLWORKSHEET_ATTRIBUTE_FILE);
    }

    public void updateTimer(long time) {
        this.view.updateTimer(time);
    }

    public void refreshTimer() {
        this.view.refreshTimer();
    }

    public SqlEditorMainPanel getView() {
        return this.view;
    }

    public void setFocusOnNextTab() {
        CustomTabbedPane ctp = this.view.getCustomTabbedPanel();
        int currIndex = ctp.getSelectedIndex();
        int numTabs = ctp.getNumberOfTabs() - 1;
        boolean isEditorFocus = false;
        if (this.focusedComponent == this.getDefaultFocusComponent()) {
            isEditorFocus = true;
        }
        if (isEditorFocus) {
            ctp.setSelectedIndex(0);
        } else if (currIndex == numTabs) {
            Component componentDefault = this.getDefaultFocusComponent();
            componentDefault.requestFocus();
        } else {
            ctp.setSelectedIndex(currIndex + 1);
        }
    }

    public void setFocusOnPreviousTab() {
        CustomTabbedPane ctp = this.view.getCustomTabbedPanel();
        int currIndex = ctp.getSelectedIndex();
        int numTabs = ctp.getNumberOfTabs() - 1;
        boolean isEditorFocus = false;
        if (this.focusedComponent == this.getDefaultFocusComponent()) {
            isEditorFocus = true;
        }
        if (isEditorFocus) {
            ctp.setSelectedIndex(numTabs);
        } else if (currIndex == 0) {
            Component componentDefault = this.getDefaultFocusComponent();
            componentDefault.requestFocus();
        } else {
            ctp.setSelectedIndex(currIndex - 1);
        }
    }

    public Context getContext(EventObject eo) {
        Context ctx = super.getContext(eo);
        if (ctx != null && this._db != null) {
            ConnectionContext.setConnectionNode((Context)ctx, (ConnectionNode)Connections.getInstance().getDBConnectionNode(this._db.getConnectionName()));
        }
        return ctx;
    }

    public void stateChanged(ChangeEvent e) {
        KeyStrokeOptions kso = Ide.getSettings().getKeyStrokeOptions();
        if (e.getSource() == kso) {
            this.updateKeyMap(kso);
        }
    }

    private void updateKeyMap(KeyStrokeOptions kso) {
        KeyStrokeContextRegistry kscr = Ide.getKeyStrokeContextRegistry();
        KeyStrokeContext ksc = kscr.getContext("oracle/dbtools/sqlworksheet/sqlview/accelerators.xml");
        MultiInputMap imap = MultiMapAdapter.getLocalMap((KeyStrokeOptions)kso, (KeyStrokeContext)ksc);
        MultiMapAdapter.fillLocalMap((MultiInputMap)imap, (KeyStrokeOptions)kso, (KeyStrokeContext)ksc);
        this.view.setInputMap(1, (InputMap)imap);
    }

    public JComponent[] getCustomCells() {
        if (this.view != null && this.view.getStatusBar() != null) {
            return this.view.getStatusBar().getStatusBarCells();
        }
        return null;
    }

    public boolean isExpandable(JComponent customCell) {
        return false;
    }

    private static class ResultWrapper {
        private ResultSet _resultSet;
        private String _resultString;
        private boolean _success;
        private Statement _stmt;
        private HashMap _binds;

        ResultWrapper(ResultSet rs, String str, boolean success, HashMap binds) {
            this._resultSet = rs;
            this._resultString = str;
            this._success = success;
            this._binds = binds;
        }
    }
}

