/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlworksheet.sqlview;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JMenuItem;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.utils.Translate;
import oracle.dbtools.sqlworksheet.SQLWorksheetArb;
import oracle.dbtools.sqlworksheet.dbmsoutput.DbmsOutputController;
import oracle.dbtools.sqlworksheet.owaoutput.OWAOutputController;
import oracle.dbtools.sqlworksheet.scriptRunner.ScriptRunnerController;
import oracle.dbtools.sqlworksheet.sqlview.SqlEditor;
import oracle.dbtools.sqlworksheet.sqlview.SqlEditorController;
import oracle.dbtools.sqlworksheet.sqlview.SqlEditorNode;
import oracle.dbtools.sqlworksheet.sqlview.SqlEditorPrintFactory;
import oracle.dbtools.sqlworksheet.sqlview.SqlEditorTempFileTimer;
import oracle.dbtools.sqlworksheet.sqlview.SqlEditorWizard;
import oracle.dbtools.sqlworksheet.sqlview.SqlLaunchOnOpen;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorManager;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.model.Element;
import oracle.ide.model.Recognizer;
import oracle.ide.print.PrintManager;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.util.Assert;
import oracle.ide.util.MenuSpec;
import oracle.ide.wizard.Wizard;
import oracle.ide.wizard.WizardManager;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdevimpl.cm.dt.sqlplus.SqlNode;

public final class SqlEditorAddin
extends EditorAddin {
    public static final int OPEN_SQL_WORKSHEET = Ide.findOrCreateCmdID((String)"openSQLWorksheet");
    private ActionListener _openSQLEditor = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            WizardManager.getInstance().invokeWizard((Wizard)new SqlEditorWizard(), Context.newIdeContext(), null, null);
        }
    };

    public void initialize() {
        SqlEditorNode.registerProtocol(this.getNodeProtocol(), this.getNodeClass());
        EditorManager.getEditorManager().registerDynamic((EditorAddin)this);
        SqlEditorController.createActions();
        SqlEditorController.createActions();
        new DbmsOutputController().createActions();
        new OWAOutputController().createActions();
        new ScriptRunnerController().createActions();
        new SqlLaunchOnOpen();
        this.initMenu();
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        keyStrokeContextRegistry.addAcceleratorDefinitionFile(((Object)((Object)this)).getClass().getClassLoader(), "oracle/dbtools/sqlworksheet/sqlview/accelerators.xml");
        PrintManager.getPrintManager().registerDocumentPrintFactory(SqlEditor.class, SqlEditorPrintFactory.class);
        Recognizer.registerConversion(SqlNode.class, SqlEditorNode.class);
        Class[] types = new Class[]{SqlNode.class, SqlEditorNode.class};
        EditorManager.getEditorManager().register((EditorAddin)AddinManager.getAddinManager().getAddin(SqlEditorAddin.class), types);
        int delay = 5000;
        int period = 60000;
        Timer timer = new Timer();
        timer.scheduleAtFixedRate((TimerTask)new SqlEditorTempFileTimer(), delay, (long)period);
        Assert.print((String)"SQLView inited");
    }

    public void initMenu() {
        String label = ConnectionArb.getString((int)163);
        IdeAction action = IdeAction.get((int)OPEN_SQL_WORKSHEET, null, (String)StringUtils.stripMnemonic((String)label), (String)IdeMainWindow.ACTION_CATEGORY_TOOLS, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)label)), (ArrayResourceBundle)SQLWorksheetArb.getInstance(), (int)9, null, (boolean)true);
        Menubar menubar = Ide.getMenubar();
        JMenuItem firstActionMenu = menubar.createMenuItem((ToggleAction)action, 1.0f);
        firstActionMenu.addActionListener(this._openSQLEditor);
        menubar.add((Component)firstActionMenu, MenuManager.getJMenu((String)"Tools"));
    }

    public boolean isDefault() {
        return true;
    }

    public boolean isDuplicable() {
        return false;
    }

    public Class getEditorClass() {
        return SqlEditor.class;
    }

    protected Wizard getWizard() {
        return new SqlEditorWizard();
    }

    protected String getNodeProtocol() {
        return "ide.sqlEditorNode";
    }

    protected Class getNodeClass() {
        return SqlEditorNode.class;
    }

    public MenuSpec getMenuSpecification() {
        return new MenuSpec(Translate.translate((String)"SQL_Worksheet"), null, null, -1);
    }

    public float getEditorWeight(Element element) {
        return element instanceof SqlEditorNode ? 0.5f : Float.NaN;
    }
}

