/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlworksheet.sqlview;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import javax.swing.text.JTextComponent;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.CommonArb;
import oracle.dbtools.raptor.controls.ConnectionSelectorUI;
import oracle.dbtools.raptor.controls.CopyableResultSetTableAdapter;
import oracle.dbtools.raptor.utils.CMHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.Log;
import oracle.dbtools.raptor.utils.Translate;
import oracle.dbtools.sqlworksheet.SQLWorksheetArb;
import oracle.dbtools.sqlworksheet.sqlview.SqlEditor;
import oracle.dbtools.sqlworksheet.sqlview.SqlEditorNode;
import oracle.dbtools.sqlworksheet.sqlview.SqlEditorWizard;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.DynamicMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.editor.EditorConstants;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Node;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.view.View;
import oracle.ide.wizard.Wizard;
import oracle.ide.wizard.WizardManager;
import oracle.javatools.editor.BasicEditorPane;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdeveloper.cm.ConnectionEvent;
import oracle.jdeveloper.cm.ConnectionListener;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdeveloper.cm.dt.ConnectionContext;
import oracle.jdeveloper.cm.dt.ConnectionNode;
import oracle.jdevimpl.cm.dt.sqlplus.SqlNode;
import oracle.jdevimpl.runner.run.RunArb;

final class SqlEditorController
implements Controller,
ContextMenuListener,
DynamicMenuListener {
    static final String ACCELERATOR_FILE = "oracle/dbtools/sqlworksheet/sqlview/accelerators.xml";
    private static SqlEditorController _instance;
    private int ctxCount;
    private static final String openToolbarEditor = "open.sqleditor";
    static final int HISTORY_CMD_ID;
    static final int EXPLAIN_PLAN_CMD_ID;
    static final int EXECUTE_SQL_CMD_ID;
    static final int SCRIPT_RUNNER_CMD_ID;
    static final int SW_OPEN_CMD_ID;
    static final int SW_SAVE_CMD_ID;
    static final int SW_PRINT_CMD_ID;
    static final int OPEN_SW_CMD_ID;
    static final int CLEAR_CMD_ID;
    static final int CANCEL_CMD_ID;
    static final int COMMIT_CMD_ID;
    static final int ROLLBACK_CMD_ID;
    private static IdeAction sqlWorksheetToolbarOpen;
    private static IdeAction executeSqlAction;
    private static IdeAction explainPlanAction;
    private static IdeAction scriptRunnerAction;
    private static IdeAction historyAction;
    private static IdeAction openAction;
    private static IdeAction saveAction;
    private static IdeAction printAction;
    private static IdeAction toolBarLauncher;
    private static IdeAction clearAction;
    private static IdeAction cancelAction;
    private static IdeAction ideCutAction;
    private static IdeAction ideCopyAction;
    private static IdeAction ideExtendedPasteAction;
    private static IdeAction idePasteAction;
    private static IdeAction ideDeleteAction;
    private static IdeAction ideSelectAllAction;
    private static IdeAction ideNavigateAction;
    private static IdeAction ideUndoAction;
    private static IdeAction ideRedoAction;
    private static IdeAction ideToggleBookmark;
    private static IdeAction commitAction;
    private static IdeAction rollbackAction;
    private static IdeAction ideRefresh;
    private static IdeAction[] woractions;
    private static Connections _conns;
    private int lastRunCmd = 0;
    static String category;
    private static final JComponent[] EMPTY_MENUS;

    static void createActions() {
        IdeAction.find((int)74).setEnabled(true);
        IdeAction.find((int)73).setEnabled(true);
        IdeAction.find((int)73).addController((Controller)SqlEditorController.getInstance());
        IdeAction.find((int)74).addController((Controller)SqlEditorController.getInstance());
        IdeAction.find((int)11).addController((Controller)SqlEditorController.getInstance());
        category = ConnectionArb.getString((int)20);
        executeSqlAction = SqlEditorController.createAction(EXECUTE_SQL_CMD_ID, SQLWorksheetArb.getString(35), 3, category, RunArb.getInstance());
        commitAction = SqlEditorController.createAction(COMMIT_CMD_ID, SQLWorksheetArb.getString(50), 679, category);
        rollbackAction = SqlEditorController.createAction(ROLLBACK_CMD_ID, SQLWorksheetArb.getString(51), 680, category);
        historyAction = SqlEditorController.createAction(HISTORY_CMD_ID, ConnectionArb.getString((int)178), 179, category);
        explainPlanAction = SqlEditorController.createAction(EXPLAIN_PLAN_CMD_ID, ConnectionArb.getString((int)177), 159, category);
        scriptRunnerAction = SqlEditorController.createAction(SCRIPT_RUNNER_CMD_ID, SQLWorksheetArb.getString(36), 37, category, SQLWorksheetArb.getInstance());
        saveAction = SqlEditorController.createAction(SW_SAVE_CMD_ID, SQLWorksheetArb.getString(20), 18, IdeMainWindow.ACTION_CATEGORY_FILE, SQLWorksheetArb.getInstance());
        printAction = SqlEditorController.createAction(SW_PRINT_CMD_ID, SQLWorksheetArb.getString(41), 40, IdeMainWindow.ACTION_CATEGORY_FILE, SQLWorksheetArb.getInstance());
        openAction = SqlEditorController.createAction(SW_OPEN_CMD_ID, SQLWorksheetArb.getString(19), 17, IdeMainWindow.ACTION_CATEGORY_FILE, SQLWorksheetArb.getInstance());
        clearAction = SqlEditorController.createAction(CLEAR_CMD_ID, SQLWorksheetArb.getString(5), 6, IdeMainWindow.ACTION_CATEGORY_FILE, SQLWorksheetArb.getInstance());
        cancelAction = SqlEditorController.createAction(CANCEL_CMD_ID, SQLWorksheetArb.getString(7), 8, IdeMainWindow.ACTION_CATEGORY_FILE, SQLWorksheetArb.getInstance());
        IdeAction.get((int)OPEN_SW_CMD_ID, null, (String)StringUtils.stripMnemonic((String)SQLWorksheetArb.getString(21)), (String)category, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)SQLWorksheetArb.getString(21))), (ArrayResourceBundle)CommonArb.getInstance(), (int)0, null, (boolean)false);
        sqlWorksheetToolbarOpen = IdeAction.get((int)OPEN_SW_CMD_ID);
        sqlWorksheetToolbarOpen.addController((Controller)SqlEditorController.getInstance());
        sqlWorksheetToolbarOpen.setEnabled(true);
        sqlWorksheetToolbarOpen.putValue("ActionMenuActions", (Object)SqlEditorController.getConnectionActions());
        _conns.getCm().addConnectionListener(new ConnectionListener(){

            public void connectionAdded(ConnectionEvent connectionEvent) {
                sqlWorksheetToolbarOpen.putValue("ActionMenuActions", (Object)SqlEditorController.getConnectionActions());
            }

            public void connectionRemoved(ConnectionEvent connectionEvent) {
                sqlWorksheetToolbarOpen.putValue("ActionMenuActions", (Object)SqlEditorController.getConnectionActions());
            }

            public void connectionModified(ConnectionEvent connectionEvent) {
            }

            public void connectionOpened(ConnectionEvent connectionEvent) {
            }

            public void connectionClosed(ConnectionEvent connectionEvent) {
            }
        });
    }

    private static IdeAction[] getConnectionActions() {
        Object[] names = _conns.getConnNames();
        Arrays.sort(names);
        IdeAction[] actions = new IdeAction[names.length];
        for (int i = 0; i < names.length; ++i) {
            actions[i] = SqlEditorController.createToolbarAction((String)names[i]);
        }
        return actions;
    }

    private static void renameRunAction(String name) {
    }

    private static IdeAction createToolbarAction(String connName) {
        IdeAction action = IdeAction.get((int)Ide.findOrCreateCmdID((String)(SW_OPEN_CMD_ID + "/" + connName)), (String)null, (String)connName);
        action.setEnabled(true);
        action.addController((Controller)SqlEditorController.getInstance());
        action.putValue(openToolbarEditor, (Object)connName);
        return action;
    }

    private static IdeAction createAction(int id, String name, int icon, String category) {
        return SqlEditorController.createAction(id, name, icon, category, ConnectionArb.getInstance());
    }

    private static IdeAction createAction(int id, String name, int icon, String category, ArrayResourceBundle resource) {
        String label = StringUtils.stripMnemonic((String)name);
        Integer mnemonic = new Integer(StringUtils.getMnemonicKeyCode((String)name));
        return IdeAction.get((int)id, null, (String)label, (String)category, (Integer)mnemonic, (ArrayResourceBundle)resource, (int)icon, null, (boolean)false);
    }

    static synchronized SqlEditorController getInstance() {
        if (_instance == null) {
            _instance = new SqlEditorController();
        }
        return _instance;
    }

    private SqlEditorController() {
        Ide.getMainWindow().addDynamicMenuListener((DynamicMenuListener)this);
        SqlEditorController.initializeIDEActions();
    }

    void attachToContextMenu() {
        if (this.ctxCount++ == 0) {
            EditorManager.getEditorManager().getContextMenu().addContextMenuListener((ContextMenuListener)this, null);
        }
    }

    void detachToContextMenu() {
        if (--this.ctxCount == 0) {
            EditorManager.getEditorManager().getContextMenu().removeContextMenuListener((ContextMenuListener)this);
        }
    }

    private static void initializeIDEActions() {
        ideCutAction = IdeAction.find((int)17);
        ideCopyAction = IdeAction.find((int)18);
        ideExtendedPasteAction = IdeAction.find((int)78);
        idePasteAction = IdeAction.find((int)19);
        ideDeleteAction = IdeAction.find((int)20);
        ideSelectAllAction = IdeAction.find((int)22);
        ideNavigateAction = IdeAction.find((int)57);
        ideUndoAction = IdeAction.find((int)5);
        ideRedoAction = IdeAction.find((int)6);
        ideToggleBookmark = IdeAction.find((int)79);
        ideRefresh = IdeAction.find((int)51);
    }

    public boolean update(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == OPEN_SW_CMD_ID) {
            return true;
        }
        View view = context.getView();
        if (!(view instanceof SqlEditor)) {
            return false;
        }
        SqlEditor editor = (SqlEditor)view;
        Component component = editor.getFocusedComponent();
        boolean editorHasText = editor.hasText();
        boolean isExecuting = editor.isExecuteInProgress();
        boolean isdbready = false;
        if (editor.getDatabase() != null) {
            isdbready = true;
        }
        if (cmdId == 17) {
            action.setEnabled(SqlEditorController.canPerformCut(component));
            return true;
        }
        if (cmdId == 18) {
            action.setEnabled(this.canPerformCopy(editor, component));
            return true;
        }
        if (cmdId == 19 || cmdId == 78) {
            action.setEnabled(SqlEditorController.canPerformPaste(component));
            return true;
        }
        if (cmdId == 20) {
            action.setEnabled(this.canPerformDelete(component));
            return true;
        }
        if (cmdId == 22) {
            action.setEnabled(SqlEditorController.canPerformSelectAll(component));
            return true;
        }
        if (cmdId == 57) {
            action.setEnabled(false);
            return false;
        }
        if (cmdId == EXPLAIN_PLAN_CMD_ID && editor.getDatabase() != null) {
            boolean isExplainPlanAllowed = editor.isExplainPlanAllowed();
            action.setEnabled(isExplainPlanAllowed && editorHasText && !isExecuting);
            return true;
        }
        if (cmdId == SCRIPT_RUNNER_CMD_ID && editor.getDatabase() != null) {
            boolean isScriptRunnerAllowed = editor.isScriptRunnerAllowed();
            action.setEnabled(isScriptRunnerAllowed && editorHasText && !isExecuting);
            return true;
        }
        if (cmdId == EXECUTE_SQL_CMD_ID && editor.getDatabase() != null) {
            action.setEnabled(editorHasText && !isExecuting);
            return true;
        }
        if (cmdId == SW_SAVE_CMD_ID) {
            action.setEnabled(!isExecuting);
            return true;
        }
        if (cmdId == SW_PRINT_CMD_ID) {
            action.setEnabled(!isExecuting);
            return true;
        }
        if (cmdId == SW_OPEN_CMD_ID) {
            action.setEnabled(!isExecuting);
            return true;
        }
        if (cmdId == HISTORY_CMD_ID) {
            int size = editor.getHistorySize();
            action.setEnabled(size > 0 && !isExecuting);
            return true;
        }
        if (cmdId == 51 && editor.getDatabase() != null) {
            action.setEnabled(editor.canRefreshView() && !isExecuting);
            return true;
        }
        if (cmdId == CLEAR_CMD_ID) {
            action.setEnabled(!isExecuting);
            return true;
        }
        if (cmdId == CANCEL_CMD_ID && editor.getDatabase() != null) {
            action.setEnabled(false);
            if (isExecuting) {
                action.setEnabled(true);
            }
            return true;
        }
        if (cmdId == 11) {
            action.setEnabled(true);
            return true;
        }
        if (cmdId == 74 || cmdId == 73) {
            action.setEnabled(true);
            return true;
        }
        if (cmdId == COMMIT_CMD_ID) {
            action.setEnabled(isdbready);
            return true;
        }
        if (cmdId == ROLLBACK_CMD_ID) {
            action.setEnabled(isdbready);
            return true;
        }
        return false;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        View view;
        int cmdId = action.getCommandId();
        if (cmdId == OPEN_SW_CMD_ID) {
            SqlEditorController.toolbarAction(null);
        }
        if (action.getValue(openToolbarEditor) != null) {
            SqlEditorController.toolbarAction((String)action.getValue(openToolbarEditor));
        }
        if (!((view = context.getView()) instanceof SqlEditor)) {
            return false;
        }
        SqlEditor editor = (SqlEditor)view;
        Log.status((String)Translate.translate((String)""));
        editor.refreshTimer();
        Component component = editor.getFocusedComponent();
        if (cmdId == 17) {
            this.performCut(component);
            component.requestFocus();
            return true;
        }
        if (cmdId == 18) {
            this.performCopy(editor, component);
            component.requestFocus();
            return true;
        }
        if (cmdId == 19) {
            this.performPaste(component);
            component.requestFocus();
            return true;
        }
        if (cmdId == 20) {
            this.performDelete(component);
            component.requestFocus();
            return true;
        }
        if (cmdId == 22) {
            this.performSelectAll(component);
            component.requestFocus();
            return true;
        }
        if (cmdId == EXPLAIN_PLAN_CMD_ID && editor.getDatabase() != null) {
            editor.executeExplainPlan();
            component.requestFocus();
            return true;
        }
        if (cmdId == SCRIPT_RUNNER_CMD_ID && editor.getDatabase() != null) {
            editor.executeScriptRunnerPlan();
            component.requestFocus();
            this.lastRunCmd = SCRIPT_RUNNER_CMD_ID;
            return true;
        }
        if (cmdId == EXECUTE_SQL_CMD_ID && editor.getDatabase() != null) {
            editor.executeSql();
            component.requestFocus();
            this.lastRunCmd = EXECUTE_SQL_CMD_ID;
            return true;
        }
        if (cmdId == HISTORY_CMD_ID) {
            editor.doHistoryList();
            return true;
        }
        if (cmdId == SW_SAVE_CMD_ID) {
            editor.saveWorksheet();
            return true;
        }
        if (cmdId == SW_PRINT_CMD_ID) {
            editor.printWorksheet();
            return true;
        }
        if (cmdId == SW_OPEN_CMD_ID) {
            editor.openWorksheet();
            Component componentDefault = editor.getDefaultFocusComponent();
            componentDefault.requestFocus();
            return true;
        }
        if (cmdId == CLEAR_CMD_ID) {
            editor.setText("");
            SqlEditor.updateToolbarActions((Toolbar)editor.getToolbar());
            return true;
        }
        if (cmdId == CANCEL_CMD_ID) {
            editor.cancelExecute();
            return true;
        }
        if (cmdId == 11 || cmdId == 13) {
            editor.saveWorksheet();
            return true;
        }
        if (cmdId == 12) {
            editor.saveWorksheet(true);
            return true;
        }
        if (cmdId == 74) {
            editor.setFocusOnNextTab();
            return true;
        }
        if (cmdId == 73) {
            editor.setFocusOnPreviousTab();
            return true;
        }
        if (cmdId == COMMIT_CMD_ID) {
            editor.commit();
            return true;
        }
        if (cmdId == ROLLBACK_CMD_ID) {
            editor.rollback();
            return true;
        }
        return false;
    }

    private static IdeAction createAction(String actionName, int cmd_id) {
        IdeAction action = IdeAction.get((int)cmd_id, (String)null, (String)actionName);
        action.setEnabled(true);
        action.addController((Controller)SqlEditorController.getInstance());
        action.putValue("sqlworksheet.run", (Object)actionName);
        return action;
    }

    public void menuWillShow(ContextMenu popup) {
        Context context = popup.getContext();
        View view = context.getView();
        Node doc = context.getNode();
        if (view instanceof SqlEditor && (doc instanceof SqlEditorNode || doc instanceof SqlNode)) {
            JMenuItem mItem = popup.createMenuItem((ToggleAction)SqlEditorController.createLocalAction(historyAction, view));
            popup.add((Component)mItem, JDeveloperMenuConstants.SECTION_DYNAMIC_CTXT_MENU);
            float section = JDeveloperMenuConstants.SECTION_DYNAMIC_CTXT_MENU - 0.01f;
            mItem = popup.createMenuItem((ToggleAction)SqlEditorController.createLocalAction(executeSqlAction, view));
            popup.add((Component)mItem, section);
            mItem = popup.createMenuItem((ToggleAction)SqlEditorController.createLocalAction(explainPlanAction, view));
            popup.add((Component)mItem, section);
            mItem = popup.createMenuItem((ToggleAction)SqlEditorController.createLocalAction(scriptRunnerAction, view));
            popup.add((Component)mItem, section);
            mItem = popup.createMenuItem((ToggleAction)SqlEditorController.createLocalAction(openAction, view));
            popup.add((Component)mItem, section);
            mItem = popup.createMenuItem((ToggleAction)SqlEditorController.createLocalAction(saveAction, view));
            popup.add((Component)mItem, section);
            mItem = popup.createMenuItem((ToggleAction)SqlEditorController.createLocalAction(printAction, view));
            popup.add((Component)mItem, section);
            mItem = popup.createMenuItem((ToggleAction)SqlEditorController.createLocalAction(clearAction, view));
            popup.add((Component)mItem, section);
            mItem = popup.createMenuItem((ToggleAction)SqlEditorController.createLocalAction(cancelAction, view));
            popup.add((Component)mItem, section);
            if (view instanceof SqlEditor) {
                ((SqlEditor)view).getView().getResultSetTable().getTableExporter().setTable((JTable)((SqlEditor)view).getView().getResultSetTable());
                popup.add((Component)((SqlEditor)view).getView().getResultSetTable().getTableExporter().getMenu());
            }
            popup.remove((Component)EditorConstants.NAVIGATE_ITEM);
        }
    }

    public void menuWillHide(ContextMenu popup) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    private static boolean canPerformCut(Component component) {
        if (component instanceof JTextComponent) {
            if (component instanceof BasicEditorPane) {
                return ((BasicEditorPane)component).canCut();
            }
            JTextComponent textComponent = (JTextComponent)component;
            return textComponent.isEditable() && textComponent.isEnabled() && SqlEditorController.hasSelection(textComponent);
        }
        return false;
    }

    private boolean canPerformCopy(SqlEditor editor, Component component) {
        if (component instanceof JTextComponent) {
            if (component instanceof BasicEditorPane) {
                return ((BasicEditorPane)component).canCopy();
            }
            JTextComponent textComponent = (JTextComponent)component;
            return textComponent.isEnabled() && SqlEditorController.hasSelection(textComponent);
        }
        if (component instanceof JTable) {
            CopyableResultSetTableAdapter copier = editor.getCopyableJTableAdapter();
            return copier.canCopy();
        }
        return false;
    }

    private static boolean canPerformPaste(Component component) {
        if (component instanceof JTextComponent) {
            if (component instanceof BasicEditorPane) {
                return ((BasicEditorPane)component).canPaste();
            }
            JTextComponent textComponent = (JTextComponent)component;
            return textComponent.isEnabled() && textComponent.isEditable();
        }
        return false;
    }

    private boolean canPerformDelete(Component component) {
        if (component instanceof JTextComponent) {
            JTextComponent textComponent = (JTextComponent)component;
            return textComponent.isEnabled() && textComponent.isEditable();
        }
        return false;
    }

    private static boolean canPerformSelectAll(Component component) {
        if (component instanceof JTextComponent) {
            JTextComponent textComponent = (JTextComponent)component;
            return textComponent.isEnabled();
        }
        return component instanceof JTable;
    }

    private void performCut(Component component) {
        if (component instanceof JTextComponent) {
            JTextComponent textComponent = (JTextComponent)component;
            textComponent.cut();
        }
    }

    private void performCopy(SqlEditor editor, Component component) {
        if (component instanceof JTextComponent) {
            JTextComponent textComponent = (JTextComponent)component;
            textComponent.copy();
        } else if (component instanceof JTable) {
            CopyableResultSetTableAdapter copier = editor.getCopyableJTableAdapter();
            copier.copyToClipboard();
        }
    }

    private void performPaste(Component component) {
        if (component instanceof JTextComponent) {
            JTextComponent textComponent = (JTextComponent)component;
            textComponent.paste();
        }
    }

    private void performDelete(Component component) {
        if (component instanceof JTextComponent) {
            if (component instanceof BasicEditorPane) {
                BasicEditorPane editor = (BasicEditorPane)component;
                editor.invokeAction("delete-next");
            } else {
                Action deleteAction;
                JTextComponent textComponent = (JTextComponent)component;
                String actionName = "delete-next";
                ActionMap actionMap = textComponent.getActionMap();
                if (actionMap != null && (deleteAction = actionMap.get("delete-next")) != null) {
                    ActionEvent event = new ActionEvent(textComponent, 1001, "delete-next");
                    deleteAction.actionPerformed(event);
                }
            }
        }
    }

    private void performSelectAll(Component component) {
        if (component instanceof JTextComponent) {
            JTextComponent textComponent = (JTextComponent)component;
            textComponent.selectAll();
        } else if (component instanceof JTable) {
            JTable table = (JTable)component;
            table.selectAll();
        }
    }

    private static boolean hasSelection(JTextComponent textComponent) {
        int selectEnd;
        int selectStart = textComponent.getSelectionStart();
        return selectStart != (selectEnd = textComponent.getSelectionEnd());
    }

    public JComponent[] gatherDynamicActions(Context context) {
        View view = context.getView();
        if (view instanceof SqlEditor) {
            Menubar mbr = Ide.getMenubar();
            return new JComponent[]{mbr.createMenuItem((ToggleAction)SqlEditorController.createLocalAction(executeSqlAction, view)), mbr.createMenuItem((ToggleAction)SqlEditorController.createLocalAction(scriptRunnerAction, view)), mbr.createMenuItem((ToggleAction)SqlEditorController.createLocalAction(explainPlanAction, view)), mbr.createMenuItem((ToggleAction)SqlEditorController.createLocalAction(openAction, view)), mbr.createMenuItem((ToggleAction)SqlEditorController.createLocalAction(saveAction, view)), mbr.createMenuItem((ToggleAction)SqlEditorController.createLocalAction(printAction, view)), mbr.createMenuItem((ToggleAction)SqlEditorController.createLocalAction(historyAction, view)), mbr.createMenuItem((ToggleAction)SqlEditorController.createLocalAction(clearAction, view)), mbr.createMenuItem((ToggleAction)SqlEditorController.createLocalAction(cancelAction, view))};
        }
        return EMPTY_MENUS;
    }

    private static IdeAction createLocalAction(IdeAction action, View view) {
        IdeAction local = action.newLocalAction(view);
        local.setEnabled(action.isEnabled());
        return local;
    }

    private static void toolbarAction(String connName) {
        Context ctx = Context.newIdeContext();
        ConnectionSelectorUI.SELECTOR_ACTIVE = true;
        if (connName != null) {
            ConnectionContext.setConnectionNode((Context)ctx, (ConnectionNode)CMHelper.getConnectionNode((String)connName));
        }
        WizardManager.getInstance().invokeWizard((Wizard)new SqlEditorWizard(), ctx, null, null);
        ConnectionSelectorUI.SELECTOR_ACTIVE = false;
    }

    static {
        HISTORY_CMD_ID = Ide.findOrCreateCmdID((String)"sqlworksheet.history");
        EXPLAIN_PLAN_CMD_ID = Ide.findOrCreateCmdID((String)"SQL_ExpPl_Command");
        EXECUTE_SQL_CMD_ID = Ide.findOrCreateCmdID((String)"SQL_ExecSql_Command");
        SCRIPT_RUNNER_CMD_ID = Ide.findOrCreateCmdID((String)"Script_Runner_Command");
        SW_OPEN_CMD_ID = Ide.findOrCreateCmdID((String)"SQL Worksheet Open");
        SW_SAVE_CMD_ID = Ide.findOrCreateCmdID((String)"SQL Worksheet Save");
        SW_PRINT_CMD_ID = Ide.findOrCreateCmdID((String)"SQL Worksheet Print");
        OPEN_SW_CMD_ID = Ide.findOrCreateCmdID((String)"sqlworksheet.open_new");
        CLEAR_CMD_ID = Ide.findOrCreateCmdID((String)"sqlworksheet.clear");
        CANCEL_CMD_ID = Ide.findOrCreateCmdID((String)"sqlworksheet.cancel");
        COMMIT_CMD_ID = Ide.findOrCreateCmdID((String)"sqlworksheet.commit");
        ROLLBACK_CMD_ID = Ide.findOrCreateCmdID((String)"sqlworksheet.rollback");
        _conns = new Connections();
        category = null;
        EMPTY_MENUS = new JComponent[0];
    }
}

