/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlworksheet.sqlview;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.Icon;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.sqlworksheet.sqlview.SqlEditor;
import oracle.ide.model.Attributes;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.UpdateMessage;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.javatools.db.Database;
import oracle.jdeveloper.cm.dt.ConnectionArb;
import oracle.jdeveloper.cm.dt.net.JDevCmURLFileSystemHelper;
import oracle.jdevimpl.cm.dt.sqlplus.SqlNode;

public final class SqlEditorNode
extends Node
implements List {
    private Attributes _attrs = new ElementAttributes(ElementAttributes.CLOSEABLE | ElementAttributes.SAVEABLE_AS | ElementAttributes.SAVEABLE);
    private SqlEditor se = null;
    private Database _db;
    public static final String PROTOCOL = "ide.sqlEditorNode";
    private static Map _protocols = new HashMap();
    private Connections _conns;
    private String _connName = null;
    private SqlNode _sqlNode;
    private boolean _isTemp = true;

    public SqlEditorNode(URL url, String connName) {
        super(url);
        this._connName = connName;
        this.getAttributes().set(ElementAttributes.SAVEABLE);
        this.ensureOpen();
    }

    public SqlEditorNode(String connName) {
        this(URLFactory.newURL((String)PROTOCOL, (String)(System.currentTimeMillis() + "/" + connName)), connName);
    }

    public static void registerProtocol(String protocol, Class nodeClass) {
        if (nodeClass == null || !SqlEditorNode.class.isAssignableFrom(nodeClass)) {
            throw new IllegalArgumentException("The nodeClass must be a subclass of DatabaseEditorNode");
        }
        _protocols.put(protocol, nodeClass);
        URLFileSystem.registerHelper((String)protocol, (URLFileSystemHelper)JDevCmURLFileSystemHelper.getInstance());
    }

    public static SqlEditorNode findOrCreateNode(URL url) {
        String protocol;
        Class cls;
        SqlEditorNode node = null;
        if (url != null && (cls = (Class)_protocols.get(protocol = url.getProtocol())) != null) {
            try {
                node = (SqlEditorNode)NodeFactory.findOrCreate((Class)cls, (URL)url);
            }
            catch (ClassCastException ex) {
            }
            catch (IllegalAccessException ex) {
            }
            catch (InstantiationException ex) {
                // empty catch block
            }
        }
        return node;
    }

    public String getToolTipText() {
        return this.getShortLabel();
    }

    public void updateSqlNode(SqlEditor ed) {
    }

    protected void closeImpl() throws IOException {
        this._sqlNode.close();
    }

    public boolean isDirty() {
        return this._isTemp ? false : this._sqlNode.isDirty();
    }

    public void saveImpl() throws IOException {
        if (this._sqlNode != null) {
            this._sqlNode.save();
        }
    }

    public String getShortLabel() {
        this.init();
        if (!this._isTemp && this._sqlNode != null) {
            return this._sqlNode.getShortLabel();
        }
        if (this._db != null) {
            return this._db.getConnectionName();
        }
        return super.getURL().toString().substring(super.getURL().toString().lastIndexOf("."));
    }

    public Icon getIcon() {
        return ConnectionArb.getIcon((int)18);
    }

    public URL getURL() {
        return this._isTemp ? super.getURL() : this._sqlNode.getURL();
    }

    public boolean isTempFile() {
        return this._isTemp;
    }

    public void setTempFile(boolean temp) {
        this._isTemp = temp;
    }

    public String getLongLabel() {
        if (this._isTemp) {
            return this._connName;
        }
        return this._sqlNode != null ? this._sqlNode.getLongLabel() + "@" + this._db.getConnectionName() : this.getShortLabel();
    }

    public String getToolTip() {
        return this._db != null ? this._db.getConnectionName() : this._sqlNode.getToolTipText();
    }

    public void init() {
        if (this._conns == null) {
            this._conns = new Connections();
        }
        if (!(this._connName == null || this._db != null && this._db.getConnectionName().equals(this._connName))) {
            this._db = this._conns.getDatabase(this._connName);
        }
    }

    public String getConnectionName() {
        this.init();
        return this._connName;
    }

    public Database getDatabase() {
        this.init();
        if (this.getDb() == null) {
            this.ensureOpen();
        }
        return this.getDb();
    }

    public void update() {
        this.notifyObservers(this, new UpdateMessage(UpdateMessage.OBJECT_RENAMED, (Object)this));
    }

    public Attributes getAttributes() {
        return this._attrs;
    }

    public boolean add(Object o) {
        if (o.getClass().getName().endsWith("sqlview.SqlEditor")) {
            this.se = (SqlEditor)o;
        } else {
            this.se.setText((String)o);
        }
        return true;
    }

    public Object get(int index) {
        return this.se.getText();
    }

    public void add(int index, Object element) {
    }

    public boolean addAll(Collection c) {
        return true;
    }

    public boolean addAll(int index, Collection c) {
        return true;
    }

    public void clear() {
    }

    public boolean contains(Object o) {
        return true;
    }

    public boolean containsAll(Collection c) {
        return true;
    }

    public int indexOf(Object o) {
        return 1;
    }

    public boolean isEmpty() {
        return true;
    }

    public Iterator iterator() {
        return null;
    }

    public int lastIndexOf(Object o) {
        return 0;
    }

    public ListIterator listIterator() {
        return null;
    }

    public ListIterator listIterator(int index) {
        return null;
    }

    public Object remove(int index) {
        return null;
    }

    public boolean remove(Object o) {
        return true;
    }

    public boolean removeAll(Collection c) {
        return true;
    }

    public boolean retainAll(Collection c) {
        return true;
    }

    public Object set(int index, Object element) {
        return null;
    }

    public int size() {
        return 0;
    }

    public List subList(int fromIndex, int toIndex) {
        return null;
    }

    public Object[] toArray() {
        return null;
    }

    public Object[] toArray(Object[] a) {
        return null;
    }

    public Database getDb() {
        return this._db;
    }

    public void setDb(Database db) {
        if (db != null) {
            this._db = db;
            if (this._db != null) {
                this._connName = this._db.getConnectionName();
                this.update();
            }
        }
    }

    public SqlNode getSqlNode() {
        return this._sqlNode;
    }

    public void setSqlNode(SqlNode node) {
        try {
            if (this._sqlNode != null) {
                this._sqlNode.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this._sqlNode = node;
        this.notifyObservers(this, new UpdateMessage(UpdateMessage.OBJECT_RENAMED, (Object)this));
        this.notifyObservers(this, new UpdateMessage(UpdateMessage.OBJECT_RELOADED, (Object)this));
    }
}

