/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlworksheet.sqlview;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.swing.table.DefaultTableModel;
import oracle.dbtools.raptor.utils.Translate;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.dbtools.util.Resource;
import oracle.xml.parser.v2.DOMParser;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SqlHistoryModel
extends DefaultTableModel {
    private static String[] titles = new String[]{Translate.translate((String)"Sql"), Translate.translate((String)"Connection"), Translate.translate((String)"TimeStamp")};
    private String filter = "";

    public synchronized void setModelData() {
        for (int i = 0; i < titles.length; ++i) {
            this.addColumn(titles[i]);
        }
        Node _document = null;
        File sqlHistoryFile = new File(Resource.raptorUser.getAbsolutePath() + File.separator + "SqlHistory.xml");
        try {
            DOMParser parser = new DOMParser();
            BufferedReader xml = new BufferedReader(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(sqlHistoryFile), "UTF-8")));
            parser.setPreserveWhitespace(false);
            parser.parse((Reader)xml);
            _document = parser.getDocument();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (_document != null) {
            Node _root = _document.getFirstChild();
            NodeList children = _root.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                String sql = XMLHelper.getNodeValue((Node)children.item(i), (String)"Sql");
                String conn = XMLHelper.getNodeValue((Node)children.item(i), (String)"Connection");
                String time = XMLHelper.getNodeValue((Node)children.item(i), (String)"TimeStamp");
                Object[] data = new String[]{sql, conn, time};
                this.addRow(data);
            }
        }
        this.fireTableDataChanged();
    }

    public SqlHistoryModel() {
        this.setModelData();
    }

    public int getColumnCount() {
        return titles.length;
    }

    public String getColumnName(int c) {
        return titles[c];
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex != 0;
    }

    public synchronized void setFilter(String filter) {
        if (!filter.equals("")) {
            this.filter = filter;
            this.fireTableDataChanged();
        }
    }

    public String getFilter() {
        return this.filter;
    }

    public static String[] getTitles() {
        return titles;
    }
}

