/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.assembly;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.javatools.assembly.AssemblyException;
import oracle.javatools.assembly.ObjectFactory;

public class ByteArrayFactory
extends ObjectFactory {
    public static final ByteArrayFactory BYTE_ARRAY_FACTORY = new ByteArrayFactory();
    private static final byte BYTE_ARRAY_CODE = -70;

    private ByteArrayFactory() {
    }

    public byte getObjectCode() {
        return -70;
    }

    public Object assembleImpl(DataInput dataInput) throws IOException, AssemblyException {
        int n = dataInput.readInt();
        byte[] byArray = new byte[n];
        dataInput.readFully(byArray);
        return byArray;
    }

    public void disassembleImpl(Object object, DataOutput dataOutput) throws IOException, ClassCastException, AssemblyException {
        byte[] byArray = (byte[])object;
        int n = byArray.length;
        dataOutput.writeInt(n);
        dataOutput.write(byArray);
    }
}

