/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.assembly;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.javatools.assembly.AssemblyException;
import oracle.javatools.assembly.ObjectFactory;

public class CharArrayFactory
extends ObjectFactory {
    public static final CharArrayFactory CHAR_ARRAY_FACTORY = new CharArrayFactory();
    private static final byte CHAR_ARRAY_CODE = -54;

    protected CharArrayFactory() {
    }

    public byte getObjectCode() {
        return -54;
    }

    public Object assembleImpl(DataInput dataInput) throws IOException, AssemblyException {
        int n = dataInput.readInt();
        char[] cArray = new char[n];
        int n2 = 0;
        while (n2 < n) {
            cArray[n2] = dataInput.readChar();
            ++n2;
        }
        return cArray;
    }

    public void disassembleImpl(Object object, DataOutput dataOutput) throws IOException, ClassCastException, AssemblyException {
        char[] cArray = (char[])object;
        int n = cArray.length;
        dataOutput.writeInt(n);
        int n2 = 0;
        while (n2 < n) {
            dataOutput.writeChar(cArray[n2]);
            ++n2;
        }
    }
}

