/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.assembly;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.javatools.assembly.AssemblyException;
import oracle.javatools.assembly.ObjectFactory;

public class IntArrayFactory
extends ObjectFactory {
    public static final IntArrayFactory INT_ARRAY_FACTORY = new IntArrayFactory();
    private static final byte INT_ARRAY_CODE = 26;

    private IntArrayFactory() {
    }

    public byte getObjectCode() {
        return 26;
    }

    public Object assembleImpl(DataInput dataInput) throws IOException, AssemblyException {
        int n = dataInput.readInt();
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = dataInput.readInt();
            ++n2;
        }
        return nArray;
    }

    public void disassembleImpl(Object object, DataOutput dataOutput) throws IOException, ClassCastException, AssemblyException {
        int[] nArray = (int[])object;
        int n = nArray.length;
        dataOutput.writeInt(n);
        int n2 = 0;
        while (n2 < n) {
            dataOutput.writeInt(nArray[n2]);
            ++n2;
        }
    }
}

