/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.assembly;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oracle.javatools.assembly.AssemblyException;
import oracle.javatools.assembly.AssemblyFactory;
import oracle.javatools.assembly.ObjectArrayFactory;
import oracle.javatools.assembly.ObjectFactory;

public class ListFactory
extends ObjectFactory {
    private AssemblyFactory _arrayFactory;
    private static final byte LIST_CODE = 17;

    public ListFactory(AssemblyFactory assemblyFactory) {
        this._arrayFactory = new ObjectArrayFactory(assemblyFactory);
    }

    public byte getObjectCode() {
        return 17;
    }

    public Object assembleImpl(DataInput dataInput) throws IOException, AssemblyException {
        Object[] objectArray = (Object[])this._arrayFactory.assemble(dataInput);
        return new ArrayList<Object>(Arrays.asList(objectArray));
    }

    public void disassembleImpl(Object object, DataOutput dataOutput) throws IOException, ClassCastException, AssemblyException {
        List list = (List)object;
        Object[] objectArray = list.toArray();
        this._arrayFactory.disassemble(objectArray, dataOutput);
    }
}

