/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.assembly;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import oracle.javatools.assembly.AssemblyException;
import oracle.javatools.assembly.AssemblyFactory;
import oracle.javatools.assembly.ObjectArrayFactory;
import oracle.javatools.assembly.ObjectFactory;

public class MapFactory
extends ObjectFactory {
    private AssemblyFactory _keysFactory;
    private AssemblyFactory _valuesFactory;
    private static final byte MAP_CODE = 58;

    public MapFactory(AssemblyFactory assemblyFactory, AssemblyFactory assemblyFactory2) {
        this._keysFactory = new ObjectArrayFactory(assemblyFactory);
        this._valuesFactory = new ObjectArrayFactory(assemblyFactory2);
    }

    public byte getObjectCode() {
        return 58;
    }

    public Object assembleImpl(DataInput dataInput) throws IOException, AssemblyException {
        Object[] objectArray = (Object[])this._keysFactory.assemble(dataInput);
        Object[] objectArray2 = (Object[])this._valuesFactory.assemble(dataInput);
        int n = objectArray.length;
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>(n);
        int n2 = 0;
        while (n2 < n) {
            hashMap.put(objectArray[n2], objectArray2[n2]);
            ++n2;
        }
        return hashMap;
    }

    public void disassembleImpl(Object object, DataOutput dataOutput) throws IOException, ClassCastException, AssemblyException {
        Map map = (Map)object;
        Object[] objectArray = map.keySet().toArray();
        int n = objectArray.length;
        Object[] objectArray2 = new Object[n];
        int n2 = 0;
        while (n2 < n) {
            objectArray2[n2] = map.get(objectArray[n2]);
            ++n2;
        }
        this._keysFactory.disassemble(objectArray, dataOutput);
        this._valuesFactory.disassemble(objectArray2, dataOutput);
    }
}

