/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.assembly;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.javatools.assembly.AssemblyException;
import oracle.javatools.assembly.AssemblyFactory;
import oracle.javatools.assembly.ObjectFactory;

public class ObjectArrayFactory
extends ObjectFactory {
    private AssemblyFactory _objectFactory;
    private static final byte OBJECT_ARRAY_CODE = 10;

    public ObjectArrayFactory(AssemblyFactory assemblyFactory) {
        this._objectFactory = assemblyFactory;
    }

    public byte getObjectCode() {
        return 10;
    }

    public Object assembleImpl(DataInput dataInput) throws IOException, AssemblyException {
        int n = dataInput.readInt();
        Object[] objectArray = new Object[n];
        int n2 = 0;
        while (n2 < n) {
            objectArray[n2] = this._objectFactory.assemble(dataInput);
            ++n2;
        }
        return objectArray;
    }

    public void disassembleImpl(Object object, DataOutput dataOutput) throws IOException, ClassCastException, AssemblyException {
        Object[] objectArray = (Object[])object;
        int n = objectArray.length;
        dataOutput.writeInt(n);
        int n2 = 0;
        while (n2 < n) {
            this._objectFactory.disassemble(objectArray[n2], dataOutput);
            ++n2;
        }
    }
}

