/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.assembly;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import oracle.javatools.assembly.AssemblyException;
import oracle.javatools.assembly.AssemblyFactory;

public abstract class ObjectFactory
implements AssemblyFactory {
    public static final byte OBJECT_CODE = 11;
    public static final byte DEFAULT_VERSION = 1;
    public static final byte NULL_VERSION = 0;
    private static final byte END_BARRIER = 45;

    public byte getObjectCode() {
        return 11;
    }

    public abstract Object assembleImpl(DataInput var1) throws IOException, AssemblyException;

    public abstract void disassembleImpl(Object var1, DataOutput var2) throws IOException, ClassCastException, AssemblyException;

    public byte getDisassemblyVersion() {
        return 1;
    }

    public Object versionedAssemble(DataInput dataInput, int n) throws IOException, AssemblyException {
        return this.assembleImpl(dataInput);
    }

    protected void readBarrier(DataInput dataInput, byte by) throws IOException, AssemblyException {
        byte by2 = dataInput.readByte();
        if (by2 != by) {
            throw new AssemblyException("Barrier data misread", (AssemblyFactory)this);
        }
    }

    public Object assemble(byte[] byArray) throws AssemblyException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        return this.assemble(dataInputStream);
    }

    public byte[] disassemble(Object object) throws AssemblyException, ClassCastException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        this.disassemble(object, dataOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    protected void writeBarrier(DataOutput dataOutput, byte by) throws IOException {
        dataOutput.writeByte(by);
    }

    public Object assemble(DataInput dataInput) throws AssemblyException {
        try {
            byte by = this.getObjectCode();
            this.readBarrier(dataInput, by);
            byte by2 = dataInput.readByte();
            Object object = by2 != 0 ? this.versionedAssemble(dataInput, by2) : null;
            this.readBarrier(dataInput, (byte)45);
            Object object2 = object;
            return object2;
        }
        catch (IOException iOException) {
            throw new AssemblyException(iOException, (AssemblyFactory)this);
        }
    }

    public void disassemble(Object object, DataOutput dataOutput) throws AssemblyException, ClassCastException {
        try {
            byte by = this.getObjectCode();
            this.writeBarrier(dataOutput, by);
            byte by2 = object == null ? (byte)0 : this.getDisassemblyVersion();
            dataOutput.writeByte(by2);
            if (by2 != 0) {
                this.disassembleImpl(object, dataOutput);
            }
            this.writeBarrier(dataOutput, (byte)45);
        }
        catch (IOException iOException) {
            throw new AssemblyException(iOException, (AssemblyFactory)this);
        }
    }
}

