/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.buffer;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.nio.channels.FileChannel;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import javax.swing.text.Segment;
import javax.swing.undo.UndoableEdit;
import oracle.javatools.buffer.ArrayLineMap;
import oracle.javatools.buffer.DigestHash;
import oracle.javatools.buffer.EOLNormalizer;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.LinkedOffsetMark;
import oracle.javatools.buffer.OffsetMark;
import oracle.javatools.buffer.ReadOnlyException;
import oracle.javatools.buffer.ReadWriteLock;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferListener;
import oracle.javatools.buffer.UndoableTextEdit;

abstract class AbstractTextBuffer
implements TextBuffer {
    protected static final char EOF_MARKER = '\uffff';
    protected static final char[] EMPTY_CHARS = new char[0];
    protected static String platformEOLType = "\r\n";
    private static final UndoableTextEdit START_EDIT = new UndoableTextEdit(null);
    private String bufferEOLType;
    private final ArrayList listenerList;
    private final LinkedOffsetMark marksListHead;
    protected final ReadWriteLock bufferLock;
    private boolean inChangeNotify;
    private ArrayLineMap lineMap;
    private UndoableTextEdit compoundEdit;
    private int nonModifiedChangeId;
    private int changeId;
    private boolean readOnlyMode;
    private boolean suppressUndo;
    private static final boolean DEBUG = false;
    private static int globalNextId = 1001;
    private UndoState undoState;

    static {
        String string = System.getProperty("line.separator");
        if (string != null && string.length() == 1) {
            char c = string.charAt(0);
            platformEOLType = c == '\r' ? "\r" : "\n";
        }
    }

    AbstractTextBuffer(ReadWriteLock readWriteLock) {
        readWriteLock.writeLock();
        try {
            this.bufferLock = readWriteLock;
            this.listenerList = new ArrayList();
            this.marksListHead = new LinkedOffsetMark(-1, true);
            this.marksListHead.initializeHead();
            this.bufferEOLType = platformEOLType;
            this.inChangeNotify = false;
            this.lineMap = null;
            this.compoundEdit = null;
            this.readOnlyMode = false;
            this.nextChangeId();
            this.setSuppressUndo(false);
            this.clearModified();
            this.undoState = new UndoState(this);
        }
        finally {
            readWriteLock.writeUnlock();
        }
    }

    public void setReadOnly(boolean bl) {
        this.readLock();
        try {
            this.readOnlyMode = bl;
            this.fireAttributeUpdate(2);
        }
        finally {
            this.readUnlock();
        }
    }

    public boolean isReadOnly() {
        return this.readOnlyMode;
    }

    public abstract int getLength();

    public abstract char getChar(int var1) throws IndexOutOfBoundsException;

    public char[] getChars(int n, int n2) throws IndexOutOfBoundsException {
        if (n2 < 0) {
            if (n2 == 0) {
                return EMPTY_CHARS;
            }
            throw new IndexOutOfBoundsException("negative length");
        }
        return this.getCharsImpl(n, n2);
    }

    protected abstract char[] getCharsImpl(int var1, int var2) throws IndexOutOfBoundsException;

    public String getString(int n, int n2) throws IndexOutOfBoundsException {
        if (n2 < 0) {
            if (n2 == 0) {
                return "";
            }
            throw new IndexOutOfBoundsException("negative length");
        }
        return this.getStringImpl(n, n2);
    }

    protected abstract String getStringImpl(int var1, int var2) throws IndexOutOfBoundsException;

    public void getText(int n, int n2, Segment segment) throws IndexOutOfBoundsException {
        if (n2 == 0) {
            segment.array = EMPTY_CHARS;
            segment.offset = 0;
            segment.count = 0;
        } else {
            this.getTextImpl(n, n2, segment);
        }
    }

    protected abstract void getTextImpl(int var1, int var2, Segment var3) throws IndexOutOfBoundsException;

    public UndoableEdit insert(int n, char[] cArray) throws ReadOnlyException {
        try {
            EOLNormalizer eOLNormalizer = EOLNormalizer.getNormalizer(cArray);
            char[] cArray2 = eOLNormalizer.normalizeData();
            UndoableEdit undoableEdit = this.normalizedInsert(n, cArray2);
            return undoableEdit;
        }
        catch (IOException iOException) {
            System.out.println("Unexpected IOException on char[] normalizing");
            iOException.printStackTrace();
            throw new IllegalStateException("Internal error, unexpected IOException");
        }
    }

    protected UndoableEdit normalizedInsert(int n, char[] cArray) throws ReadOnlyException {
        UndoableTextEdit undoableTextEdit = null;
        if (cArray == null || cArray.length == 0) {
            return null;
        }
        if (this.inChangeNotify) {
            throw new IllegalStateException("nested mutations not allowed");
        }
        boolean bl = this.isSuppressUndo() ^ true;
        this.writeLock();
        try {
            if (bl) {
                undoableTextEdit = new UndoableTextEdit(this.undoState);
                undoableTextEdit.recordStart();
            }
            this.insertImpl(n, cArray);
            this.nextChangeId();
            if (bl) {
                undoableTextEdit.recordEdit(n, cArray.length, cArray, true);
                undoableTextEdit.recordEnd();
                if (this.compoundEdit != null) {
                    if (this.compoundEdit == START_EDIT) {
                        this.compoundEdit = undoableTextEdit;
                    } else {
                        this.compoundEdit.addEdit(undoableTextEdit);
                    }
                    undoableTextEdit = null;
                }
            }
            this.fireInsertUpdate(n, cArray);
        }
        finally {
            this.writeUnlock();
        }
        return undoableTextEdit;
    }

    protected void applyInsert(int n, char[] cArray, int n2) throws ReadOnlyException {
        if (cArray == null || cArray.length == 0) {
            throw new IllegalStateException("empty data");
        }
        if (this.inChangeNotify) {
            throw new IllegalStateException("nested mutations not allowed");
        }
        if (this.compoundEdit != null) {
            throw new IllegalStateException("undo during edit not allowed");
        }
        this.writeLock();
        try {
            this.insertImpl(n, cArray);
            this.setChangeId(n2);
            this.fireInsertUpdate(n, cArray);
        }
        finally {
            this.writeUnlock();
        }
    }

    public UndoableEdit append(char[] cArray) throws ReadOnlyException {
        UndoableEdit undoableEdit = null;
        this.writeLock();
        try {
            int n = this.getLength();
            undoableEdit = this.insert(n, cArray);
        }
        finally {
            this.writeUnlock();
        }
        return undoableEdit;
    }

    protected void insertImpl(int n, char[] cArray) {
        this.insertImpl(n, cArray, 0, cArray.length);
    }

    protected abstract void insertImpl(int var1, char[] var2, int var3, int var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireInsertUpdate(int n, char[] cArray) {
        this.inChangeNotify = true;
        int n2 = cArray.length;
        if (this.lineMap != null) {
            this.lineMap.insertUpdate(n, n2, cArray);
        }
        int n3 = n == 0 ? 1 : n;
        LinkedOffsetMark linkedOffsetMark = this.marksListHead.nextMark();
        while (linkedOffsetMark != this.marksListHead) {
            linkedOffsetMark.insertUpdate(n3, n2);
            linkedOffsetMark = linkedOffsetMark.nextMark();
        }
        boolean bl = false;
        try {
            int n4;
            ArrayList arrayList = this.listenerList;
            synchronized (arrayList) {
                n4 = this.listenerList.size();
            }
            int n5 = 0;
            while (n5 < n4) {
                TextBufferListener textBufferListener = null;
                ArrayList arrayList2 = this.listenerList;
                synchronized (arrayList2) {
                    WeakReference weakReference = (WeakReference)this.listenerList.get(n5);
                    if (weakReference != null) {
                        textBufferListener = (TextBufferListener)weakReference.get();
                    }
                }
                if (textBufferListener == null) {
                    bl = true;
                } else {
                    try {
                        textBufferListener.insertUpdate(this, n, n2, cArray);
                    }
                    catch (RuntimeException runtimeException) {
                        System.out.println("RuntimeException occurred in notification: " + runtimeException.toString());
                        runtimeException.printStackTrace();
                    }
                }
                ++n5;
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (bl) {
            this.packListeners();
        }
        this.inChangeNotify = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void packListeners() {
        ArrayList arrayList = this.listenerList;
        synchronized (arrayList) {
            int n = this.listenerList.size();
            int n2 = n - 1;
            while (n2 >= 0) {
                WeakReference weakReference = (WeakReference)this.listenerList.get(n2);
                if (weakReference == null || weakReference.get() == null) {
                    this.listenerList.remove(n2);
                }
                --n2;
            }
        }
    }

    public UndoableEdit remove(int n, int n2) throws ReadOnlyException {
        UndoableTextEdit undoableTextEdit = null;
        if (n2 == 0) {
            return null;
        }
        if (this.inChangeNotify) {
            throw new IllegalStateException("nested mutations not allowed");
        }
        boolean bl = this.isSuppressUndo() ^ true;
        this.writeLock();
        try {
            if (bl) {
                undoableTextEdit = new UndoableTextEdit(this.undoState);
                undoableTextEdit.recordStart();
            }
            char[] cArray = this.getChars(n, n2);
            this.removeImpl(n, n2);
            this.nextChangeId();
            if (bl) {
                undoableTextEdit.recordEdit(n, n2, cArray, false);
                undoableTextEdit.recordEnd();
                if (this.compoundEdit != null) {
                    if (this.compoundEdit == START_EDIT) {
                        this.compoundEdit = undoableTextEdit;
                    } else {
                        this.compoundEdit.addEdit(undoableTextEdit);
                    }
                    undoableTextEdit = null;
                }
            }
            this.fireRemoveUpdate(n, cArray);
        }
        finally {
            this.writeUnlock();
        }
        return undoableTextEdit;
    }

    protected void applyRemove(int n, char[] cArray, int n2) throws ReadOnlyException {
        if (cArray == null || cArray.length == 0) {
            throw new IllegalStateException("empty data");
        }
        if (this.inChangeNotify) {
            throw new IllegalStateException("nested mutations not allowed");
        }
        if (this.compoundEdit != null) {
            throw new IllegalStateException("undo during edit not allowed");
        }
        this.writeLock();
        try {
            int n3 = cArray.length;
            this.removeImpl(n, n3);
            this.setChangeId(n2);
            this.fireRemoveUpdate(n, cArray);
        }
        finally {
            this.writeUnlock();
        }
    }

    public UndoableEdit removeToEnd(int n) throws ReadOnlyException {
        UndoableEdit undoableEdit = null;
        this.writeLock();
        try {
            int n2 = this.getLength() - n;
            undoableEdit = this.remove(n, n2);
        }
        finally {
            this.writeUnlock();
        }
        return undoableEdit;
    }

    protected abstract void removeImpl(int var1, int var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRemoveUpdate(int n, char[] cArray) {
        this.inChangeNotify = true;
        int n2 = cArray.length;
        if (this.lineMap != null) {
            this.lineMap.removeUpdate(n, n2, cArray);
        }
        LinkedOffsetMark linkedOffsetMark = this.marksListHead.nextMark();
        while (linkedOffsetMark != this.marksListHead) {
            linkedOffsetMark.removeUpdate(n, n2);
            linkedOffsetMark = linkedOffsetMark.nextMark();
        }
        boolean bl = false;
        try {
            int n3;
            ArrayList arrayList = this.listenerList;
            synchronized (arrayList) {
                n3 = this.listenerList.size();
            }
            int n4 = 0;
            while (n4 < n3) {
                TextBufferListener textBufferListener = null;
                ArrayList arrayList2 = this.listenerList;
                synchronized (arrayList2) {
                    WeakReference weakReference = (WeakReference)this.listenerList.get(n4);
                    if (weakReference != null) {
                        textBufferListener = (TextBufferListener)weakReference.get();
                    }
                }
                if (textBufferListener == null) {
                    bl = true;
                } else {
                    try {
                        textBufferListener.removeUpdate(this, n, n2, cArray);
                    }
                    catch (RuntimeException runtimeException) {
                        System.out.println("RuntimeException occurred in notification: " + runtimeException.toString());
                        runtimeException.printStackTrace();
                    }
                }
                ++n4;
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (bl) {
            this.packListeners();
        }
        this.inChangeNotify = false;
    }

    public LineMap getLineMap() {
        if (this.lineMap == null) {
            this.readLock();
            try {
                this.lineMap = new ArrayLineMap(this);
            }
            finally {
                this.readUnlock();
            }
        }
        return this.lineMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTextBufferListener(TextBufferListener textBufferListener) {
        WeakReference<TextBufferListener> weakReference = new WeakReference<TextBufferListener>(textBufferListener);
        ArrayList arrayList = this.listenerList;
        synchronized (arrayList) {
            int n = 0;
            while (n < this.listenerList.size()) {
                WeakReference weakReference2 = (WeakReference)this.listenerList.get(n);
                TextBufferListener textBufferListener2 = (TextBufferListener)weakReference2.get();
                if (textBufferListener2 != null) break;
                ++n;
            }
            this.listenerList.add(n, weakReference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTextBufferListener(TextBufferListener textBufferListener) {
        ArrayList arrayList = this.listenerList;
        synchronized (arrayList) {
            int n = this.listenerList.size();
            int n2 = 0;
            while (n2 < n) {
                WeakReference weakReference = (WeakReference)this.listenerList.get(n2);
                if (weakReference != null && weakReference.get() == textBufferListener) {
                    weakReference.clear();
                    break;
                }
                ++n2;
            }
        }
    }

    public void readLock() {
        this.bufferLock.readLock();
    }

    public boolean tryReadLock() {
        return this.bufferLock.tryReadLock();
    }

    public void readUnlock() {
        this.bufferLock.readUnlock();
    }

    public int getLockStatus() {
        if (this.bufferLock.isWriteLockHeld()) {
            return 2;
        }
        if (this.bufferLock.isReadLockHeld()) {
            return 1;
        }
        return 0;
    }

    public void writeLock() throws ReadOnlyException {
        this.writeLock(true);
    }

    private void writeLock(boolean bl) {
        if (bl && this.isReadOnly()) {
            throw new ReadOnlyException();
        }
        this.bufferLock.writeLock();
    }

    public boolean tryWriteLock() throws ReadOnlyException {
        if (this.isReadOnly()) {
            throw new ReadOnlyException();
        }
        return this.bufferLock.tryWriteLock();
    }

    public void writeUnlock() {
        this.bufferLock.writeUnlock();
    }

    public void beginEdit() throws ReadOnlyException {
        this.writeLock();
        if (this.compoundEdit != null) {
            this.writeUnlock();
            throw new IllegalStateException("Already in compound edit");
        }
        this.compoundEdit = START_EDIT;
    }

    public UndoableEdit endEdit() {
        if (this.compoundEdit == null) {
            throw new IllegalStateException("Not in compound edit");
        }
        UndoableTextEdit undoableTextEdit = null;
        if (this.compoundEdit != START_EDIT) {
            undoableTextEdit = this.compoundEdit;
        }
        this.compoundEdit = null;
        this.writeUnlock();
        return undoableTextEdit;
    }

    public boolean isModified() {
        boolean bl = this.nonModifiedChangeId != this.getChangeId();
        return bl;
    }

    public void clearModified() {
        this.clearModified(true);
    }

    private void clearModified(boolean bl) {
        boolean bl2 = this.isModified();
        this.nonModifiedChangeId = this.getChangeId();
        if (bl2 && bl) {
            this.readLock();
            try {
                this.fireAttributeUpdate(5);
            }
            finally {
                this.readUnlock();
            }
        }
    }

    public int getChangeId() {
        return this.changeId;
    }

    private void setChangeId(int n) {
        this.setChangeId(n, true);
    }

    private void setChangeId(int n, boolean bl) {
        boolean bl2 = this.isModified();
        this.changeId = n;
        boolean bl3 = this.isModified();
        if (bl && bl2 != bl3) {
            this.fireAttributeUpdate(5);
        }
    }

    private static synchronized int requestNextChangeId() {
        return globalNextId++;
    }

    private void nextChangeId() {
        int n = AbstractTextBuffer.requestNextChangeId();
        this.setChangeId(n);
    }

    private void setSuppressUndo(boolean bl) {
        this.suppressUndo = bl;
    }

    private boolean isSuppressUndo() {
        return this.suppressUndo;
    }

    public void read(Reader reader) throws IOException {
        EOLNormalizer eOLNormalizer = EOLNormalizer.getNormalizer(reader);
        this.read(eOLNormalizer);
    }

    public void read(FileChannel fileChannel, CharsetDecoder charsetDecoder) throws IOException {
        EOLNormalizer eOLNormalizer = EOLNormalizer.getNormalizer(fileChannel, charsetDecoder);
        this.read(eOLNormalizer);
    }

    protected void read(EOLNormalizer eOLNormalizer) throws IOException {
        this.setReadOnly(false);
        this.writeLock();
        try {
            if (this.compoundEdit != null) {
                throw new IllegalStateException("no read() during compound edit");
            }
            this.fireAttributeUpdate(3);
            try {
                this.setSuppressUndo(true);
                this.removeToEnd(0);
                char[] cArray = eOLNormalizer.normalizeData();
                this.normalizedInsert(0, cArray);
                this.setEOLType(eOLNormalizer.getEOLType());
                this.clearModified();
                this.setSuppressUndo(false);
            }
            finally {
                this.fireAttributeUpdate(4);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    public UndoableEdit insert(int n, Reader reader) throws IOException, ReadOnlyException {
        UndoableEdit undoableEdit = null;
        this.writeLock();
        try {
            EOLNormalizer eOLNormalizer = EOLNormalizer.getNormalizer(reader);
            char[] cArray = eOLNormalizer.normalizeData();
            undoableEdit = this.normalizedInsert(n, cArray);
        }
        finally {
            this.writeUnlock();
        }
        return undoableEdit;
    }

    public void write(Writer writer) throws IOException {
        this.write(writer, true);
    }

    public void write(Writer writer, boolean bl) throws IOException {
        if (!(writer instanceof BufferedWriter)) {
            writer = new BufferedWriter(writer);
        }
        this.readLock();
        try {
            int n;
            int n2;
            int n3;
            if (this.compoundEdit != null) {
                throw new IllegalStateException("no write() during compound edit");
            }
            Segment segment = new Segment();
            LineMap lineMap = this.getLineMap();
            int n4 = lineMap.getLineCount() - 1;
            int n5 = 0;
            while (n5 < n4) {
                n3 = lineMap.getLineStartOffset(n5);
                n2 = lineMap.getLineEndOffset(n5) - 1;
                n = n2 - n3;
                if (n > 0) {
                    this.getText(n3, n, segment);
                    writer.write(segment.array, segment.offset, segment.count);
                }
                writer.write(this.bufferEOLType);
                ++n5;
            }
            n3 = lineMap.getLineStartOffset(n4);
            n2 = lineMap.getLineEndOffset(n4);
            n = n2 - n3;
            if (n > 0) {
                this.getText(n3, n, segment);
                writer.write(segment.array, segment.offset, segment.count);
            }
            writer.flush();
            writer.close();
            if (bl) {
                this.clearModified();
            }
        }
        finally {
            this.readUnlock();
        }
    }

    public String getPlatformEOLType() {
        return platformEOLType;
    }

    public String getEOLType() {
        return this.bufferEOLType;
    }

    public void setEOLType(String string) throws ReadOnlyException {
        this.writeLock();
        try {
            this.bufferEOLType = string;
            this.fireAttributeUpdate(1);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireAttributeUpdate(int n) {
        try {
            int n2;
            ArrayList arrayList = this.listenerList;
            synchronized (arrayList) {
                n2 = this.listenerList.size();
            }
            int n3 = 0;
            while (n3 < n2) {
                TextBufferListener textBufferListener = null;
                ArrayList arrayList2 = this.listenerList;
                synchronized (arrayList2) {
                    WeakReference weakReference = (WeakReference)this.listenerList.get(n3);
                    if (weakReference != null) {
                        textBufferListener = (TextBufferListener)weakReference.get();
                    }
                }
                if (textBufferListener != null) {
                    try {
                        textBufferListener.attributeUpdate(this, n);
                    }
                    catch (RuntimeException runtimeException) {
                        System.out.println("RuntimeException occurred in notification: " + runtimeException.toString());
                        runtimeException.printStackTrace();
                    }
                }
                ++n3;
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public OffsetMark addOffsetMark(int n) {
        return this.addOffsetMark(n, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OffsetMark addOffsetMark(int n, boolean bl) {
        LinkedOffsetMark linkedOffsetMark = null;
        this.readLock();
        try {
            linkedOffsetMark = new LinkedOffsetMark(n, bl);
            LinkedOffsetMark linkedOffsetMark2 = this.marksListHead;
            synchronized (linkedOffsetMark2) {
                linkedOffsetMark.attachBefore(this.marksListHead);
            }
        }
        finally {
            this.readUnlock();
        }
        return linkedOffsetMark;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOffsetMark(OffsetMark offsetMark) {
        this.readLock();
        try {
            LinkedOffsetMark linkedOffsetMark = this.marksListHead;
            synchronized (linkedOffsetMark) {
                LinkedOffsetMark linkedOffsetMark2 = (LinkedOffsetMark)offsetMark;
                linkedOffsetMark2.detach();
            }
        }
        finally {
            this.readUnlock();
        }
    }

    Object detachUndoState() {
        this.writeLock(false);
        try {
            boolean bl = UndoState.mav$detachAndSaveState(this.undoState);
            UndoState undoState = bl ? this.undoState : null;
            this.undoState = new UndoState(this);
            UndoState undoState2 = undoState;
            this.writeUnlock();
            return undoState2;
        }
        catch (Throwable throwable) {
            this.writeUnlock();
            throw throwable;
        }
    }

    boolean attachUndoState(Object object) {
        if (object == null || !(object instanceof UndoState)) {
            return false;
        }
        this.writeLock(false);
        try {
            UndoState undoState = (UndoState)object;
            boolean bl = UndoState.mav$attachAndRestoreState(undoState, this);
            if (bl) {
                UndoState.mav$detachAndDiscard(this.undoState);
                this.undoState = undoState;
            }
            boolean bl2 = bl;
            this.writeUnlock();
            return bl2;
        }
        catch (Throwable throwable) {
            this.writeUnlock();
            throw throwable;
        }
    }

    static void mav$setChangeId(AbstractTextBuffer abstractTextBuffer, int n, boolean bl) {
        abstractTextBuffer.setChangeId(n, bl);
    }

    static void mav$clearModified(AbstractTextBuffer abstractTextBuffer, boolean bl) {
        abstractTextBuffer.clearModified(bl);
    }

    static final class UndoState {
        private AbstractTextBuffer _textBuffer;
        private int _changeId;
        private DigestHash _digestHash;

        UndoState(AbstractTextBuffer abstractTextBuffer) {
            this._textBuffer = abstractTextBuffer;
            this._digestHash = null;
            this._changeId = -1;
        }

        AbstractTextBuffer getTextBuffer() {
            return this._textBuffer;
        }

        private void detachAndDiscard() {
            this._textBuffer = null;
            this._digestHash = null;
        }

        private boolean detachAndSaveState() {
            if (this._textBuffer == null) {
                throw new IllegalStateException("state already detached");
            }
            this._changeId = this._textBuffer.getChangeId();
            this._digestHash = DigestHash.computeDigestHash(this._textBuffer);
            this._textBuffer = null;
            return this._digestHash != null;
        }

        private boolean attachAndRestoreState(AbstractTextBuffer abstractTextBuffer) {
            if (this._textBuffer != null) {
                throw new IllegalStateException("state already attached");
            }
            if (this._digestHash == null) {
                return false;
            }
            DigestHash digestHash = DigestHash.computeDigestHash(abstractTextBuffer);
            if (!digestHash.equals(this._digestHash)) {
                return false;
            }
            this._textBuffer = abstractTextBuffer;
            AbstractTextBuffer.mav$setChangeId(abstractTextBuffer, this._changeId, false);
            AbstractTextBuffer.mav$clearModified(abstractTextBuffer, false);
            this._digestHash = null;
            return true;
        }

        public String toString() {
            return "UndoState (buffer " + this._textBuffer + ", id " + this._changeId + ", digest " + this._digestHash + ")";
        }

        static boolean mav$attachAndRestoreState(UndoState undoState, AbstractTextBuffer abstractTextBuffer) {
            return undoState.attachAndRestoreState(abstractTextBuffer);
        }

        static void mav$detachAndDiscard(UndoState undoState) {
            undoState.detachAndDiscard();
        }

        static boolean mav$detachAndSaveState(UndoState undoState) {
            return undoState.detachAndSaveState();
        }
    }
}

