/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.buffer;

import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.TextBuffer;

final class ArrayLineMap
implements LineMap {
    private static final int INITIAL_MAP_SIZE = 16;
    private TextBuffer textBuffer;
    private int[] map;
    private int lines;
    private static final int MINIMUM_INCREMENT = 25;
    private static final int MAXIMUM_INCREMENT = 500;
    private static final float INCREMENT_RATE = 0.1f;

    ArrayLineMap(TextBuffer textBuffer) {
        this.textBuffer = textBuffer;
        this.map = new int[16];
        this.lines = 1;
        this.map[0] = 0;
        this.map[1] = 0;
        int n = textBuffer.getLength();
        if (n > 0) {
            char[] cArray = textBuffer.getChars(0, n);
            this.insertUpdate(0, n, cArray);
        }
    }

    public TextBuffer getTextBuffer() {
        return this.textBuffer;
    }

    void insertUpdate(int n, int n2, char[] cArray) {
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            if (cArray[n4] == '\n') {
                ++n3;
            }
            ++n4;
        }
        int n5 = this.getLineFromOffset(n);
        int n6 = n5 + 1;
        int[] nArray = this.map;
        int n7 = this.lines + 1 + n3;
        int n8 = this.map.length;
        if (n7 > n8) {
            int n9 = (int)((float)n7 * 0.1f);
            n9 = Math.min(500, n9);
            n9 = Math.max(25, n9);
            nArray = new int[n7 += n9];
            System.arraycopy(this.map, 0, nArray, 0, n6);
        }
        int n10 = this.lines;
        while (n10 >= n6) {
            nArray[n10 + n3] = this.map[n10] + n2;
            --n10;
        }
        if (n3 > 0) {
            int n11 = 0;
            int n12 = 0;
            while (n12 < n2) {
                if (cArray[n12] == '\n') {
                    nArray[n11 + n6] = n12 + n + 1;
                    ++n11;
                }
                ++n12;
            }
        }
        this.map = nArray;
        this.lines += n3;
    }

    void removeUpdate(int n, int n2, char[] cArray) {
        int n3;
        int n4 = this.getLineFromOffset(n);
        int n5 = this.getLineFromOffset(n + n2);
        int n6 = n5 - n4;
        int n7 = n3 = n5 + 1;
        while (n7 <= this.lines) {
            this.map[n7 - n6] = this.map[n7] - n2;
            ++n7;
        }
        this.lines -= n6;
    }

    public int getLineCount() {
        return this.lines;
    }

    public int getLineFromOffset(int n) {
        int n2 = 0;
        int n3 = this.lines;
        int n4;
        while ((n4 = n3 - n2) != 1) {
            int n5 = n3 + n2 >> 1;
            int n6 = this.map[n5];
            if (n6 > n) {
                n3 = n5;
                continue;
            }
            n2 = n5;
        }
        return n2;
    }

    public int getLineStartOffset(int n) {
        return this.map[n];
    }

    public int getLineEndOffset(int n) {
        return this.map[n + 1];
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Lines (" + this.lines + "): ");
        int n = 0;
        while (n <= this.lines) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.map[n]);
            ++n;
        }
        return stringBuffer.toString();
    }
}

