/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.buffer;

import javax.swing.text.Segment;
import oracle.javatools.buffer.AbstractTextBuffer;
import oracle.javatools.buffer.ReadWriteLock;

final class ArrayTextBuffer
extends AbstractTextBuffer {
    private static final int INITIAL_BUFFER_SIZE = 64;
    private static final int MINIMUM_INCREMENT = 16;
    private static final int MAXIMUM_INCREMENT = 512;
    private static final float INCREMENT_RATE = 0.2f;
    private static final int MAXIMUM_OVERHEAD = 2048;
    private char[] arrayBuffer = new char[64];
    private int dataSize = 0;

    ArrayTextBuffer(ReadWriteLock readWriteLock) {
        super(readWriteLock);
    }

    public int getLength() {
        return this.dataSize;
    }

    public char getChar(int n) throws IndexOutOfBoundsException {
        if (n >= this.dataSize) {
            throw new IndexOutOfBoundsException("getChar out of bounds:  dataSize: " + this.dataSize + " offset: " + n);
        }
        return this.arrayBuffer[n];
    }

    protected char[] getCharsImpl(int n, int n2) throws IndexOutOfBoundsException {
        this.checkOffsets(n, n2);
        char[] cArray = new char[n2];
        System.arraycopy(this.arrayBuffer, n, cArray, 0, n2);
        return cArray;
    }

    protected String getStringImpl(int n, int n2) throws IndexOutOfBoundsException {
        this.checkOffsets(n, n2);
        return new String(this.arrayBuffer, n, n2);
    }

    protected void getTextImpl(int n, int n2, Segment segment) throws IndexOutOfBoundsException {
        this.checkOffsets(n, n2);
        segment.array = this.arrayBuffer;
        segment.offset = n;
        segment.count = n2;
    }

    protected void insertImpl(int n, char[] cArray, int n2, int n3) {
        if (n > this.dataSize) {
            throw new IndexOutOfBoundsException("insertImpl out ofbounds:  dataSize: " + this.dataSize + " offset: " + n);
        }
        int n4 = this.arrayBuffer.length;
        int n5 = n3;
        char[] cArray2 = this.arrayBuffer;
        if (this.dataSize + n5 > n4) {
            int n6 = this.dataSize + n5;
            int n7 = (int)((float)n6 * 0.2f);
            n7 = Math.min(512, n7);
            n7 = Math.max(16, n7);
            cArray2 = new char[n6 += n7];
            System.arraycopy(this.arrayBuffer, 0, cArray2, 0, n);
        }
        System.arraycopy(this.arrayBuffer, n, cArray2, n + n5, this.dataSize - n);
        System.arraycopy(cArray, n2, cArray2, n, n5);
        this.arrayBuffer = cArray2;
        this.dataSize += n5;
    }

    protected void removeImpl(int n, int n2) {
        this.checkOffsets(n, n2);
        int n3 = this.arrayBuffer.length;
        int n4 = this.dataSize - n2;
        char[] cArray = this.arrayBuffer;
        if (n3 - n4 > 2048) {
            int n5 = n4;
            int n6 = (int)((float)n5 * 0.2f);
            n6 = Math.min(512, n6);
            n6 = Math.max(16, n6);
            cArray = new char[n5 += n6];
            System.arraycopy(this.arrayBuffer, 0, cArray, 0, n);
        }
        System.arraycopy(this.arrayBuffer, n + n2, cArray, n, this.dataSize - (n + n2));
        this.arrayBuffer = cArray;
        this.dataSize -= n2;
    }

    private void checkOffsets(int n, int n2) {
        if (n < 0 || n2 < 0 || n + n2 > this.dataSize) {
            throw new IndexOutOfBoundsException("out of bounds: dataSize: " + this.dataSize + " offset: " + n + " length: " + n2);
        }
    }
}

