/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.buffer;

import java.text.CharacterIterator;
import oracle.javatools.buffer.ReadTextBuffer;

final class CharacterIteratorWrapper
implements CharacterIterator {
    private ReadTextBuffer textBuffer;
    private int bufferLength;
    private int readOffset;

    CharacterIteratorWrapper(ReadTextBuffer readTextBuffer) {
        this.textBuffer = readTextBuffer;
        this.bufferLength = readTextBuffer.getLength();
        this.readOffset = 0;
    }

    public char first() {
        this.readOffset = 0;
        return this.current();
    }

    public char last() {
        this.readOffset = Math.max(0, this.bufferLength - 1);
        return this.current();
    }

    public char current() {
        if (this.readOffset >= 0 && this.readOffset < this.bufferLength) {
            return this.textBuffer.getChar(this.readOffset);
        }
        return '\uffff';
    }

    public char next() {
        this.readOffset = Math.min(this.bufferLength, this.readOffset + 1);
        return this.current();
    }

    public char previous() {
        if (this.readOffset > 0) {
            --this.readOffset;
            return this.current();
        }
        return '\uffff';
    }

    public char setIndex(int n) {
        if (n < 0 || n > this.bufferLength) {
            throw new IllegalArgumentException("invalid index: " + n);
        }
        this.readOffset = n;
        return this.current();
    }

    public int getBeginIndex() {
        return 0;
    }

    public int getEndIndex() {
        return this.bufferLength;
    }

    public int getIndex() {
        return this.readOffset;
    }

    public Object clone() {
        CharacterIteratorWrapper characterIteratorWrapper = new CharacterIteratorWrapper(this.textBuffer);
        characterIteratorWrapper.readOffset = this.readOffset;
        return characterIteratorWrapper;
    }
}

