/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.buffer;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.swing.text.Segment;
import oracle.javatools.buffer.TextBuffer;

final class DigestHash {
    private byte[] _digestHash;
    private int _hashCode;

    private DigestHash(byte[] byArray) {
        this._digestHash = byArray;
        this._hashCode = -1;
    }

    public static DigestHash computeDigestHash(TextBuffer textBuffer) {
        textBuffer.readLock();
        try {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                if (messageDigest != null) {
                    int n = 128;
                    int n2 = 256;
                    byte[] byArray = new byte[256];
                    Segment segment = new Segment();
                    int n3 = textBuffer.getLength();
                    int n4 = 0;
                    while (n3 > 0) {
                        int n5 = Math.min(128, n3);
                        textBuffer.getText(n4, n5, segment);
                        int n6 = segment.count;
                        int n7 = segment.offset;
                        int n8 = n7 + n6;
                        char[] cArray = segment.array;
                        int n9 = 0;
                        int n10 = n7;
                        while (n10 < n8) {
                            char c = cArray[n10];
                            byArray[n9++] = (byte)(c & 0xFF);
                            byArray[n9++] = (byte)(c >>> 8 & 0xFF);
                            ++n10;
                        }
                        messageDigest.update(byArray, 0, n9);
                        n3 -= n5;
                        n4 += n5;
                    }
                    DigestHash digestHash = new DigestHash(messageDigest.digest());
                    textBuffer.readUnlock();
                    return digestHash;
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                System.out.println("  Warning: MD5 digest unavailable: " + noSuchAlgorithmException.getMessage());
            }
        }
        finally {
            textBuffer.readUnlock();
        }
        return null;
    }

    public int hashCode() {
        if (this._hashCode == -1) {
            int n = 0;
            int n2 = this._digestHash.length;
            int n3 = 0;
            while (n3 < n2) {
                n = n * 19 + this._digestHash[n3];
                ++n3;
            }
            this._hashCode = n;
        }
        return this._hashCode;
    }

    public boolean equals(Object object) {
        if (object instanceof DigestHash) {
            return DigestHash.equals(this._digestHash, ((DigestHash)object)._digestHash);
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this._digestHash.length;
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(Character.forDigit(this._digestHash[n2] >> 4 & 0xF, 16));
            stringBuffer.append(Character.forDigit(this._digestHash[n2] >> 0 & 0xF, 16));
            stringBuffer.append(' ');
            ++n2;
        }
        return stringBuffer.toString();
    }

    private static boolean equals(byte[] byArray, byte[] byArray2) {
        int n = byArray.length;
        int n2 = byArray2.length;
        if (n != n2) {
            return false;
        }
        int n3 = 0;
        while (n3 < n) {
            if (byArray[n3] != byArray2[n3]) {
                return false;
            }
            ++n3;
        }
        return true;
    }
}

