/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.buffer;

import java.io.IOException;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.CharsetDecoder;
import oracle.javatools.buffer.AbstractTextBuffer;
import oracle.javatools.buffer.VectorBuffers;

abstract class EOLNormalizer {
    private int _countCR;
    private int _countLF;
    private int _countCRLF;
    protected VectorBuffers _buffers;
    private boolean _pushedCR;
    private String _eolType;
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    public String getEOLType() {
        return this._eolType;
    }

    protected void setEOLType(String string) {
        this._eolType = string;
    }

    protected char[] copyData(char[] cArray) {
        char[] cArray2 = new char[cArray.length];
        System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
        return cArray2;
    }

    protected void processStart() {
        this._countCRLF = 0;
        this._countLF = 0;
        this._countCR = 0;
        this._pushedCR = false;
    }

    protected void process(char[] cArray, int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            int n4 = cArray[n3++];
            if (this._pushedCR) {
                this._pushedCR = false;
                if (n4 == 10) {
                    ++this._countCRLF;
                    continue;
                }
                ++this._countCR;
            }
            if (n4 == 13) {
                this._pushedCR = true;
                n4 = 10;
            } else if (n4 == 10) {
                ++this._countLF;
            }
            cArray[n2++] = n4;
        }
        this._buffers.addBuffer(cArray, n2);
    }

    protected char[] processFinish() {
        if (this._pushedCR) {
            ++this._countCR;
        }
        int n = this._countCRLF;
        String string = "\r\n";
        if (this._countLF > n) {
            n = this._countLF;
            string = "\n";
        }
        if (this._countCR > n) {
            n = this._countCR;
            string = "\r";
        }
        if (n > 0) {
            this.setEOLType(string);
        }
        return this._buffers.getAllBuffers();
    }

    void $init$() {
        this._countCR = 0;
        this._countLF = 0;
        this._countCRLF = 0;
        this._buffers = new VectorBuffers();
        this._pushedCR = false;
        this._eolType = AbstractTextBuffer.platformEOLType;
    }

    public abstract char[] normalizeData() throws IOException;

    static EOLNormalizer getNormalizer(char[] cArray) {
        return new ArrayNormalizer(cArray, null);
    }

    static EOLNormalizer getNormalizer(Reader reader) {
        return new ReaderNormalizer(reader, null);
    }

    static EOLNormalizer getNormalizer(FileChannel fileChannel, CharsetDecoder charsetDecoder) {
        return new ChannelNormalizer(fileChannel, charsetDecoder, null);
    }

    EOLNormalizer() {
        this.$init$();
    }

    private static class ArrayNormalizer
    extends EOLNormalizer {
        private char[] _data;

        private ArrayNormalizer(char[] cArray) {
            this._data = cArray;
        }

        public char[] normalizeData() {
            if (this._data == null) {
                return AbstractTextBuffer.EMPTY_CHARS;
            }
            char[] cArray = this.copyData(this._data);
            this.processStart();
            this.process(cArray, cArray.length);
            char[] cArray2 = this.processFinish();
            return cArray2;
        }

        ArrayNormalizer(char[] cArray, 1 var2_2) {
            this(cArray);
        }

        public final class 1 {
        }
    }

    private static class ReaderNormalizer
    extends EOLNormalizer {
        private Reader _reader;

        private ReaderNormalizer(Reader reader) {
            this._reader = reader;
        }

        public char[] normalizeData() throws IOException {
            char[] cArray;
            int n;
            if (this._reader == null) {
                return AbstractTextBuffer.EMPTY_CHARS;
            }
            this.processStart();
            while ((n = this._reader.read(cArray = new char[4096])) != -1) {
                this.process(cArray, n);
            }
            this._reader.close();
            char[] cArray2 = this.processFinish();
            return cArray2;
        }

        ReaderNormalizer(Reader reader, 1 var2_2) {
            this(reader);
        }

        public final class 1 {
        }
    }

    private static class ChannelNormalizer
    extends EOLNormalizer {
        private FileChannel _channel;
        private CharsetDecoder _decoder;

        private ChannelNormalizer(FileChannel fileChannel, CharsetDecoder charsetDecoder) {
            this._channel = fileChannel;
            this._decoder = charsetDecoder;
        }

        public char[] normalizeData() throws IOException {
            if (this._channel == null) {
                return AbstractTextBuffer.EMPTY_CHARS;
            }
            if (this._decoder == null) {
                throw new IOException("no charset converter");
            }
            byte[] byArray = new byte[4096];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            this.processStart();
            while (true) {
                char[] cArray = new char[4096];
                CharBuffer charBuffer = CharBuffer.wrap(cArray);
                byteBuffer.clear();
                int n = this._channel.read(byteBuffer);
                if (n == -1) break;
                byteBuffer.flip();
                charBuffer.clear();
                this._decoder.decode(byteBuffer, charBuffer, false);
                charBuffer.flip();
                this.process(cArray, charBuffer.remaining());
            }
            this._channel.close();
            char[] cArray = this.processFinish();
            return cArray;
        }

        ChannelNormalizer(FileChannel fileChannel, CharsetDecoder charsetDecoder, 1 var3_3) {
            this(fileChannel, charsetDecoder);
        }

        public final class 1 {
        }
    }
}

