/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.buffer;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import javax.swing.text.Segment;
import javax.swing.undo.UndoableEdit;
import oracle.javatools.buffer.ExpiredTextBufferException;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.OffsetMark;
import oracle.javatools.buffer.ReadOnlyException;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferListener;

final class ExpirableTextBufferSnapshot
implements TextBuffer {
    private TextBuffer _textBuffer;
    private int _snapshotId;
    private boolean _expired;
    private TextBufferListener _listener;

    ExpirableTextBufferSnapshot(TextBuffer textBuffer) {
        this.$init$();
        this._textBuffer = textBuffer;
        this._textBuffer.readLock();
        try {
            this._snapshotId = textBuffer.getChangeId();
            this.attachListener();
        }
        finally {
            this._textBuffer.readUnlock();
        }
    }

    void $init$() {
        this._expired = false;
        this._listener = null;
    }

    private void bailIfExpired() {
        if (this.isExpired()) {
            throw new ExpiredTextBufferException();
        }
    }

    private boolean isExpired() {
        return this._expired;
    }

    private void attachListener() {
        this._listener = new 1();
        this._textBuffer.addTextBufferListener(this._listener);
    }

    private void expireSnapshot() {
        if (this._listener != null) {
            this._textBuffer.removeTextBufferListener(this._listener);
            this._listener = null;
        }
        this._expired = true;
    }

    public int getLength() {
        this.bailIfExpired();
        return this._textBuffer.getLength();
    }

    public char getChar(int n) throws IndexOutOfBoundsException {
        this.bailIfExpired();
        return this._textBuffer.getChar(n);
    }

    public char[] getChars(int n, int n2) throws IndexOutOfBoundsException {
        this.bailIfExpired();
        char[] cArray = this._textBuffer.getChars(n, n2);
        this.bailIfExpired();
        return cArray;
    }

    public String getString(int n, int n2) throws IndexOutOfBoundsException {
        this.bailIfExpired();
        String string = this._textBuffer.getString(n, n2);
        this.bailIfExpired();
        return string;
    }

    public void getText(int n, int n2, Segment segment) throws IndexOutOfBoundsException {
        this.bailIfExpired();
        this._textBuffer.getText(n, n2, segment);
        this.bailIfExpired();
    }

    public void readLock() {
        this.bailIfExpired();
        this._textBuffer.readLock();
        if (this.isExpired()) {
            this._textBuffer.readUnlock();
            this.bailIfExpired();
        }
    }

    public boolean tryReadLock() {
        this.bailIfExpired();
        boolean bl = this._textBuffer.tryReadLock();
        if (this.isExpired()) {
            if (bl) {
                this._textBuffer.readUnlock();
            }
            this.bailIfExpired();
        }
        return bl;
    }

    public void readUnlock() {
        this._textBuffer.readUnlock();
    }

    public int getLockStatus() {
        return this._textBuffer.getLockStatus();
    }

    public void beginEdit() throws ReadOnlyException {
        throw new UnsupportedOperationException();
    }

    public UndoableEdit endEdit() {
        throw new UnsupportedOperationException();
    }

    public UndoableEdit insert(int n, char[] cArray) throws ReadOnlyException {
        throw new UnsupportedOperationException();
    }

    public UndoableEdit append(char[] cArray) throws ReadOnlyException {
        throw new UnsupportedOperationException();
    }

    public UndoableEdit remove(int n, int n2) throws ReadOnlyException {
        throw new UnsupportedOperationException();
    }

    public UndoableEdit removeToEnd(int n) throws ReadOnlyException {
        throw new UnsupportedOperationException();
    }

    public LineMap getLineMap() {
        this.bailIfExpired();
        return this._textBuffer.getLineMap();
    }

    public void addTextBufferListener(TextBufferListener textBufferListener) {
        throw new UnsupportedOperationException();
    }

    public void removeTextBufferListener(TextBufferListener textBufferListener) {
        throw new UnsupportedOperationException();
    }

    public void setReadOnly(boolean bl) {
        throw new UnsupportedOperationException();
    }

    public boolean isReadOnly() {
        return true;
    }

    public void writeLock() throws ReadOnlyException {
        throw new UnsupportedOperationException();
    }

    public boolean tryWriteLock() throws ReadOnlyException {
        throw new UnsupportedOperationException();
    }

    public void writeUnlock() {
        throw new UnsupportedOperationException();
    }

    public OffsetMark addOffsetMark(int n) {
        throw new UnsupportedOperationException();
    }

    public OffsetMark addOffsetMark(int n, boolean bl) {
        throw new UnsupportedOperationException();
    }

    public void removeOffsetMark(OffsetMark offsetMark) {
        throw new UnsupportedOperationException();
    }

    public boolean isModified() {
        this.bailIfExpired();
        return this._textBuffer.isModified();
    }

    public void clearModified() {
        throw new UnsupportedOperationException();
    }

    public int getChangeId() {
        return this._snapshotId;
    }

    public void read(Reader reader) throws IOException {
        throw new UnsupportedOperationException();
    }

    public UndoableEdit insert(int n, Reader reader) throws ReadOnlyException {
        throw new UnsupportedOperationException();
    }

    public void write(Writer writer) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void write(Writer writer, boolean bl) throws IOException {
        throw new UnsupportedOperationException();
    }

    public String getPlatformEOLType() {
        this.bailIfExpired();
        return this._textBuffer.getPlatformEOLType();
    }

    public String getEOLType() {
        this.bailIfExpired();
        return this._textBuffer.getEOLType();
    }

    public void setEOLType(String string) throws ReadOnlyException {
        throw new UnsupportedOperationException();
    }

    static void mav$expireSnapshot(ExpirableTextBufferSnapshot expirableTextBufferSnapshot) {
        expirableTextBufferSnapshot.expireSnapshot();
    }

    final class 1
    implements TextBufferListener {
        public void insertUpdate(TextBuffer textBuffer, int n, int n2, char[] cArray) {
            ExpirableTextBufferSnapshot.mav$expireSnapshot(ExpirableTextBufferSnapshot.this);
        }

        public void removeUpdate(TextBuffer textBuffer, int n, int n2, char[] cArray) {
            ExpirableTextBufferSnapshot.mav$expireSnapshot(ExpirableTextBufferSnapshot.this);
        }

        public void attributeUpdate(TextBuffer textBuffer, int n) {
        }
    }
}

