/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.buffer;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferListener;
import oracle.javatools.util.CopyOnWriteList;

public class ForwardingTextBufferListener
implements TextBufferListener {
    private TextBuffer buffer;
    private CopyOnWriteList listeners;

    void $init$() {
        this.listeners = new CopyOnWriteList();
    }

    public ForwardingTextBufferListener(TextBuffer textBuffer) {
        this.$init$();
        this.buffer = textBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTextBufferListener(TextBufferListener textBufferListener) {
        CopyOnWriteList copyOnWriteList = this.listeners;
        synchronized (copyOnWriteList) {
            Object[] objectArray = this.listeners.getItems();
            int n = objectArray.length;
            while (n-- > 0) {
                WeakReference weakReference = (WeakReference)objectArray[n];
                if (textBufferListener != weakReference.get()) continue;
                return;
            }
            this.listeners.add(new WeakReference<TextBufferListener>(textBufferListener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTextBufferListener(TextBufferListener textBufferListener) {
        CopyOnWriteList copyOnWriteList = this.listeners;
        synchronized (copyOnWriteList) {
            Object[] objectArray = this.listeners.getItems();
            int n = objectArray.length;
            while (n-- > 0) {
                WeakReference weakReference = (WeakReference)objectArray[n];
                if (textBufferListener != weakReference.get()) continue;
                this.listeners.remove(n);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pack() {
        CopyOnWriteList copyOnWriteList = this.listeners;
        synchronized (copyOnWriteList) {
            Object[] objectArray = this.listeners.getItems();
            int n = objectArray.length;
            while (n-- > 0) {
                WeakReference weakReference = (WeakReference)objectArray[n];
                if (weakReference.get() != null) continue;
                this.listeners.remove(n);
            }
        }
    }

    public void attributeUpdate(TextBuffer textBuffer, int n) {
        boolean bl = false;
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            WeakReference weakReference = (WeakReference)iterator.next();
            TextBufferListener textBufferListener = (TextBufferListener)weakReference.get();
            if (textBufferListener != null) {
                textBufferListener.attributeUpdate(this.buffer, n);
                continue;
            }
            bl = true;
        }
        if (bl) {
            this.pack();
        }
    }

    public void insertUpdate(TextBuffer textBuffer, int n, int n2, char[] cArray) {
        boolean bl = false;
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            WeakReference weakReference = (WeakReference)iterator.next();
            TextBufferListener textBufferListener = (TextBufferListener)weakReference.get();
            if (textBufferListener != null) {
                textBufferListener.insertUpdate(this.buffer, n, n2, cArray);
                continue;
            }
            bl = true;
        }
        if (bl) {
            this.pack();
        }
    }

    public void removeUpdate(TextBuffer textBuffer, int n, int n2, char[] cArray) {
        boolean bl = false;
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            WeakReference weakReference = (WeakReference)iterator.next();
            TextBufferListener textBufferListener = (TextBufferListener)weakReference.get();
            if (textBufferListener != null) {
                textBufferListener.removeUpdate(this.buffer, n, n2, cArray);
                continue;
            }
            bl = true;
        }
        if (bl) {
            this.pack();
        }
    }
}

