/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.buffer;

import javax.swing.text.Segment;
import oracle.javatools.buffer.AbstractTextBuffer;
import oracle.javatools.buffer.ReadWriteLock;

class GapArrayTextBuffer
extends AbstractTextBuffer {
    private static final float DEFAULT_GAP_SIZE = 0.2f;
    private static final int MINIMUM_GAP_SIZE = 64;
    private static final int MAXIMUM_GAP_SIZE = 512;
    private static final int MAXIMUM_OVERHEAD = 2048;
    private char[] gapBuffer = new char[this.gapSize];
    private int dataSize = 0;
    private int gapOffset = 0;
    private int gapSize = 64;

    GapArrayTextBuffer(ReadWriteLock readWriteLock) {
        super(readWriteLock);
    }

    private int calculateGapSize(int n) {
        int n2 = (int)((float)n * 0.2f);
        n2 = Math.min(n2, 512);
        n2 = Math.max(n2, 64);
        return n2;
    }

    public int getLength() {
        return this.dataSize;
    }

    public char getChar(int n) throws IndexOutOfBoundsException {
        return n < this.gapOffset ? this.gapBuffer[n] : this.gapBuffer[n + this.gapSize];
    }

    public char[] getCharsImpl(int n, int n2) throws IndexOutOfBoundsException {
        this.checkOffsets(n, n2);
        char[] cArray = new char[n2];
        int n3 = n;
        int n4 = n + n2;
        if (n4 <= this.gapOffset) {
            System.arraycopy(this.gapBuffer, n3, cArray, 0, n2);
        } else if (this.gapOffset <= n3) {
            System.arraycopy(this.gapBuffer, n3 + this.gapSize, cArray, 0, n2);
        } else {
            int n5 = this.gapOffset - n3;
            int n6 = n4 - this.gapOffset;
            System.arraycopy(this.gapBuffer, n3, cArray, 0, n5);
            System.arraycopy(this.gapBuffer, this.gapOffset + this.gapSize, cArray, n5, n6);
        }
        return cArray;
    }

    protected String getStringImpl(int n, int n2) throws IndexOutOfBoundsException {
        this.checkOffsets(n, n2);
        int n3 = n;
        int n4 = n + n2;
        if (n4 <= this.gapOffset) {
            return new String(this.gapBuffer, n3, n2);
        }
        if (this.gapOffset <= n3) {
            return new String(this.gapBuffer, n3 + this.gapSize, n2);
        }
        char[] cArray = this.getCharsImpl(n, n2);
        return new String(cArray);
    }

    public void getTextImpl(int n, int n2, Segment segment) throws IndexOutOfBoundsException {
        int n3 = n;
        int n4 = n + n2;
        if (n4 <= this.gapOffset) {
            segment.array = this.gapBuffer;
            segment.offset = n;
            segment.count = n2;
        } else if (this.gapOffset <= n3) {
            segment.array = this.gapBuffer;
            segment.offset = n + this.gapSize;
            segment.count = n2;
        } else {
            char[] cArray = this.getChars(n, n2);
            segment.array = cArray;
            segment.offset = 0;
            segment.count = n2;
        }
    }

    protected void insertImpl(int n, char[] cArray, int n2, int n3) {
        if (n > this.dataSize) {
            throw new IndexOutOfBoundsException("insertImpl out ofbounds:  dataSize: " + this.dataSize + " offset: " + n);
        }
        int n4 = this.dataSize + this.gapSize;
        int n5 = n3;
        int n6 = n5 + this.dataSize;
        char[] cArray2 = this.gapBuffer;
        int n7 = n4;
        int n8 = this.gapSize;
        int n9 = this.gapOffset;
        int n10 = n;
        int n11 = Math.min(n9, n10);
        int n12 = Math.max(n9, n10);
        if (n5 > this.gapSize) {
            n8 = this.calculateGapSize(n6) + n5;
            n7 = n8 + this.dataSize;
            cArray2 = new char[n7];
            System.arraycopy(this.gapBuffer, 0, cArray2, 0, n11);
            System.arraycopy(this.gapBuffer, n12 + this.gapSize, cArray2, n12 + n8, this.dataSize - n12);
        }
        if (n9 != n10) {
            int n13 = n12 - n11;
            if (n9 < n10) {
                System.arraycopy(this.gapBuffer, n11 + this.gapSize, cArray2, n11, n13);
            } else {
                System.arraycopy(this.gapBuffer, n11, cArray2, n11 + n8, n13);
            }
            this.gapOffset = n;
        }
        System.arraycopy(cArray, n2, cArray2, this.gapOffset, n5);
        this.gapOffset += n5;
        this.gapSize = n8 - n5;
        this.gapBuffer = cArray2;
        this.dataSize = n6;
    }

    protected void removeImpl(int n, int n2) {
        this.checkOffsets(n, 1);
        int n3 = this.dataSize + this.gapSize;
        int n4 = n2;
        int n5 = this.gapOffset;
        int n6 = this.gapSize;
        int n7 = n;
        int n8 = n + n4;
        if (n8 < n5) {
            System.arraycopy(this.gapBuffer, n8, this.gapBuffer, n8 + n6, n5 - n8);
        } else if (n5 < n7) {
            System.arraycopy(this.gapBuffer, n5 + n6, this.gapBuffer, n5, n7 - n5);
        }
        this.gapOffset = n7;
        this.gapSize += n4;
        this.dataSize -= n4;
        if (this.gapSize > 2048) {
            int n9 = this.calculateGapSize(this.dataSize);
            int n10 = this.dataSize + n9;
            char[] cArray = new char[n10];
            System.arraycopy(this.gapBuffer, 0, cArray, 0, this.gapOffset);
            System.arraycopy(this.gapBuffer, this.gapOffset + this.gapSize, cArray, this.gapOffset + n9, this.dataSize - this.gapOffset);
            this.gapSize = n9;
            this.gapBuffer = cArray;
        }
    }

    private void checkOffsets(int n, int n2) {
        if (n < 0 || n2 < 0 || n + n2 > this.getLength()) {
            throw new IndexOutOfBoundsException("out of bounds: dataSize: " + this.getLength() + " offset: " + n + " length: " + n2);
        }
    }
}

