/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.buffer;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public final class ReadWriteLock {
    public static final int NONE = 0;
    public static final int FREE = 0;
    public static final int READ = 1;
    public static final int SHARED = 1;
    public static final int WRITE = 2;
    public static final int EXCLUSIVE = 2;
    private static final int BUSY = -1;
    private static final int NOT_FOUND = -1;
    private static final int WAIT_TIMEOUT = 5000;
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_CONTENTION = false;
    private static final boolean DEBUG_DEADLOCK;
    private static final PrintStream DEBUG_STREAM;
    private static final int DEADLOCK_TIMEOUT = 20000;
    private Object[] readHolderList = null;
    private int[] readCountList = null;
    private Object[] readTraceList;
    private int numReaders = 0;
    private Object writeHolder = null;
    private int writeCount = 0;
    private Object[] writeTrace;
    private int lockStatus = 0;

    static {
        String string = System.getProperty("buffer.deadlock.detection");
        DEBUG_DEADLOCK = "true".equalsIgnoreCase(string);
        PrintStream printStream = null;
        string = System.getProperty("buffer.debug.file");
        if (string != null) {
            try {
                printStream = new PrintStream(new FileOutputStream(string), true);
            }
            catch (IOException iOException) {
                System.err.println("ReadWriteLock: error opening debug file, using System.err");
                printStream = null;
            }
        }
        PrintStream printStream2 = DEBUG_STREAM = printStream != null ? printStream : System.err;
        if (DEBUG_DEADLOCK) {
            ReadWriteLock.debugPrint("TextBuffer deadlock detection enabled");
        }
    }

    public ReadWriteLock() {
        this.expandReadList();
    }

    public boolean tryReadLock() {
        return this.readLock(false);
    }

    public void readLock() {
        this.readLock(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readLock(boolean bl) {
        long l = 0L;
        if (DEBUG_DEADLOCK) {
            l = System.currentTimeMillis();
        }
        Thread thread = Thread.currentThread();
        ReadWriteLock readWriteLock = this;
        synchronized (readWriteLock) {
            boolean bl2 = false;
            while (!bl2) {
                long l2;
                long l3;
                if (DEBUG_DEADLOCK && (l3 = (l2 = System.currentTimeMillis()) - l) > 20000L) {
                    this.dumpDeadlockTrace();
                    l = l2;
                }
                int n = -1;
                switch (this.lockStatus) {
                    case 0: {
                        n = 0;
                        this.lockStatus = 1;
                        break;
                    }
                    case 1: {
                        int n2 = this.readHolderList.length;
                        int n3 = 0;
                        while (n3 < n2) {
                            if (this.readHolderList[n3] == null || this.readHolderList[n3] == thread) {
                                n = n3;
                                break;
                            }
                            ++n3;
                        }
                        if (n != -1) break;
                        this.expandReadList();
                        n = n2;
                        break;
                    }
                    case 2: {
                        if (this.writeHolder != thread) break;
                        n = 0;
                    }
                }
                if (n != -1) {
                    this.readHolderList[n] = thread;
                    int n4 = n;
                    int n5 = this.readCountList[n4] + 1;
                    this.readCountList[n4] = n5;
                    int n6 = n5;
                    bl2 = true;
                    ++this.numReaders;
                    if (!DEBUG_DEADLOCK) continue;
                    Object[] objectArray = (Object[])this.readTraceList[n];
                    if (objectArray == null) {
                        objectArray = new Object[10];
                        this.readTraceList[n] = objectArray;
                    }
                    if (objectArray.length < n6) {
                        Object[] objectArray2 = new Object[n6 + 10];
                        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
                        objectArray = objectArray2;
                        this.readTraceList[n] = objectArray2;
                    }
                    objectArray[n6 - 1] = new Exception("ReadLock Acquired");
                    continue;
                }
                try {
                    if (bl) {
                        this.wait(5000L);
                        continue;
                    }
                    boolean bl3 = false;
                    return bl3;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readUnlock() {
        Thread thread = Thread.currentThread();
        ReadWriteLock readWriteLock = this;
        synchronized (readWriteLock) {
            int n = -1;
            int n2 = this.readHolderList.length;
            int n3 = 0;
            while (n3 < n2) {
                if (this.readHolderList[n3] == thread) {
                    n = n3;
                    break;
                }
                ++n3;
            }
            if (n == -1) {
                throw new IllegalStateException("readUnlock() - lock not held");
            }
            int n4 = n;
            this.readCountList[n4] = this.readCountList[n4] - 1;
            int n5 = this.readCountList[n4];
            if (n5 == 0) {
                this.readHolderList[n] = null;
                if (DEBUG_DEADLOCK) {
                    this.readTraceList[n] = null;
                }
            }
            --this.numReaders;
            if (this.numReaders == 0 && this.writeHolder == null) {
                this.lockStatus = 0;
            }
            this.notify();
        }
    }

    public boolean tryWriteLock() {
        return this.writeLock(false);
    }

    public void writeLock() {
        this.writeLock(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeLock(boolean bl) {
        long l = 0L;
        if (DEBUG_DEADLOCK) {
            l = System.currentTimeMillis();
        }
        Thread thread = Thread.currentThread();
        ReadWriteLock readWriteLock = this;
        synchronized (readWriteLock) {
            boolean bl2 = false;
            while (!bl2) {
                long l2;
                long l3;
                if (DEBUG_DEADLOCK && (l3 = (l2 = System.currentTimeMillis()) - l) > 20000L) {
                    this.dumpDeadlockTrace();
                    l = l2;
                }
                boolean bl3 = true;
                block3 : switch (this.lockStatus) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        int n = this.readHolderList.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Thread thread2 = (Thread)this.readHolderList[n2];
                            if (thread2 != null && thread2 != thread) {
                                bl3 = false;
                                break block3;
                            }
                            ++n2;
                        }
                        break;
                    }
                    case 2: {
                        if (this.writeHolder == thread) break;
                        bl3 = false;
                    }
                }
                if (bl3) {
                    this.writeHolder = thread;
                    int n = ++this.writeCount;
                    bl2 = true;
                    this.lockStatus = 2;
                    if (!DEBUG_DEADLOCK) continue;
                    if (this.writeTrace == null) {
                        this.writeTrace = new Object[10];
                    }
                    if (this.writeTrace.length < n) {
                        Object[] objectArray = new Object[n + 10];
                        System.arraycopy(this.writeTrace, 0, objectArray, 0, this.writeTrace.length);
                        this.writeTrace = objectArray;
                    }
                    this.writeTrace[n - 1] = new Exception("WriteLock Acquired");
                    continue;
                }
                try {
                    if (bl) {
                        this.wait(5000L);
                        continue;
                    }
                    boolean bl4 = false;
                    return bl4;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeUnlock() {
        Thread thread = Thread.currentThread();
        ReadWriteLock readWriteLock = this;
        synchronized (readWriteLock) {
            int n;
            if (this.writeHolder != thread) {
                throw new IllegalStateException("writeUnlock() - lock not held");
            }
            if ((n = --this.writeCount) == 0) {
                this.writeHolder = null;
                if (DEBUG_DEADLOCK) {
                    this.writeTrace = null;
                }
            }
            if (this.writeCount == 0) {
                this.lockStatus = this.numReaders == 0 ? 0 : 1;
                this.notifyAll();
            }
        }
    }

    public void assertLockNotHeld() {
        if (this.holdingReadLock() || this.holdingWriteLock()) {
            throw new IllegalStateException("assert - lock is held");
        }
    }

    public void assertLockHeld() {
        if (!this.holdingReadLock() && !this.holdingWriteLock()) {
            throw new IllegalStateException("assert - lock not held");
        }
    }

    public void assertReadLockHeld() {
        if (!this.holdingReadLock()) {
            throw new IllegalStateException("assert - read lock not held");
        }
    }

    public void assertWriteLockHeld() {
        if (!this.holdingWriteLock()) {
            throw new IllegalStateException("assert - write lock not held");
        }
    }

    public boolean isReadLockHeld() {
        return this.holdingReadLock();
    }

    public boolean isWriteLockHeld() {
        return this.holdingWriteLock();
    }

    public boolean isLockHeld() {
        return this.isReadLockHeld() || this.isWriteLockHeld();
    }

    private boolean holdingReadLock() {
        Thread thread = Thread.currentThread();
        if (this.lockStatus == 1 && this.numReaders > 0) {
            int n = this.readHolderList.length;
            int n2 = 0;
            while (n2 < n) {
                if (this.readHolderList[n2] == thread) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private boolean holdingWriteLock() {
        Thread thread = Thread.currentThread();
        return this.writeHolder == thread && this.lockStatus == 2 && this.writeCount != 0;
    }

    private static void debugPrint() {
        DEBUG_STREAM.println();
    }

    private static void debugPrint(String string) {
        DEBUG_STREAM.println("RWLock: " + string);
    }

    private static void debugPrintStackTrace(Throwable throwable) {
        throwable.printStackTrace(DEBUG_STREAM);
    }

    private static void dumpStack(String string) {
        ReadWriteLock.debugPrint("RWLock: " + string);
        ReadWriteLock.debugPrintStackTrace(new Throwable());
    }

    private void dumpDeadlockTrace() {
        ReadWriteLock.debugPrint("RWLock: Dumping Deadlock Traces");
        ReadWriteLock.debugPrint();
        ReadWriteLock.debugPrint("Since lock/unlock pairs can be nested, all");
        ReadWriteLock.debugPrint("locations where a lock was requested by a");
        ReadWriteLock.debugPrint("current holder are shown.");
        ReadWriteLock.debugPrint();
        ReadWriteLock.debugPrint("-----------------------------------------");
        ReadWriteLock.debugPrint();
        ReadWriteLock.debugPrint("Current requester thread: " + Thread.currentThread().getName());
        ReadWriteLock.debugPrint();
        ReadWriteLock.debugPrint("Requester stack trace: ");
        new Exception("Requesting lock").printStackTrace();
        int n = this.readHolderList.length;
        int n2 = 0;
        while (n2 < n) {
            Thread thread = (Thread)this.readHolderList[n2];
            if (thread != null) {
                ReadWriteLock.debugPrint();
                ReadWriteLock.debugPrint(" - - - - - - - - - - - - - - - - - - -");
                ReadWriteLock.debugPrint();
                int n3 = this.readCountList[n2];
                Object[] objectArray = (Object[])this.readTraceList[n2];
                ReadWriteLock.debugPrint("Read holder Thread: " + thread.getName());
                ReadWriteLock.debugPrint("Read count: " + n3);
                ReadWriteLock.debugPrint();
                int n4 = objectArray.length;
                int n5 = 0;
                while (n5 < n4) {
                    Exception exception = (Exception)objectArray[n5];
                    if (exception != null) {
                        ReadWriteLock.debugPrint("Location: " + n5);
                        ReadWriteLock.debugPrint();
                        exception.printStackTrace();
                        ReadWriteLock.debugPrint();
                    }
                    ++n5;
                }
                ReadWriteLock.debugPrint();
                ReadWriteLock.debugPrint();
            }
            ++n2;
        }
        if (this.writeHolder != null) {
            ReadWriteLock.debugPrint();
            ReadWriteLock.debugPrint(" - - - - - - - - - - - - - - - - - - -");
            ReadWriteLock.debugPrint();
            Thread thread = (Thread)this.writeHolder;
            ReadWriteLock.debugPrint("Write holder thread: " + thread.getName());
            ReadWriteLock.debugPrint("Write count: " + this.writeCount);
            ReadWriteLock.debugPrint();
            int n6 = this.writeTrace.length;
            int n7 = 0;
            while (n7 < n6) {
                Exception exception = (Exception)this.writeTrace[n7];
                if (exception != null) {
                    ReadWriteLock.debugPrint("Location: " + n7);
                    ReadWriteLock.debugPrint();
                    exception.printStackTrace();
                }
                ++n7;
            }
        }
        ReadWriteLock.debugPrint();
        ReadWriteLock.debugPrint("-----------------------------------------");
        ReadWriteLock.debugPrint();
    }

    private void expandReadList() {
        int n;
        int n2;
        if (this.readHolderList == null) {
            n2 = 0;
            n = 3;
        } else {
            n2 = this.readHolderList.length;
            n = n2 * 2;
        }
        Object[] objectArray = new Object[n];
        int[] nArray = new int[n];
        if (n2 > 0) {
            System.arraycopy(this.readHolderList, 0, objectArray, 0, n2);
            System.arraycopy(this.readCountList, 0, nArray, 0, n2);
        }
        this.readHolderList = objectArray;
        this.readCountList = nArray;
        if (DEBUG_DEADLOCK) {
            Object[] objectArray2 = new Object[n];
            if (n2 > 0) {
                System.arraycopy(this.readTraceList, 0, objectArray2, 0, n2);
            }
            this.readTraceList = objectArray2;
        }
    }
}

