/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.buffer;

import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

public final class SafeArrayList
extends AbstractList
implements Cloneable,
RandomAccess {
    private Object[] _data;
    private Object _lock;
    private static final Object[] EMPTY_ARRAY = new Object[0];

    void $init$() {
        this._lock = new Object();
    }

    public SafeArrayList() {
        this.$init$();
        this._data = EMPTY_ARRAY;
    }

    public SafeArrayList(Collection collection) {
        this.$init$();
        this._data = collection.toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this._lock;
        synchronized (object) {
            int n = this._data.length;
            return n;
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean contains(Object object) {
        return this.indexOf(object) >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOf(Object object) {
        Object[] objectArray;
        Object object2 = this._lock;
        synchronized (object2) {
            objectArray = this._data;
        }
        int n = objectArray.length;
        if (object == null) {
            int n2 = 0;
            while (n2 < n) {
                if (objectArray[n2] == null) {
                    return n2;
                }
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < n) {
                if (object.equals(objectArray[n3])) {
                    return n3;
                }
                ++n3;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int lastIndexOf(Object object) {
        Object[] objectArray;
        Object object2 = this._lock;
        synchronized (object2) {
            objectArray = this._data;
        }
        int n = objectArray.length;
        if (object == null) {
            int n2 = n - 1;
            while (n2 >= 0) {
                if (objectArray[n2] == null) {
                    return n2;
                }
                --n2;
            }
        } else {
            int n3 = n - 1;
            while (n3 >= 0) {
                if (object.equals(objectArray[n3])) {
                    return n3;
                }
                --n3;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone() {
        Object object = this._lock;
        synchronized (object) {
            SafeArrayList safeArrayList = new SafeArrayList();
            safeArrayList._data = this._data;
            SafeArrayList safeArrayList2 = safeArrayList;
            return safeArrayList2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray() {
        Object[] objectArray;
        Object object = this._lock;
        synchronized (object) {
            objectArray = this._data;
        }
        int n = objectArray.length;
        Object[] objectArray2 = new Object[n];
        System.arraycopy(objectArray, 0, objectArray2, 0, n);
        return objectArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray(Object[] objectArray) {
        Object[] objectArray2;
        Object object = this._lock;
        synchronized (object) {
            objectArray2 = this._data;
        }
        int n = objectArray2.length;
        if (objectArray.length < n) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
        }
        System.arraycopy(objectArray2, 0, objectArray, 0, n);
        if (objectArray.length > n) {
            objectArray[n] = null;
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(int n) {
        Object object = this._lock;
        synchronized (object) {
            Object object2 = this._data[n];
            return object2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object set(int n, Object object) {
        Object object2 = this._lock;
        synchronized (object2) {
            Object object3 = this._data[n];
            this._data[n] = object;
            Object object4 = object3;
            return object4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Object object) {
        Object object2 = this._lock;
        synchronized (object2) {
            int n = this._data.length;
            Object[] objectArray = new Object[n + 1];
            System.arraycopy(this._data, 0, objectArray, 0, n);
            objectArray[n] = object;
            this._data = objectArray;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(int n, Object object) {
        Object object2 = this._lock;
        synchronized (object2) {
            int n2 = this._data.length;
            Object[] objectArray = new Object[n2 + 1];
            System.arraycopy(this._data, 0, objectArray, 0, n);
            System.arraycopy(this._data, n, objectArray, n + 1, n2 - n);
            objectArray[n] = object;
            this._data = objectArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object object) {
        Object object2 = this._lock;
        synchronized (object2) {
            int n = this.indexOf(object);
            if (n != -1) {
                this.remove(n);
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(int n) {
        Object object = this._lock;
        synchronized (object) {
            int n2 = this._data.length;
            Object object2 = this._data[n];
            Object[] objectArray = new Object[n2 - 1];
            System.arraycopy(this._data, 0, objectArray, 0, n);
            System.arraycopy(this._data, n + 1, objectArray, n, n2 - n - 1);
            this._data = objectArray;
            Object object3 = object2;
            return object3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this._lock;
        synchronized (object) {
            this._data = EMPTY_ARRAY;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(Collection collection) {
        Object[] objectArray = collection.toArray();
        int n = objectArray.length;
        Object object = this._lock;
        synchronized (object) {
            int n2 = this._data.length;
            Object[] objectArray2 = new Object[n2 + n];
            System.arraycopy(this._data, 0, objectArray2, 0, n2);
            System.arraycopy(objectArray, 0, objectArray2, n2, n);
            this._data = objectArray2;
        }
        return n > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(int n, Collection collection) {
        Object[] objectArray = collection.toArray();
        int n2 = objectArray.length;
        Object object = this._lock;
        synchronized (object) {
            int n3 = this._data.length;
            Object[] objectArray2 = new Object[n3 + n2];
            System.arraycopy(this._data, 0, objectArray2, 0, n);
            System.arraycopy(objectArray, 0, objectArray2, n, n2);
            System.arraycopy(this._data, n, objectArray2, n + n2, n3 - n);
            this._data = objectArray2;
        }
        return n2 > 0;
    }

    public boolean removeAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeRange(int n, int n2) {
        int n3 = n2 - n;
        Object object = this._lock;
        synchronized (object) {
            int n4 = this._data.length;
            Object[] objectArray = new Object[n4 - n3];
            System.arraycopy(this._data, 0, objectArray, 0, n);
            System.arraycopy(this._data, n2, objectArray, n, n4 - n2);
            this._data = objectArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterator() {
        Object object = this._lock;
        synchronized (object) {
            SafeListIterator safeListIterator = new SafeListIterator(0, this._data);
            return safeListIterator;
        }
    }

    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListIterator listIterator(int n) {
        Object object = this._lock;
        synchronized (object) {
            SafeListIterator safeListIterator = new SafeListIterator(n, this._data);
            return safeListIterator;
        }
    }

    public List subList(int n, int n2) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Iterator iterator;
        int n;
        Object object = this._lock;
        synchronized (object) {
            n = this._data.length;
            iterator = this.iterator();
        }
        StringBuffer stringBuffer = new StringBuffer("SafeArrayList: ");
        stringBuffer.append(n);
        stringBuffer.append(" objects");
        while (iterator.hasNext()) {
            stringBuffer.append("\n  ");
            stringBuffer.append(iterator.next().toString());
        }
        return stringBuffer.toString();
    }

    protected static class SafeListIterator
    implements ListIterator {
        private Object[] _snapshotData;
        private int _index;
        private int _start;

        protected SafeListIterator(int n, Object[] objectArray) {
            this._snapshotData = objectArray;
            this._index = this._start = n;
        }

        public boolean hasNext() {
            return this._index < this._snapshotData.length;
        }

        public Object next() {
            try {
                if (this._index < this._snapshotData.length) {
                    Object object = this._snapshotData[this._index++];
                    return object;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            throw new NoSuchElementException();
        }

        public boolean hasPrevious() {
            return this._index > this._start;
        }

        public Object previous() {
            try {
                if (this._index > this._start) {
                    Object object = this._snapshotData[--this._index];
                    return object;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            throw new NoSuchElementException();
        }

        public int nextIndex() {
            return this._index;
        }

        public int previousIndex() {
            if (this._index > this._start) {
                return this._index - 1;
            }
            return -1;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void set(Object object) {
            throw new UnsupportedOperationException();
        }

        public void add(Object object) {
            throw new UnsupportedOperationException();
        }
    }
}

