/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.buffer;

import javax.swing.text.Segment;
import oracle.javatools.buffer.ReadTextBuffer;

final class StringReadTextBuffer
implements ReadTextBuffer {
    private String dataSource;

    StringReadTextBuffer(String string) {
        this.dataSource = string;
    }

    public int getLength() {
        return this.dataSource.length();
    }

    public char getChar(int n) throws IndexOutOfBoundsException {
        return this.dataSource.charAt(n);
    }

    public char[] getChars(int n, int n2) throws IndexOutOfBoundsException {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("negative length");
        }
        char[] cArray = new char[n2];
        if (n2 > 0) {
            this.dataSource.getChars(n, n + n2, cArray, 0);
        }
        return cArray;
    }

    public String getString(int n, int n2) throws IndexOutOfBoundsException {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("negative length");
        }
        return this.dataSource.substring(n, n + n2);
    }

    public void getText(int n, int n2, Segment segment) throws IndexOutOfBoundsException {
        segment.array = this.getChars(n, n2);
        segment.offset = 0;
        segment.count = n2;
    }

    public void readLock() {
    }

    public boolean tryReadLock() {
        return true;
    }

    public void readUnlock() {
    }

    public int getLockStatus() {
        return -1;
    }
}

