/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.buffer;

import java.io.IOException;
import java.io.Reader;
import javax.swing.text.Segment;
import oracle.javatools.buffer.ReadTextBuffer;

final class TextBufferReader
extends Reader {
    private ReadTextBuffer textBuffer;
    private int readOffset;
    private int markOffset;
    private Segment scratchSegment;
    private Exception acquireLocation;
    private static final boolean DEBUG_DEADLOCK;

    TextBufferReader(ReadTextBuffer readTextBuffer, int n) {
        readTextBuffer.readLock();
        this.textBuffer = readTextBuffer;
        this.readOffset = n;
        this.markOffset = 0;
        this.scratchSegment = new Segment();
        if (DEBUG_DEADLOCK) {
            this.acquireLocation = new Exception("TextBufferReader acquire location");
        }
    }

    private void verifyOpen() throws IOException {
        if (this.textBuffer == null) {
            throw new IOException("Stream closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.verifyOpen();
            int n = this.textBuffer.getLength();
            if (this.readOffset >= n) {
                int n2 = -1;
                return n2;
            }
            char c = this.textBuffer.getChar(this.readOffset++);
            return c;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.verifyOpen();
            int n3 = this.textBuffer.getLength();
            if (this.readOffset >= n3) {
                int n4 = -1;
                return n4;
            }
            int n5 = n3 - this.readOffset;
            int n6 = Math.min(n5, n2);
            if (n6 > 0) {
                Segment segment = this.scratchSegment;
                this.textBuffer.getText(this.readOffset, n6, segment);
                System.arraycopy(segment.array, segment.offset, cArray, n, n6);
                this.readOffset += n6;
            }
            int n7 = n6;
            return n7;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(long l) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.verifyOpen();
            l = Math.max(0L, l);
            int n = this.textBuffer.getLength();
            int n2 = Math.max(0, n - this.readOffset);
            l = Math.min(l, (long)n2);
            this.readOffset = (int)((long)this.readOffset + l);
            long l2 = l;
            return l2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            boolean bl;
            this.verifyOpen();
            boolean bl2 = bl = this.readOffset < this.textBuffer.getLength();
            return bl2;
        }
    }

    public boolean markSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mark(int n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.verifyOpen();
            this.markOffset = this.readOffset;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.verifyOpen();
            this.readOffset = this.markOffset;
        }
    }

    public void close() {
        this.closeInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean closeInternal() {
        Object object = this.lock;
        synchronized (object) {
            if (this.textBuffer != null) {
                this.textBuffer.readUnlock();
                this.textBuffer = null;
                this.scratchSegment.array = null;
                this.scratchSegment = null;
                this.acquireLocation = null;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    protected void finalize() throws Throwable {
        boolean bl = this.closeInternal();
        if (bl) {
            System.out.println("Warning: TextBufferReader closed by finalizer");
            if (this.acquireLocation != null) {
                this.acquireLocation.printStackTrace(System.out);
                this.acquireLocation = null;
            }
        }
    }

    static {
        String string = System.getProperty("buffer.deadlock.detection");
        DEBUG_DEADLOCK = "true".equalsIgnoreCase(string);
        if (DEBUG_DEADLOCK) {
            System.out.println("TextBuffer reader orphaning detection enabled");
        }
    }
}

