/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.buffer;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import oracle.javatools.buffer.AbstractTextBuffer;
import oracle.javatools.buffer.ReadOnlyException;

class UndoableTextEdit
extends AbstractUndoableEdit {
    private AbstractTextBuffer.UndoState undoState;
    private int offset;
    private int length;
    private char[] data;
    private boolean isInsert;
    private int startChangeId;
    private int endChangeId;
    private UndoableTextEdit nextEdit;
    private UndoableTextEdit previousEdit;

    UndoableTextEdit(AbstractTextBuffer.UndoState undoState) {
        this.undoState = undoState;
        this.offset = -1;
        this.nextEdit = this;
        this.previousEdit = this;
    }

    private AbstractTextBuffer getTextBuffer() {
        return this.undoState.getTextBuffer();
    }

    private boolean isStateAttached() {
        AbstractTextBuffer abstractTextBuffer = this.getTextBuffer();
        return abstractTextBuffer != null;
    }

    void recordStart() {
        AbstractTextBuffer abstractTextBuffer = this.getTextBuffer();
        this.startChangeId = abstractTextBuffer.getChangeId();
    }

    void recordEdit(int n, int n2, char[] cArray, boolean bl) {
        this.offset = n;
        this.length = n2;
        this.data = bl ? null : cArray;
        this.isInsert = bl;
    }

    void recordEnd() {
        AbstractTextBuffer abstractTextBuffer = this.getTextBuffer();
        this.endChangeId = abstractTextBuffer.getChangeId();
    }

    public boolean canUndo() {
        if (!this.isStateAttached()) {
            return false;
        }
        return super.canUndo();
    }

    public void undo() throws CannotUndoException {
        AbstractTextBuffer abstractTextBuffer = this.getTextBuffer();
        if (abstractTextBuffer == null) {
            throw new CannotUndoException();
        }
        abstractTextBuffer.writeLock();
        try {
            try {
                UndoableTextEdit undoableTextEdit = this;
                UndoableTextEdit undoableTextEdit2 = this.previousEdit;
                while (true) {
                    undoableTextEdit2.undoImpl();
                    if (undoableTextEdit2 == undoableTextEdit) {
                        break;
                    }
                    undoableTextEdit2 = undoableTextEdit2.previousEdit;
                }
            }
            catch (ReadOnlyException readOnlyException) {
                throw new IllegalStateException("buffer is read-only");
            }
        }
        finally {
            abstractTextBuffer.writeUnlock();
        }
    }

    protected void undoImpl() throws CannotUndoException {
        AbstractTextBuffer abstractTextBuffer = this.getTextBuffer();
        int n = abstractTextBuffer.getChangeId();
        if (n != this.endChangeId) {
            throw new IllegalStateException("current change id " + n + " does not match " + this.endChangeId);
        }
        super.undo();
        if (this.isInsert) {
            this.data = abstractTextBuffer.getChars(this.offset, this.length);
            abstractTextBuffer.applyRemove(this.offset, this.data, this.startChangeId);
        } else {
            abstractTextBuffer.applyInsert(this.offset, this.data, this.startChangeId);
            this.data = null;
        }
    }

    public boolean canRedo() {
        if (!this.isStateAttached()) {
            return false;
        }
        return super.canRedo();
    }

    public void redo() throws CannotRedoException {
        AbstractTextBuffer abstractTextBuffer = this.getTextBuffer();
        if (abstractTextBuffer == null) {
            throw new CannotRedoException();
        }
        abstractTextBuffer.writeLock();
        try {
            try {
                UndoableTextEdit undoableTextEdit = this;
                UndoableTextEdit undoableTextEdit2 = this;
                do {
                    undoableTextEdit2.redoImpl();
                } while ((undoableTextEdit2 = undoableTextEdit2.nextEdit) != undoableTextEdit);
            }
            catch (ReadOnlyException readOnlyException) {
                throw new IllegalStateException("buffer is read-only");
            }
        }
        finally {
            abstractTextBuffer.writeUnlock();
        }
    }

    protected void redoImpl() throws CannotRedoException {
        AbstractTextBuffer abstractTextBuffer = this.getTextBuffer();
        int n = abstractTextBuffer.getChangeId();
        if (n != this.startChangeId) {
            throw new IllegalStateException("current change id " + n + " does not match " + this.startChangeId);
        }
        super.redo();
        if (this.isInsert) {
            abstractTextBuffer.applyInsert(this.offset, this.data, this.endChangeId);
            this.data = null;
        } else {
            this.data = abstractTextBuffer.getChars(this.offset, this.length);
            abstractTextBuffer.applyRemove(this.offset, this.data, this.endChangeId);
        }
    }

    public boolean addEdit(UndoableEdit undoableEdit) {
        if (undoableEdit instanceof UndoableTextEdit) {
            UndoableTextEdit undoableTextEdit = (UndoableTextEdit)undoableEdit;
            return this.previousEdit.addEditImpl(undoableTextEdit);
        }
        return false;
    }

    protected boolean addEditImpl(UndoableTextEdit undoableTextEdit) {
        boolean bl;
        if (this.endChangeId != undoableTextEdit.startChangeId) {
            return false;
        }
        boolean bl2 = bl = undoableTextEdit.nextEdit != undoableTextEdit;
        if (!bl && this.mergeEdits(this, undoableTextEdit)) {
            this.endChangeId = undoableTextEdit.endChangeId;
            undoableTextEdit.die();
            return true;
        }
        UndoableTextEdit undoableTextEdit2 = this.nextEdit;
        UndoableTextEdit undoableTextEdit3 = this;
        UndoableTextEdit undoableTextEdit4 = undoableTextEdit;
        UndoableTextEdit undoableTextEdit5 = undoableTextEdit.previousEdit;
        undoableTextEdit5.nextEdit = undoableTextEdit2;
        undoableTextEdit2.previousEdit = undoableTextEdit5;
        undoableTextEdit4.previousEdit = undoableTextEdit3;
        undoableTextEdit3.nextEdit = undoableTextEdit4;
        return true;
    }

    public boolean replaceEdit(UndoableEdit undoableEdit) {
        return false;
    }

    private boolean mergeEdits(UndoableTextEdit undoableTextEdit, UndoableTextEdit undoableTextEdit2) {
        if (undoableTextEdit.isInsert == undoableTextEdit2.isInsert) {
            boolean bl = false;
            if (undoableTextEdit.isInsert) {
                if (undoableTextEdit.offset <= undoableTextEdit2.offset && undoableTextEdit2.offset <= undoableTextEdit.offset + undoableTextEdit.length) {
                    bl = true;
                }
            } else if (undoableTextEdit2.offset <= undoableTextEdit.offset && undoableTextEdit.offset <= undoableTextEdit2.offset + undoableTextEdit2.length) {
                bl = true;
                undoableTextEdit.data = this.insertArrays(undoableTextEdit2.data, undoableTextEdit.offset - undoableTextEdit2.offset, undoableTextEdit.data);
                undoableTextEdit.offset = undoableTextEdit2.offset;
            }
            if (bl) {
                undoableTextEdit.length += undoableTextEdit2.length;
                undoableTextEdit2.offset = undoableTextEdit.offset;
                undoableTextEdit2.length = undoableTextEdit.length;
                undoableTextEdit2.data = undoableTextEdit.data;
                return true;
            }
        }
        return false;
    }

    public void die() {
        super.die();
        this.data = null;
        this.undoState = null;
    }

    private char[] insertArrays(char[] cArray, int n, char[] cArray2) {
        char[] cArray3 = new char[cArray.length + cArray2.length];
        System.arraycopy(cArray, 0, cArray3, 0, n);
        System.arraycopy(cArray2, 0, cArray3, n, cArray2.length);
        System.arraycopy(cArray, n, cArray3, n + cArray2.length, cArray.length - n);
        return cArray3;
    }

    private char[] mergeArrays(char[] cArray, char[] cArray2) {
        char[] cArray3 = new char[cArray.length + cArray2.length];
        System.arraycopy(cArray, 0, cArray3, 0, cArray.length);
        System.arraycopy(cArray2, cArray.length, cArray3, 0, cArray2.length);
        return cArray3;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.isInsert ? "insert " : "remove ");
        stringBuffer.append("(" + this.offset + ", " + this.length + ")");
        stringBuffer.append(this.isInsert ? "" : ": " + this.data);
        return stringBuffer.toString();
    }
}

