/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.buffer;

import oracle.javatools.buffer.AbstractTextBuffer;

final class VectorBuffers {
    private char[][] _buffers = new char[20][];
    private int[] _bufferSizes = new int[20];
    private int _bufferCount = 0;

    public int getBufferCount() {
        return this._bufferCount;
    }

    public char[] getBuffer(int n) {
        return this._buffers[n];
    }

    public int getBufferLength(int n) {
        return this._bufferSizes[n];
    }

    public void addBuffer(char[] cArray, int n) {
        if (this._bufferCount == this._buffers.length) {
            char[][] cArrayArray = new char[this._bufferCount + 20][];
            int[] nArray = new int[this._bufferCount + 20];
            System.arraycopy(this._buffers, 0, cArrayArray, 0, this._bufferCount);
            System.arraycopy(this._bufferSizes, 0, nArray, 0, this._bufferCount);
            this._buffers = cArrayArray;
            this._bufferSizes = nArray;
        }
        this._buffers[this._bufferCount] = cArray;
        this._bufferSizes[this._bufferCount] = n;
        ++this._bufferCount;
    }

    public int getTotalLength() {
        int n = 0;
        int n2 = 0;
        while (n2 < this._bufferCount) {
            n += this._bufferSizes[n2];
            ++n2;
        }
        return n;
    }

    private void consolidateBuffers() {
        int n = this.getTotalLength();
        char[] cArray = new char[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < this._bufferCount) {
            int n4 = this._bufferSizes[n3];
            System.arraycopy(this._buffers[n3], 0, cArray, n2, n4);
            n2 += n4;
            ++n3;
        }
        this._buffers = new char[][]{cArray};
        this._bufferSizes = new int[]{n};
        this._bufferCount = 1;
    }

    public char[] getAllBuffers() {
        if (this._bufferCount == 0) {
            return AbstractTextBuffer.EMPTY_CHARS;
        }
        this.consolidateBuffers();
        return this.getBuffer(0);
    }
}

