/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.clipboard;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.LinkedList;
import oracle.javatools.clipboard.ClipboardStackDialog;
import oracle.javatools.clipboard.StackedTransferable;
import oracle.javatools.util.Pair;

public class ClipboardStack {
    private static final int DEFAULT_MAX_ITEMS = 10;
    private LinkedList _stack = new LinkedList();
    private int _maxItems = 10;
    private static ClipboardStack _ccStack;

    private ClipboardStack() {
    }

    public static ClipboardStack getClipboardStack() {
        if (_ccStack == null) {
            _ccStack = new ClipboardStack();
        }
        return _ccStack;
    }

    private static Transferable getCurrentTransferable() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(null);
        if (transferable != null) {
            try {
                if (transferable.isDataFlavorSupported(StackedTransferable.BUFFER_NAME_FLAVOR)) {
                    Transferable transferable2 = transferable;
                    return transferable2;
                }
                if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    Transferable transferable3 = transferable;
                    return transferable3;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static Transferable addTransferableDescription(Transferable transferable, String string, String string2) {
        return new StackedTransferable(transferable, string, string2);
    }

    private void pushObj(Object object) {
        this._stack.addFirst(object);
        while (this._stack.size() > this._maxItems) {
            this._stack.removeLast();
        }
    }

    public static void pushCurrentClipboard() {
        Transferable transferable = ClipboardStack.getCurrentTransferable();
        if (transferable != null) {
            ClipboardStack clipboardStack = ClipboardStack.getClipboardStack();
            clipboardStack.pushObj(transferable);
        }
    }

    public static boolean adjustCurrentClipboard() {
        ClipboardStackDialog clipboardStackDialog = new ClipboardStackDialog();
        Transferable transferable = (Transferable)clipboardStackDialog.runDialog();
        if (transferable != null) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            if (ClipboardStack._ccStack._stack.remove(transferable)) {
                ClipboardStack.pushCurrentClipboard();
            }
            clipboard.setContents(transferable, null);
            return true;
        }
        return false;
    }

    public static int getSize() {
        return ClipboardStack.getClipboardStack()._stack.size();
    }

    private static void addTransferableToList(Transferable transferable, ArrayList arrayList) {
        if (transferable != null) {
            try {
                String string;
                int n;
                String string2 = "";
                string2 = transferable.isDataFlavorSupported(StackedTransferable.BUFFER_NAME_FLAVOR) ? (String)transferable.getTransferData(StackedTransferable.BUFFER_NAME_FLAVOR) : ((n = (string = (String)transferable.getTransferData(DataFlavor.stringFlavor)).indexOf(10)) != -1 ? string.substring(0, n).trim() : string.trim());
                arrayList.add(new Pair(string2, transferable));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static Object[] getContent() {
        ArrayList arrayList = new ArrayList();
        LinkedList linkedList = ClipboardStack.getClipboardStack()._stack;
        ClipboardStack.addTransferableToList(ClipboardStack.getCurrentTransferable(), arrayList);
        for (Transferable transferable : linkedList) {
            ClipboardStack.addTransferableToList(transferable, arrayList);
        }
        Pair[] pairArray = new Pair[arrayList.size()];
        return arrayList.toArray(pairArray);
    }
}

