/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.clipboard;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.javatools.clipboard.ClipboardStack;
import oracle.javatools.clipboard.StackedTransferable;
import oracle.javatools.util.Pair;
import oracle.javatools.util.SwingUtils;

public class ClipboardStackDialog
implements MouseListener,
ListSelectionListener {
    private JList _headerList;
    private JTextArea _textArea;
    private DefaultListModel _model;
    private DismissableJEWTDialog _dialog;

    public Object runDialog() {
        int n;
        boolean bl;
        Object object = null;
        JLabel jLabel = new JLabel();
        this.createModel();
        this._headerList = new JList(this._model);
        this._headerList.getSelectionModel().setSelectionMode(0);
        ClipboardStackDialog.resLabel(jLabel, this._headerList, "&Buffers");
        this._headerList.addListSelectionListener(this);
        this._headerList.addMouseListener(this);
        JLabel jLabel2 = new JLabel();
        this._textArea = new JTextArea();
        ClipboardStackDialog.resLabel(jLabel2, this._textArea, "&Content");
        JPanel jPanel = new JPanel(new GridBagLayout());
        Insets insets = new Insets(2, 2, 2, 2);
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
        jPanel.add((Component)new JScrollPane(this._headerList), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, insets, 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
        jPanel.add((Component)new JScrollPane(this._textArea), new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 18, 1, insets, 0, 0));
        jPanel.setPreferredSize(new Dimension(400, 300));
        HelpUtils.setHelpID((JComponent)jPanel, (String)"f1_xxx");
        this._dialog = new DismissableJEWTDialog();
        this._dialog.setContent(jPanel);
        this._dialog.setResizable(true);
        if (this._model.size() > 0) {
            this._headerList.setSelectedIndex(0);
        }
        if ((bl = this.doInvoke(new 1(this))) && (n = this._headerList.getSelectedIndex()) != -1) {
            Pair pair = (Pair)this._model.getElementAt(n);
            object = pair.getSecond();
        }
        return object;
    }

    public static void resLabel(JLabel jLabel, Component component, String string) {
        jLabel.setText(StringUtils.stripMnemonic((String)string));
        jLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        jLabel.setLabelFor(component);
    }

    private boolean doInvoke(JEWTDialogInvoker jEWTDialogInvoker) {
        if (EventQueue.isDispatchThread()) {
            jEWTDialogInvoker.run();
        } else {
            try {
                EventQueue.invokeAndWait(jEWTDialogInvoker);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return jEWTDialogInvoker.getResponse();
    }

    private void createModel() {
        this._model = new DefaultListModel();
        Object[] objectArray = ClipboardStack.getContent();
        int n = 0;
        while (n < objectArray.length) {
            this._model.addElement(objectArray[n]);
            ++n;
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        boolean bl = false;
        int n = this._headerList.getSelectedIndex();
        if (n != -1) {
            Pair pair = (Pair)this._model.getElementAt(n);
            Transferable transferable = (Transferable)pair.getSecond();
            String string = "";
            try {
                string = transferable.isDataFlavorSupported(StackedTransferable.BUFFER_DESCRIPTION_FLAVOR) ? (String)transferable.getTransferData(StackedTransferable.BUFFER_DESCRIPTION_FLAVOR) : (String)transferable.getTransferData(DataFlavor.stringFlavor);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._textArea.setText(string);
            bl = true;
        }
        this._dialog.setOKButtonEnabled(bl);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() > 1) {
            DismissableJEWTDialog.mav$dismiss(this._dialog);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    static DismissableJEWTDialog ra$_dialog(ClipboardStackDialog clipboardStackDialog) {
        return clipboardStackDialog._dialog;
    }

    public final class 1
    extends JEWTDialogInvoker {
        public boolean doIt() {
            return ClipboardStackDialog.ra$_dialog(ClipboardStackDialog.this).runDialog();
        }

        public 1(ClipboardStackDialog clipboardStackDialog2) {
            super(null);
        }
    }

    private abstract class JEWTDialogInvoker
    implements Runnable {
        private boolean m_response;

        public void run() {
            this.m_response = this.doIt();
        }

        public boolean getResponse() {
            return this.m_response;
        }

        public abstract boolean doIt();

        private JEWTDialogInvoker() {
        }

        JEWTDialogInvoker(1 var2_2) {
            this();
        }
    }

    private static final class DismissableJEWTDialog
    extends JEWTDialog {
        public DismissableJEWTDialog() {
            super(SwingUtils.getMainWindow(), "Paste", 7);
        }

        private void dismiss() {
            this.dismissDialog(false);
        }

        static void mav$dismiss(DismissableJEWTDialog dismissableJEWTDialog) {
            dismissableJEWTDialog.dismiss();
        }
    }
}

