/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.clipboard;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;

public class StackedTransferable
implements Transferable {
    public static final DataFlavor BUFFER_NAME_FLAVOR = new DataFlavor("application/x-java-jvm-local-objectref; class=" + StackedTransferable.class.getName() + "; type=name", "Buffer Name");
    public static final DataFlavor BUFFER_DESCRIPTION_FLAVOR = new DataFlavor("application/x-java-jvm-local-objectref; class=" + StackedTransferable.class.getName() + "; type=desc", "Buffer Description");
    private Transferable _embededTransferable;
    private String _name;
    private String _description;

    public StackedTransferable(Transferable transferable, String string, String string2) {
        this._embededTransferable = transferable;
        this._name = string;
        this._description = string2;
    }

    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] dataFlavorArray = this._embededTransferable.getTransferDataFlavors();
        DataFlavor[] dataFlavorArray2 = new DataFlavor[dataFlavorArray.length + 2];
        dataFlavorArray2[0] = BUFFER_NAME_FLAVOR;
        dataFlavorArray2[1] = BUFFER_DESCRIPTION_FLAVOR;
        System.arraycopy(dataFlavorArray, 0, dataFlavorArray2, 2, dataFlavorArray.length);
        return dataFlavorArray2;
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return dataFlavor.equals(BUFFER_NAME_FLAVOR) || dataFlavor.equals(BUFFER_DESCRIPTION_FLAVOR) || this._embededTransferable.isDataFlavorSupported(dataFlavor);
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (dataFlavor.equals(BUFFER_NAME_FLAVOR)) {
            return this._name;
        }
        if (dataFlavor.equals(BUFFER_DESCRIPTION_FLAVOR)) {
            return this._description;
        }
        return this._embededTransferable.getTransferData(dataFlavor);
    }
}

