/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.codeex;

import java.io.ByteArrayOutputStream;

public class Base64 {
    private static char[] sCharLookup = new char[64];
    private static byte[] sByteLookup = new byte[127];

    static {
        int n = 0;
        int n2 = 65;
        while (n2 <= 90) {
            Base64.sCharLookup[n] = n2;
            n = (byte)(n + 1);
            n2 = (char)(n2 + 1);
        }
        n2 = 97;
        while (n2 <= 122) {
            Base64.sCharLookup[n] = n2;
            n = (byte)(n + 1);
            n2 = (char)(n2 + 1);
        }
        n2 = 48;
        while (n2 <= 57) {
            Base64.sCharLookup[n] = n2;
            n = (byte)(n + 1);
            n2 = (char)(n2 + 1);
        }
        Base64.sCharLookup[n] = 43;
        n = (byte)(n + 1);
        Base64.sCharLookup[n] = 47;
        Base64.sByteLookup[47] = n;
        Base64.sByteLookup[61] = -1;
    }

    public static String base64Encode(byte[] byArray) {
        int n = 0;
        int n2 = byArray.length;
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 4 / 3);
        while (n2 >= 3) {
            stringBuffer.append(sCharLookup[byArray[n] >>> 2 & 0x3F]);
            stringBuffer.append(sCharLookup[((byArray[n] & 3) << 4) + (byArray[n + 1] >>> 4 & 0xF)]);
            stringBuffer.append(sCharLookup[((byArray[n + 1] & 0xF) << 2) + (byArray[n + 2] >>> 6 & 3)]);
            stringBuffer.append(sCharLookup[byArray[n + 2] & 0x3F]);
            n2 -= 3;
            n += 3;
        }
        switch (n2) {
            case 2: {
                stringBuffer.append(sCharLookup[byArray[n] >>> 2 & 0x3F]);
                stringBuffer.append(sCharLookup[((byArray[n] & 3) << 4) + (byArray[n + 1] >>> 4 & 0xF)]);
                stringBuffer.append(sCharLookup[(byArray[n + 1] & 0xF) << 2]);
                stringBuffer.append('=');
                break;
            }
            case 1: {
                stringBuffer.append(sCharLookup[byArray[n] >> 2 & 0x3F]);
                stringBuffer.append(sCharLookup[(byArray[n] & 3) << 4]);
                stringBuffer.append('=');
                stringBuffer.append('=');
            }
        }
        return stringBuffer.toString();
    }

    public static byte[] base64Decode(String string) {
        int n;
        string = Base64.globalReplace(string, "\n", "");
        string = Base64.globalReplace(string, "\r", "");
        char[] cArray = string.toCharArray();
        int n2 = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(cArray.length);
        byte[] byArray = new byte[4];
        for (n = cArray.length; n >= 4; n -= 4) {
            try {
                byArray[0] = sByteLookup[cArray[n2++]];
                if (byArray[0] == -1 || (byArray[1] = sByteLookup[cArray[n2++]]) == -1) {
                    throw new IllegalArgumentException(string);
                }
                byteArrayOutputStream.write(byArray[0] << 2 | byArray[1] >>> 4);
                byArray[2] = sByteLookup[cArray[n2++]];
                if (byArray[2] == -1) {
                    n -= 4;
                    break;
                }
                byteArrayOutputStream.write(byArray[1] << 4 | byArray[2] >>> 2);
                byArray[3] = sByteLookup[cArray[n2++]];
                if (byArray[3] == -1) {
                    n -= 4;
                    break;
                }
                byteArrayOutputStream.write(byArray[2] << 6 | byArray[3]);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new IllegalArgumentException(string);
            }
        }
        if (n > 0) {
            throw new IllegalArgumentException(string);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static final String globalReplace(String string, String string2, String string3) {
        int n = string2.length();
        if (n == 0) {
            return string;
        }
        int n2 = string.indexOf(string2);
        if (n2 == -1) {
            return string;
        }
        int n3 = string.length();
        int n4 = 0;
        StringBuffer stringBuffer = new StringBuffer(n3 + 100);
        do {
            if (n2 > n4) {
                stringBuffer.append(string.substring(n4, n2));
            }
            stringBuffer.append(string3);
        } while ((n4 = n2 + n) < n3 && (n2 = string.indexOf(string2, n4)) != -1);
        if (n4 < n3) {
            stringBuffer.append(string.substring(n4));
        }
        return stringBuffer.toString();
    }
}

