/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.columnlayout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.JPanel;
import oracle.javatools.columnlayout.LayoutComponent;
import oracle.javatools.columnlayout.LayoutGap;
import oracle.javatools.columnlayout.LayoutLeaf;
import oracle.javatools.columnlayout.LayoutPanel;

public class LayoutBuilder {
    public static final Insets ZERO_INSETS = new Insets(0, 0, 0, 0);
    public static final Insets CONTROL_INSETS = new Insets(0, 0, 5, 0);
    public static final Insets LABEL_INSETS = new Insets(2, 0, 5, 12);
    public static final Insets GROUP_INSETS = new Insets(0, 0, 15, 0);
    public static final Dimension ZERO_DIMENSION = new Dimension(0, 0);
    public static final Dimension HORIZONTAL_GAP = new Dimension(24, 0);
    public static final Dimension VERTICAL_GAP = new Dimension(0, 15);
    public static final int ANCHOR_NORTHWEST = 18;
    public static final int ANCHOR_NORTH = 11;
    public static final int ANCHOR_NORTHEAST = 12;
    public static final int ANCHOR_WEST = 17;
    public static final int ANCHOR_CENTER = 10;
    public static final int ANCHOR_EAST = 13;
    public static final int ANCHOR_SOUTHWEST = 16;
    public static final int ANCHOR_SOUTH = 15;
    public static final int ANCHOR_SOUTHEAST = 14;
    public static final int NO_FILL = 0;
    public static final int HORIZONTAL_FILL = 2;
    public static final int VERTICAL_FILL = 3;
    public static final int FILL_BOTH = 1;
    private LayoutPanel m_currentPanel;
    private ArrayList m_stack;
    private int m_defaultAnchor;
    private int m_defaultFill;

    void $init$() {
        this.m_currentPanel = new LayoutPanel();
        this.m_stack = null;
        this.m_defaultAnchor = 18;
        this.m_defaultFill = 0;
    }

    public LayoutComponent getRootComponent() {
        if (this.m_stack != null && this.m_stack.size() > 0) {
            return (LayoutComponent)this.m_stack.get(0);
        }
        return this.m_currentPanel;
    }

    public int getDefaultAnchor() {
        return this.m_defaultAnchor;
    }

    public void setDefaultAnchor(int n) {
        this.m_defaultAnchor = n;
    }

    public int getDefaultFill() {
        return this.m_defaultFill;
    }

    public void setDefaultFill(int n) {
        this.m_defaultFill = n;
    }

    public void addToPanel(Container container) {
        if (container == null) {
            throw new IllegalArgumentException("Cannot have null container for layout");
        }
        if (this.m_stack != null && this.m_stack.size() != 0) {
            throw new IllegalStateException("Stack contains objects, pop everything");
        }
        container.setLayout(new GridBagLayout());
        LayoutComponent layoutComponent = this.getRootComponent();
        int n = layoutComponent.getRowCount();
        boolean[] blArray = new boolean[n];
        layoutComponent.areRowsResizable(blArray, 0, n);
        boolean[] blArray2 = new boolean[layoutComponent.getColumnCount()];
        layoutComponent.areColumnsResizable(blArray2, 0);
        layoutComponent.addToPanel(container, 0, 0, blArray, blArray2, n);
    }

    public void add(LayoutComponent layoutComponent) {
        this.m_currentPanel.add(layoutComponent);
    }

    public void add(Component component, Insets insets, int n, boolean bl, boolean bl2) {
        this.add(component, insets, n, bl, bl2, this.m_defaultAnchor, this.m_defaultFill);
    }

    public void add(Component component, Insets insets, int n, boolean bl, boolean bl2, int n2, int n3) {
        this.m_currentPanel.add(new LayoutLeaf(component, insets, n, bl, bl2, n2, n3));
    }

    public void addHFiller() {
        JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(ZERO_DIMENSION);
        this.add(jPanel, null, 1, false, true);
    }

    public void addVFiller() {
        JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(ZERO_DIMENSION);
        this.add(jPanel, null, 1, true, false);
    }

    public void addVGap() {
        this.add(new LayoutGap(VERTICAL_GAP));
    }

    public void addVGap(int n) {
        this.add(new LayoutGap(0, n));
    }

    public void addHGap() {
        this.add(new LayoutGap(HORIZONTAL_GAP));
    }

    public void addHGap(int n) {
        this.add(new LayoutGap(n, 0));
    }

    public void nl() {
        this.m_currentPanel.nl();
    }

    public void pushPanel() {
        if (this.m_stack == null) {
            this.m_stack = new ArrayList();
        }
        this.m_stack.add(this.m_currentPanel);
        this.m_currentPanel = new LayoutPanel();
    }

    public void popPanel() {
        if (this.m_stack == null || this.m_stack.size() == 0) {
            throw new IllegalStateException("Cannot pop top panel");
        }
        LayoutPanel layoutPanel = (LayoutPanel)this.m_stack.get(this.m_stack.size() - 1);
        this.m_stack.remove(this.m_stack.size() - 1);
        layoutPanel.add(this.m_currentPanel);
        this.m_currentPanel = layoutPanel;
    }

    public LayoutBuilder() {
        this.$init$();
    }
}

