/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.columnlayout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import oracle.javatools.columnlayout.LayoutComponent;

public class LayoutLeaf
implements LayoutComponent {
    private static final Insets ZERO_INSETS = new Insets(0, 0, 0, 0);
    private Component m_component;
    private Insets m_insets;
    private int m_columnSpan;
    private boolean m_isRowResizable;
    private boolean m_isColumnResizable;
    private int m_anchor;
    private int m_fill;

    public LayoutLeaf(Component component, Insets insets, int n, boolean bl, boolean bl2, int n2, int n3) {
        if (component == null) {
            throw new IllegalArgumentException("Component was null");
        }
        if (n < 1) {
            throw new IllegalArgumentException("Component must span some columns");
        }
        this.m_component = component;
        this.m_insets = insets == null ? ZERO_INSETS : insets;
        this.m_columnSpan = n;
        this.m_isRowResizable = bl;
        this.m_isColumnResizable = bl2;
        this.m_anchor = n2;
        this.m_fill = n3;
    }

    public void areRowsResizable(boolean[] blArray, int n, int n2) {
        if (n2 < 1) {
            throw new IllegalArgumentException("Row span is too small");
        }
        if (n2 == 1) {
            int n3 = n;
            blArray[n3] = blArray[n3] | this.m_isRowResizable;
        }
    }

    public void areColumnsResizable(boolean[] blArray, int n) {
        if (this.m_columnSpan == 1) {
            int n2 = n;
            blArray[n2] = blArray[n2] | this.m_isColumnResizable;
        }
    }

    public int getColumnCount() {
        return this.m_columnSpan;
    }

    public int getRowCount() {
        return 1;
    }

    public void addToPanel(Container container, int n, int n2, boolean[] blArray, boolean[] blArray2, int n3) {
        int n4;
        boolean bl = this.checkResizable(this.m_isRowResizable, blArray, n, n3);
        boolean bl2 = this.checkResizable(this.m_isColumnResizable, blArray2, n2, this.m_columnSpan);
        if (bl2 || bl) {
            this.m_component = new ResizerPanel(this.m_component, this.m_anchor, this.m_isColumnResizable || this.m_fill == 2 || this.m_fill == 1, this.m_isRowResizable || this.m_fill == 3 || this.m_fill == 1, bl2, bl);
        }
        if (this.m_isRowResizable || bl) {
            switch (this.m_fill) {
                case 0: {
                    this.m_fill = 3;
                    break;
                }
                case 2: {
                    this.m_fill = 1;
                    break;
                }
            }
        }
        if (this.m_isColumnResizable || bl2) {
            switch (this.m_fill) {
                case 0: {
                    this.m_fill = 2;
                    break;
                }
                case 3: {
                    this.m_fill = 1;
                    break;
                }
            }
        }
        int n5 = n == 0 ? 0 : this.m_insets.top;
        int n6 = n2 == 0 ? 0 : this.m_insets.left;
        int n7 = n + n3 == blArray.length ? 0 : this.m_insets.bottom;
        int n8 = n2 + this.m_columnSpan;
        int n9 = n4 = n8 == blArray2.length ? 0 : this.m_insets.right;
        if (n5 != this.m_insets.top || n6 != this.m_insets.left || n7 != this.m_insets.bottom || n4 != this.m_insets.right) {
            this.m_insets = new Insets(n5, n6, n7, n4);
        }
        container.add(this.m_component, new GridBagConstraints(n2, n, this.m_columnSpan, n3, this.m_isColumnResizable && this.m_columnSpan == 1 ? 1.0 : 0.0, this.m_isRowResizable && n3 == 1 ? 1.0 : 0.0, this.m_anchor, this.m_fill, this.m_insets, 0, 0));
    }

    private boolean checkResizable(boolean bl, boolean[] blArray, int n, int n2) {
        if (bl) {
            return true;
        }
        int n3 = n + n2 - 1;
        while (n3 >= n) {
            if (blArray[n3]) {
                if (!bl && n2 > 1) {
                    throw new IllegalArgumentException("A fixed component cannot span a resizable row");
                }
                return true;
            }
            --n3;
        }
        return false;
    }

    static Insets ra$ZERO_INSETS() {
        return ZERO_INSETS;
    }

    private static class ResizerPanel
    extends JPanel {
        private Component m_component;
        private boolean m_isHorizontallyResizable;
        private boolean m_isVerticallyResizable;
        private Dimension m_preferredSize;

        public ResizerPanel(Component component, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            int n2;
            this.m_component = component;
            this.m_isHorizontallyResizable = bl3;
            this.m_isVerticallyResizable = bl4;
            this.m_preferredSize = this.m_component.getPreferredSize();
            int n3 = n2 = bl ? 2 : 0;
            if (bl2) {
                n2 ^= 3;
            }
            this.setLayout(new GridBagLayout());
            this.add(this.m_component, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, n, n2, LayoutLeaf.ra$ZERO_INSETS(), 0, 0));
        }

        public Dimension getPreferredSize() {
            int n;
            Dimension dimension = this.m_component.getPreferredSize();
            int n2 = this.m_isHorizontallyResizable ? 0 : dimension.width;
            int n3 = n = this.m_isVerticallyResizable ? 0 : dimension.height;
            if (n2 != this.m_preferredSize.width || n != this.m_preferredSize.height) {
                this.m_preferredSize = new Dimension(n2, n);
            }
            return this.m_preferredSize;
        }

        public boolean isEnabled() {
            return this.m_component.isEnabled();
        }

        public boolean isVisible() {
            return this.m_component.isVisible();
        }
    }
}

