/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.compare;

import java.util.ArrayList;
import java.util.List;
import oracle.javatools.compare.CompareHintListener;

public class CompareHints {
    private static String KEY_WHITE_SPACE = "white-space";
    private static String KEY_CHAR_DIFF = "char-diff";
    private static boolean ignoreWhiteSpace = true;
    private static boolean showCharDifferences = false;
    private static List listeners = new ArrayList();

    private CompareHints() {
    }

    public static void addListener(CompareHintListener compareHintListener) {
        if (!listeners.contains(compareHintListener)) {
            listeners.add(compareHintListener);
        }
    }

    public static void removeListener(CompareHintListener compareHintListener) {
        listeners.remove(compareHintListener);
    }

    public static void setIgnoreWhiteSpace(boolean bl) {
        boolean bl2 = ignoreWhiteSpace != bl;
        ignoreWhiteSpace = bl;
        if (bl2) {
            CompareHints.hintUpdated(KEY_WHITE_SPACE);
        }
    }

    public static boolean isIgnoreWhiteSpace() {
        return ignoreWhiteSpace;
    }

    public static void setShowCharDifferences(boolean bl) {
        boolean bl2 = showCharDifferences != bl;
        showCharDifferences = bl;
        if (bl2) {
            CompareHints.hintUpdated(KEY_CHAR_DIFF);
        }
    }

    public static boolean isShowCharDifferences() {
        return showCharDifferences;
    }

    private static void hintUpdated(String string) {
        for (Object e : listeners) {
            if (e == null) continue;
            ((CompareHintListener)e).CompareHintUpdated(string);
        }
    }
}

