/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.compare;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.compare.CompareFailedException;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.compare.CompareModelFactory;
import oracle.javatools.compare.CompareView;
import oracle.javatools.compare.CompareViewFactory;
import oracle.javatools.compare.EditableContributor;
import oracle.javatools.compare.algorithm.text.TextCompareContributor;
import oracle.javatools.compare.view.CustomHorizontalScrollView;
import oracle.javatools.compare.view.NavigableView;
import oracle.javatools.resource.CompareResource;

public final class CompareMain {
    private final File _firstFile;
    private final File _secondFile;
    private final File _ancestorFile;
    private final boolean _ignoreWhitespace;

    private CompareMain(String string, String string2, boolean bl) {
        this(string, string2, null, bl);
    }

    private CompareMain(String string, String string2, String string3, boolean bl) {
        this._firstFile = new File(string);
        this._secondFile = new File(string2);
        this._ancestorFile = string3 != null ? new File(string3) : null;
        this._ignoreWhitespace = bl;
    }

    public static void main(String[] stringArray) throws Exception {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        if (stringArray.length < 2) {
            System.err.println("You must specify two files to compare, or three files to merge.");
            System.err.println();
            System.err.println("Usage:");
            System.err.println("oradiff [-w] first-file second-file [ancestor-file]");
            System.exit(1);
        }
        boolean bl = false;
        int n = stringArray.length;
        if ("-w".equals(stringArray[0])) {
            bl = true;
            --n;
        }
        CompareMain compareMain = null;
        compareMain = new CompareMain(bl ? stringArray[1] : stringArray[0], bl ? stringArray[2] : stringArray[1], bl);
        try {
            compareMain.showCompare();
        }
        catch (CompareFailedException compareFailedException) {
            System.err.println("Unable to compare files: " + compareFailedException.getLocalizedMessage());
        }
    }

    private void showCompare() throws CompareFailedException {
        try {
            CompareModel compareModel;
            if (this._firstFile.equals(this._secondFile)) {
                FileCompareContributor fileCompareContributor = new FileCompareContributor(this._firstFile, this._ignoreWhitespace);
                compareModel = CompareModelFactory.createCompareModel(fileCompareContributor, fileCompareContributor);
            } else {
                compareModel = CompareModelFactory.createCompareModel(new FileCompareContributor(this._firstFile, this._ignoreWhitespace), new FileCompareContributor(this._secondFile, this._ignoreWhitespace));
            }
            if (compareModel.getDifferenceCount() == 0) {
                System.out.println("The two files are identical. Showing diff anyway (maybe I won't in future...)");
            }
            JFrame jFrame = new JFrame("Oracle Diff");
            jFrame.setIconImage(this.getIcon("compare.gif").getImage());
            CompareView compareView = CompareViewFactory.createCompareView(compareModel);
            Component component = compareView.getGUI();
            jFrame.getContentPane().setLayout(new BorderLayout());
            jFrame.getContentPane().add(component, "Center");
            jFrame.setDefaultCloseOperation(3);
            if (compareView instanceof CustomHorizontalScrollView) {
                jFrame.getContentPane().add(((CustomHorizontalScrollView)((Object)compareView)).getHorizontalScrollComponent(), "South");
            }
            JMenuBar jMenuBar = new JMenuBar();
            jMenuBar.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, UIManager.getColor("controlShadow")));
            JMenu jMenu = new JMenu("File");
            jMenuBar.add(jMenu);
            jMenu.setMnemonic('F');
            JMenuItem jMenuItem = new JMenuItem("Exit");
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke("alt pressed F4"));
            jMenu.add(jMenuItem);
            jMenuItem.addActionListener(new 6(this, jMenuItem, jFrame));
            5 var9_9 = new 5(this, "Test", compareView);
            jMenu.add(var9_9);
            jFrame.setJMenuBar(jMenuBar);
            if (compareView instanceof NavigableView) {
                this.installNavigableActions(jFrame, (NavigableView)((Object)compareView));
            }
            jFrame.pack();
            Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(jFrame.getGraphicsConfiguration());
            int n = Toolkit.getDefaultToolkit().getScreenSize().width - insets.left - insets.right;
            int n2 = Toolkit.getDefaultToolkit().getScreenSize().height - insets.top - insets.bottom;
            int n3 = (int)((double)n * 0.7);
            int n4 = (int)((double)n2 * 0.7);
            jFrame.setBounds((n - n3) / 2, (n2 - n4) / 2, n3, n4);
            jFrame.setVisible(true);
            jFrame.toFront();
            if (compareView instanceof NavigableView) {
                ((NavigableView)((Object)compareView)).goToFirstDifference();
            }
        }
        catch (IOException iOException) {
            System.err.println("An error occurred comparing the two files.");
            iOException.printStackTrace();
        }
    }

    private void installNavigableActions(JFrame jFrame, NavigableView navigableView) {
        4 var3_3 = new 4(this, "Go to First Difference", this.getIcon("compare_first.gif"), navigableView);
        var3_3.putValue("ShortDescription", "Go to First Difference");
        var3_3.putValue("AcceleratorKey", KeyStroke.getKeyStroke("alt pressed HOME"));
        3 var4_4 = new 3(this, "Go to Last Difference", this.getIcon("compare_last.gif"), navigableView);
        var4_4.putValue("ShortDescription", "Go to Last Difference");
        var4_4.putValue("AcceleratorKey", KeyStroke.getKeyStroke("alt pressed END"));
        2 var5_5 = new 2(this, "Go to Next Difference", this.getIcon("compare_next.gif"), navigableView);
        var5_5.putValue("ShortDescription", "Go to Next Difference");
        var5_5.putValue("AcceleratorKey", KeyStroke.getKeyStroke("alt pressed RIGHT"));
        1 var6_6 = new 1(this, "Go to Previous Difference", this.getIcon("compare_prev.gif"), navigableView);
        var6_6.putValue("ShortDescription", "Go to Previous Difference");
        var6_6.putValue("AcceleratorKey", KeyStroke.getKeyStroke("alt pressed LEFT"));
        JMenu jMenu = new JMenu("Compare");
        jMenu.setMnemonic('C');
        jFrame.getJMenuBar().add(jMenu);
        jMenu.add(var3_3);
        jMenu.add(var6_6);
        jMenu.add(var5_5);
        jMenu.add(var4_4);
        JToolBar jToolBar = new JToolBar();
        jToolBar.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, UIManager.getColor("controlShadow")));
        jToolBar.add(var3_3);
        jToolBar.add(var6_6);
        jToolBar.add(var5_5);
        jToolBar.add(var4_4);
        jFrame.getContentPane().add((Component)jToolBar, "North");
    }

    private ImageIcon getIcon(String string) {
        return new ImageIcon(CompareResource.class.getResource("/oracle/javatools/icons/images/" + string));
    }

    static File ra$_ancestorFile(CompareMain compareMain) {
        return compareMain._ancestorFile;
    }

    public final class 6
    implements ActionListener {
        private final /* synthetic */ JMenuItem v$exit;
        private final /* synthetic */ JFrame v$frame;
        final /* synthetic */ CompareMain this$0;

        public void actionPerformed(ActionEvent actionEvent) {
            this.v$exit.removeActionListener(this);
            this.v$frame.setVisible(false);
            this.v$frame.dispose();
        }

        public 6(CompareMain compareMain, JMenuItem jMenuItem, JFrame jFrame) {
            this.v$frame = jFrame;
            this.v$exit = jMenuItem;
            this.this$0 = compareMain;
        }
    }

    public final class 5
    extends AbstractAction {
        private final /* synthetic */ CompareView v$view;
        final /* synthetic */ CompareMain this$0;

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (CompareMain.ra$_ancestorFile(this.this$0) == null) {
                    this.v$view.setModel(CompareModelFactory.createCompareModel(this.this$0.new FileCompareContributor(new File("C:\\TestOne.java"), false), this.this$0.new FileCompareContributor(new File("C:\\TestTwo.java"), false)));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public 5(CompareMain compareMain, String string, CompareView compareView) {
            this.v$view = compareView;
            this.this$0 = compareMain;
            super(string);
        }
    }

    public final class 4
    extends AbstractAction {
        private final /* synthetic */ NavigableView v$view;
        final /* synthetic */ CompareMain this$0;

        public void actionPerformed(ActionEvent actionEvent) {
            this.v$view.goToFirstDifference();
        }

        public 4(CompareMain compareMain, String string, Icon icon, NavigableView navigableView) {
            this.v$view = navigableView;
            this.this$0 = compareMain;
            super(string, icon);
        }
    }

    public final class 3
    extends AbstractAction {
        private final /* synthetic */ NavigableView v$view;
        final /* synthetic */ CompareMain this$0;

        public void actionPerformed(ActionEvent actionEvent) {
            this.v$view.goToLastDifference();
        }

        public 3(CompareMain compareMain, String string, Icon icon, NavigableView navigableView) {
            this.v$view = navigableView;
            this.this$0 = compareMain;
            super(string, icon);
        }
    }

    public final class 2
    extends AbstractAction {
        private final /* synthetic */ NavigableView v$view;
        final /* synthetic */ CompareMain this$0;

        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.v$view.goToNextDifference()) {
                this.v$view.goToFirstDifference();
            }
        }

        public 2(CompareMain compareMain, String string, Icon icon, NavigableView navigableView) {
            this.v$view = navigableView;
            this.this$0 = compareMain;
            super(string, icon);
        }
    }

    public final class 1
    extends AbstractAction {
        private final /* synthetic */ NavigableView v$view;
        final /* synthetic */ CompareMain this$0;

        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.v$view.goToPreviousDifference()) {
                this.v$view.goToLastDifference();
            }
        }

        public 1(CompareMain compareMain, String string, Icon icon, NavigableView navigableView) {
            this.v$view = navigableView;
            this.this$0 = compareMain;
            super(string, icon);
        }
    }

    private class FileCompareContributor
    extends TextCompareContributor
    implements EditableContributor {
        private final File _file;
        private final TextBuffer _textBuffer;
        private final String _type;
        private final boolean _editable;

        public FileCompareContributor(File file, boolean bl) throws IOException {
            this.setIgnoreWhitespace(bl);
            this._file = file;
            this._textBuffer = TextBufferFactory.createTextBuffer();
            this._textBuffer.read(new FileReader(file));
            this._textBuffer.clearModified();
            this._editable = file.canWrite();
            int n = this._file.getName().lastIndexOf(46);
            this._type = n > 0 && n < this._file.getName().length() - 2 ? this._file.getName().substring(n + 1) : "";
            this.addTextBufferListeners();
        }

        public TextBuffer getTextBuffer() {
            return this._textBuffer;
        }

        public String getShortLabel() {
            return this._file.getName();
        }

        public String getLongLabel() {
            return this._file.getPath();
        }

        public String getType() {
            return this._type;
        }

        public boolean isEditable() {
            return this._editable;
        }

        public boolean isModified() {
            return this.getTextBuffer().isModified();
        }

        public void save() throws IOException {
            FileWriter fileWriter = new FileWriter(this._file);
            this._textBuffer.write(fileWriter);
            fileWriter.close();
            this._textBuffer.clearModified();
        }
    }
}

