/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.compare;

import java.util.HashMap;
import java.util.Map;
import oracle.javatools.compare.CompareAlgorithm;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.CompareFailedException;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.compare.CompareType;
import oracle.javatools.compare.algorithm.directory.DirectoryCompareAlgorithm;
import oracle.javatools.compare.algorithm.text.TextCompareAlgorithm;

public final class CompareModelFactory {
    private static final Map _algorithms = new HashMap();

    static {
        CompareModelFactory.registerCompareAlgorithm(CompareType.TEXT, TextCompareAlgorithm.class);
        CompareModelFactory.registerCompareAlgorithm(CompareType.DIRECTORY, DirectoryCompareAlgorithm.class);
    }

    private CompareModelFactory() {
    }

    public static final void registerCompareAlgorithm(CompareType compareType, Class clazz) {
        _algorithms.put(compareType, clazz);
    }

    public static CompareModel createCompareModel(CompareContributor compareContributor, CompareContributor compareContributor2) throws CompareFailedException {
        return CompareModelFactory.createCompareModel(compareContributor, compareContributor2, CompareType.TEXT);
    }

    public static CompareModel createCompareModel(CompareContributor compareContributor, CompareContributor compareContributor2, CompareType compareType) throws CompareFailedException {
        CompareAlgorithm compareAlgorithm = null;
        Class clazz = (Class)_algorithms.get(compareType);
        try {
            if (clazz != null) {
                compareAlgorithm = (CompareAlgorithm)clazz.newInstance();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (!compareAlgorithm.canCompare(compareContributor, compareContributor2)) {
            compareAlgorithm = null;
        }
        if (compareAlgorithm != null) {
            CompareModel compareModel = compareAlgorithm.compare(compareContributor, compareContributor2);
            compareModel.setType(compareType);
            return compareModel;
        }
        throw new IllegalArgumentException("cannot create compare model with " + compareContributor + " and " + compareContributor2);
    }
}

