/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.compare;

import java.util.HashMap;
import java.util.Map;
import oracle.javatools.compare.CompareMode;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.compare.CompareType;
import oracle.javatools.compare.CompareView;
import oracle.javatools.compare.ContributorKind;
import oracle.javatools.compare.view.wedge.WedgeCompareView;

public final class CompareViewFactory {
    private static final Map _views = new HashMap();

    static {
        CompareViewFactory.registerCompareView(CompareType.TEXT, WedgeCompareView.class);
        CompareViewFactory.registerCompareView(CompareType.DIRECTORY, WedgeCompareView.class);
    }

    private CompareViewFactory() {
    }

    public static final void registerCompareView(CompareType compareType, Class clazz) {
        _views.put(compareType, clazz);
    }

    public static CompareView createCompareView(CompareModel compareModel) {
        return CompareViewFactory.createView(compareModel, CompareMode.TWO_WAY_COMPARE);
    }

    public static CompareView createMergeView(CompareModel compareModel) {
        return CompareViewFactory.createView(compareModel, CompareMode.THREE_WAY_MERGE);
    }

    private static CompareView createView(CompareModel compareModel, CompareMode compareMode) {
        if (compareMode == CompareMode.THREE_WAY_MERGE && compareModel.getContributor(ContributorKind.ANCESTOR) == null) {
            throw new IllegalArgumentException("merge view requires ancestor contributor kind");
        }
        CompareView compareView = null;
        Class clazz = (Class)_views.get(compareModel.getType());
        try {
            if (clazz != null) {
                compareView = (CompareView)clazz.getConstructor(CompareMode.class).newInstance(compareMode);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (compareView != null) {
            compareView.setModel(compareModel);
            return compareView;
        }
        throw new IllegalArgumentException("cannot create compare view with " + compareModel + " and " + compareMode);
    }
}

