/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.compare.algorithm.directory;

import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.javatools.compare.algorithm.text.TextCompareElement;
import oracle.javatools.util.BundleLoader;

public class DirectoryFile
extends TextCompareElement
implements Comparable {
    private final String _name;
    private final String _id;
    private final boolean _directory;

    public DirectoryFile(boolean bl, String string, String string2) {
        this._directory = bl;
        this._name = string;
        this._id = string2;
    }

    public static final DirectoryFile parseFile(String string) throws ParseException {
        Pattern pattern = Pattern.compile("^(.+?)( ([^ ]+))?$");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.matches()) {
            throw new ParseException("", 0);
        }
        String string2 = matcher.group(1);
        DirectoryFile directoryFile = new DirectoryFile(string2.endsWith("/"), string2.replace('/', ' ').trim(), matcher.group(3));
        return directoryFile;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this._name);
        if (this._directory) {
            stringBuffer.append('/');
        }
        if (this._id != null) {
            stringBuffer.append(' ');
            stringBuffer.append(this._id);
        }
        return stringBuffer.toString();
    }

    public String getName() {
        return this._name;
    }

    public String getID() {
        return this._id;
    }

    public boolean isDirectory() {
        return this._directory;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DirectoryFile)) {
            return false;
        }
        DirectoryFile directoryFile = (DirectoryFile)object;
        return this._name.equals(directoryFile.getName());
    }

    public int compareTo(Object object) {
        return this.toString().compareTo(((DirectoryFile)object).toString());
    }

    public char[] getChars() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(MessageFormat.format(this._directory ? this.getBundle().getString("DIRECTORY_LABEL") : this.getBundle().getString("FILE_LABEL"), this._name));
        stringBuffer.append('\n');
        return stringBuffer.toString().toCharArray();
    }

    private ResourceBundle getBundle() {
        return BundleLoader.getBundle("oracle.javatools.resource.CompareResource");
    }
}

