/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.compare.algorithm.directory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Observable;
import oracle.javatools.compare.algorithm.directory.DirectoryFile;

public class DirectoryList
extends Observable {
    private final ArrayList _files;
    private Object _clearState;

    void $init$() {
        this._files = new ArrayList();
        this._clearState = null;
        this.clearModified();
    }

    public DirectoryFile getFile(int n) {
        return (DirectoryFile)this._files.get(n);
    }

    public int getSize() {
        return this._files.size();
    }

    public void appendFile(DirectoryFile directoryFile) {
        int n = this.binarySearch(directoryFile);
        if (n >= 0) {
            throw new IllegalStateException();
        }
        this._files.add(Math.abs(n + 1), directoryFile);
        this.clearModified();
    }

    public void insertFile(int n, DirectoryFile directoryFile) {
        this._files.add(n, directoryFile);
        this.setChanged();
    }

    public DirectoryFile removeFile(int n) {
        DirectoryFile directoryFile = (DirectoryFile)this._files.remove(n);
        this.setChanged();
        return directoryFile;
    }

    public void clearModified() {
        boolean bl = this.isModified();
        this._clearState = this.getState();
        if (bl) {
            this.setChanged();
        }
    }

    public boolean isModified() {
        return this._clearState != null && !this._clearState.equals(this.getState());
    }

    void sort() {
        Collections.sort(this._files);
    }

    DirectoryFile[] getFiles() {
        return this._files.toArray(new DirectoryFile[0]);
    }

    int indexOf(DirectoryFile directoryFile) {
        return this._files.indexOf(directoryFile);
    }

    int binarySearch(DirectoryFile directoryFile) {
        return Collections.binarySearch(this._files, directoryFile);
    }

    private Object getState() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < this.getSize()) {
            arrayList.add(this.getFile(n).toString());
            ++n;
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public DirectoryList() {
        this.$init$();
    }
}

